/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseRESTService;
import com.ibm.bi.platform.moser.core.rest.service.IResource;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class UserProfileService
extends BaseRESTService {
    public static final String SESSION_MODULE = "_sessionTemp";
    public static final String SESSION_REPORT = "_sessionReport";

    protected UserProfileService(RESTClientConfig c) {
        super(c);
    }

    public RESTClientResponse delete(UserProfileResource resource, String id, UserProfileSubResource subResource, String subResourceId) {
        return this.deleteResource(resource, id, subResource, subResourceId, null, null);
    }

    public RESTClientResponse get(UserProfileResource resource, String id, UserProfileSubResource subResource, String subResourceId) {
        return this.getResource(resource, id, subResource, subResourceId, null, null, new String[0]);
    }

    public RESTClientResponse post(UserProfileResource resource, String id, UserProfileSubResource subResource, String subResourceId, JSONObject value) {
        return this.postResource(resource, id, subResource, subResourceId, null, null, value);
    }

    public RESTClientResponse put(UserProfileResource resource, String id, UserProfileSubResource subResource, String subResourceId, JSONObject value) {
        return this.putResource(resource, id, subResource, subResourceId, null, null, value);
    }

    public void logoff() {
        this.delete(UserProfileResource.LOGIN, null, null, null);
    }

    public static boolean isSessionModule(String id) {
        return StringUtils.isNotEmpty((CharSequence)id) && !MoserUtil.isStoreId(id) && id.endsWith(SESSION_MODULE);
    }

    public static boolean isSessionReport(String id) {
        return StringUtils.isNotEmpty((CharSequence)id) && !MoserUtil.isStoreId(id) && id.endsWith(SESSION_REPORT);
    }

    public static enum UserProfileSubResource implements IResource
    {
        ACCOUNT("account"),
        CAPABILITIES("capabilities"),
        CREDENTIALS("credentials"),
        CREDENTIALS_DATASOURCES("credentials/datasources"),
        IDENTITY("identity"),
        MODULES("modules"),
        PREFERENCES("preferences"),
        REPORTS("reports"),
        USER_PROFILE_SETTINGS("user_profile_settings");

        private final String value;

        private UserProfileSubResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static enum UserProfileResource implements IResource
    {
        LOGIN("login"),
        TEMP("temp"),
        USERS("users/~");

        private final String value;

        private UserProfileResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

