/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseService;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class VersionService
extends BaseService {
    private static final String CACHE_HIT = "Version cache hit for: {} version: {}";
    private static final String CACHE_MISS = "Version cache miss, but now stored for: {} version: {}";
    private static final String VERSION_URL = MoserConfig.getBaseURL() + "/versions";
    private static final Cache<String, Long> cache = CacheBuilder.newBuilder().maximumSize(MoserConfig.getVersionServiceCacheSize()).expireAfterWrite(MoserConfig.getVersionServiceCacheExpiry(), TimeUnit.SECONDS).build();

    public VersionService(RESTClientConfig r) {
        super(r);
    }

    public JSONObject getVersions(List<String> ids) {
        if (ids.isEmpty()) {
            return null;
        }
        ArrayList<String> storeIds = new ArrayList<String>(ids);
        JSONObject result = new JSONObject();
        Iterator iter = storeIds.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Long version = (Long)cache.getIfPresent((Object)id);
            if (version == null) continue;
            LoggerAdapter.debug((Object)this, CACHE_HIT, id, version);
            result.put((Object)id, (Object)version);
            iter.remove();
        }
        if (storeIds.isEmpty()) {
            return result;
        }
        JSONObject idPayload = new JSONObject();
        JSONArray idArray = new JSONArray();
        idPayload.put((Object)"storeIDs", (Object)idArray);
        idArray.addAll(storeIds);
        RESTClientResponse response = this.post(VERSION_URL, idPayload);
        if (response.getResponseCode() != Response.Status.CREATED.getStatusCode() && response.getResponseCode() != Response.Status.OK.getStatusCode()) {
            return null;
        }
        JSONObject versionResult = response.getJSONObjectResponse();
        if (versionResult != null) {
            for (Object o : versionResult.entrySet()) {
                Map.Entry entry = (Map.Entry)o;
                String id = (String)entry.getKey();
                Long version = (Long)entry.getValue();
                LoggerAdapter.debug((Object)this, CACHE_MISS, id, version);
                cache.put((Object)id, (Object)version);
                result.put((Object)id, (Object)version);
                storeIds.remove(id);
            }
        }
        if (!storeIds.isEmpty()) {
            LoggerAdapter.debug((Object)this, "can't get version for {}", storeIds);
            return null;
        }
        return result;
    }

    public void updateCache(String id, Long version) {
        if (StringUtils.isNotEmpty((CharSequence)id) && version != null) {
            cache.put((Object)id, (Object)version);
        }
    }

    @Override
    protected RESTClient getClient() {
        return this.getTrustedClient();
    }
}

