/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.smarts;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.taxonomy.TaxonomyUtil;
import com.ibm.bi.platform.moser.core.module.util.BaseOverrides;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.Relation;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class SmartsServiceUtil {
    private static final String PARAMETERS = "/metadata?shortIdForExpression=true";
    private static final String METADATA = "/metadata";
    private static final String DOT = ".";

    private SmartsServiceUtil() {
    }

    public static boolean createSmartsModule(String sourceId, Module module, UseSpecType sourceType, Optional<String> moduleId, SmartsService.AnalysisMode analysisMode, RequestEnvironment runtime, Consumer<Void> preAction) {
        TaskStatus dummyStatus = new TaskStatus("PENDING");
        return SmartsServiceUtil.createSmartsModule(sourceId, module, sourceType, moduleId, preAction, analysisMode, runtime, null, dummyStatus, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSmartsModule(String sourceId, Module module, UseSpecType sourceType, Optional<String> moduleId, Consumer<Void> preAction, SmartsService.AnalysisMode analysisMode, RequestEnvironment runtime, JSONObject loadOptions, TaskStatus status, String connectionInfo) {
        try {
            LoggerAdapter.info(SmartsServiceUtil.class, "Start discovering knowledge from metadata and data.");
            String moduleIdString = moduleId.isPresent() ? moduleId.get() : (sourceType == UseSpecType.FILE || sourceType == UseSpecType.DATASET ? runtime.getModuleObjectManager().getBaseModuleStoreID(sourceId) : sourceId);
            String completeModuleUri = sourceType == UseSpecType.FILE ? MoserConfig.getBaseURL() + METADATA + ModuleObjectManager.getBaseModuleHRef(moduleIdString) + PARAMETERS : MoserConfig.getBaseURL() + METADATA + ModuleObjectManager.getModuleHRef(moduleIdString) + PARAMETERS;
            preAction.accept(null);
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            if (sourceType == UseSpecType.PACKAGE) {
                runtime.getModuleObjectManager().updateBaseModule(sourceId, null, null);
            }
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            RESTClientResponse response = runtime.getSmartsService().createSmartsModule(sourceId, completeModuleUri, MoserUtil.getCMType(sourceType), analysisMode, loadOptions, connectionInfo);
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            Pair<String, String> createResponse = runtime.getSmartsService().parseCreateSmartsModuleResponse(response);
            String smartsModuleUri = createResponse.getFirst();
            String progressUri = createResponse.getSecond();
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            if (progressUri == null || smartsModuleUri == null) {
                status.setState("ERROR");
                status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.MSR_SMT_INTERNAL_POST_SMARTS, runtime.getProductLocale()));
                status.setTaskStep(null);
                LoggerAdapter.error(SmartsServiceUtil.class, "Failed discovering knowledge from metadata and data, progress and smarts module URIs missing from response.");
                boolean bl = false;
                return bl;
            }
            if (sourceType == UseSpecType.MODULE) {
                runtime.getSmartsService().waitForKnowledgeDiscoveryComplete(progressUri, status, runtime.getProductLocale());
                if (status.isError()) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                SmartsModule smartsModule = runtime.getSmartsService().getSmartsModule(smartsModuleUri, progressUri, status, runtime.getProductLocale());
                if (status.isError()) {
                    boolean bl = false;
                    return bl;
                }
                SmartsServiceUtil.applySmarts(runtime.getModuleObjectManager(), sourceId, module, smartsModule, sourceType, loadOptions, status);
                if (status.isError()) {
                    boolean bl = false;
                    return bl;
                }
            }
            LoggerAdapter.info(SmartsServiceUtil.class, "End discovering knowledge from metadata and data.");
            if (status.isError()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (sourceType != UseSpecType.MODULE) {
                SmartsServiceUtil.writeSmartsStatusToCM(sourceId, sourceType, runtime.getModuleObjectManager(), loadOptions, status);
            }
        }
        return true;
    }

    private static void writeSmartsStatusToCM(String sourceId, UseSpecType sourceType, IModuleObjectManager mm, JSONObject loadOptions, TaskStatus status) {
        TaskStatus smartsStatus;
        if (status == null) {
            return;
        }
        if (status.isExecuting()) {
            status.setState("NOT_CANCELLABLE");
        }
        if (!(smartsStatus = status.clone()).isError() && !smartsStatus.isCancelled()) {
            smartsStatus.setState("SUCCESS");
        }
        String loadOptionsStr = loadOptions == null ? null : loadOptions.toString();
        mm.updateResourceHistory(sourceType, sourceId, MoserUtil.getCurrentTimeGregorianUTC(), null, loadOptionsStr, smartsStatus);
        if (status.isNotCancellable()) {
            status.setState("EXECUTING");
        }
    }

    public static List<Relationship> proposeJoins(String moduleId, RequestEnvironment runtime, Class<?> callClz, String ... querySubjects) {
        LoggerAdapter.info(callClz, "Start creating join proposales for query subjects \"" + Arrays.toString(querySubjects) + "\" for " + moduleId);
        List<Relationship> relationships = SmartsServiceUtil.getProposeJoins(moduleId, runtime, callClz, querySubjects);
        LoggerAdapter.info(callClz, "End creating join proposales for query subject \"" + Arrays.toString(querySubjects) + "\" for " + moduleId);
        return relationships;
    }

    public static boolean smartsDecorateDataModule(Module module, SmartsService ss, TaskStatus t, JSONObject loadOptions) {
        RESTClientResponse resp;
        boolean infoEnabled = LoggerAdapter.isInfoEnabled(SmartsServiceUtil.class);
        if (infoEnabled) {
            LoggerAdapter.info(SmartsServiceUtil.class, "Start Smarts for Data Module: " + module.toJSON().toString());
        }
        if ((resp = ss.postModule(module.toJSON())).getResponseCode() != Response.Status.OK.getStatusCode()) {
            t.setState("ERROR");
            t.setResponse(resp.toResponse());
            t.setTaskStep(null);
            return false;
        }
        byte[] smartsModuleBytes = resp.getRawResponse();
        SmartsModule sm = SmartsService.decodeSmartsModule(smartsModuleBytes);
        if (infoEnabled) {
            try {
                LoggerAdapter.info(SmartsServiceUtil.class, "End Smarts for Data Module. Smart Module: " + JAXBHelper.marshalToJSON((Object)sm));
            }
            catch (IOException e) {
                LoggerAdapter.errorExceptionStack(SmartsServiceUtil.class, e);
            }
        }
        SmartsServiceUtil.applySmartsQuerySubjects(module, sm, UseSpecType.MODULE, true, loadOptions);
        SmartsServiceUtil.applySmartsCalculations(module, sm, UseSpecType.MODULE, true, loadOptions);
        return true;
    }

    private static void applySmartsCalculations(Module module, SmartsModule sm, UseSpecType sourceType, boolean b, JSONObject loadOptions) {
        HashMap columnInfoMap = new HashMap();
        DatasetInfo calculations = SmartsServiceUtil.getCalculations(sm);
        if (calculations == null) {
            return;
        }
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)calculations).forEach(column -> columnInfoMap.put(column.getId(), column));
        for (Calculation calc : module.getCalculation()) {
            ColumnInfo smartColumn = (ColumnInfo)columnInfoMap.get(calc.getIdentifier());
            if (smartColumn != null) {
                SmartsServiceUtil.setTaxonomy((BaseQueryItemType)calc, smartColumn, b);
                SmartsServiceUtil.setUsageAndRegularAggregate((BaseQueryItemType)calc, smartColumn, sourceType);
                SmartsServiceUtil.setLabel((BaseQueryItemType)calc, smartColumn, sourceType, loadOptions);
                continue;
            }
            LoggerAdapter.warn(SmartsServiceUtil.class, "missing smarts for calculation " + calc.getIdentifier());
        }
    }

    private static DatasetInfo getCalculations(SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().filter(ds -> DatasetType.CALCULATIONS.equals((Object)ds.getType())).findFirst().orElse(null);
    }

    private static List<Relationship> getProposeJoins(String moduleId, RequestEnvironment runtime, Class<?> callClz, String ... querySubjects) {
        List relationships = Collections.emptyList();
        SmartsService smarts = runtime.getSmartsService();
        RESTClientResponse response = smarts.getJoinProposals(moduleId, querySubjects);
        if (response.getResponseCode() != 200) {
            return relationships;
        }
        JSONArray moduleProposals = (JSONArray)response.getJSONObjectResponse().get((Object)"moduleProposals");
        if (moduleProposals != null && !moduleProposals.isEmpty()) {
            if (moduleProposals.size() > 1) {
                LoggerAdapter.info(callClz, "Received more than 1 moduleProposals, will only consider the first one.");
            }
            JSONCodec codec = new JSONCodec();
            Module proposal = (Module)codec.decode(Module.class, moduleProposals.get(0).toString());
            relationships = proposal.getRelationship();
        }
        return relationships;
    }

    private static void applySmartsQuerySubjects(Module module, SmartsModule smartsModule, UseSpecType sourceType, boolean b, JSONObject loadOptions) {
        Map<String, Pair<DatasetInfo, Map<String, ColumnInfo>>> datasetMap = SmartsServiceUtil.buildSmartMap(smartsModule);
        module.getQuerySubject().forEach(qs -> {
            Pair datasetPair = (Pair)datasetMap.get(qs.getIdentifier());
            if (datasetPair != null) {
                SmartsServiceUtil.setLabel((ObjectType)qs, (DatasetInfo)datasetPair.getFirst(), sourceType, loadOptions);
                qs.getItem().forEach(item -> {
                    QueryItem qi = item.getQueryItem();
                    if (qi != null) {
                        ColumnInfo smartColumn = (ColumnInfo)((Map)datasetPair.getSecond()).get(qi.getIdentifier());
                        if (smartColumn != null) {
                            SmartsServiceUtil.setTaxonomy((BaseQueryItemType)qi, smartColumn, b);
                            SmartsServiceUtil.setUsageAndRegularAggregate((BaseQueryItemType)qi, smartColumn, sourceType);
                            SmartsServiceUtil.setLabel((BaseQueryItemType)qi, smartColumn, sourceType, loadOptions);
                        } else {
                            LoggerAdapter.warn(SmartsServiceUtil.class, "missing smarts for query item " + qi.getIdentifier());
                        }
                    }
                });
            } else {
                LoggerAdapter.warn(SmartsServiceUtil.class, "missing smarts for query subject " + qs.getIdentifier());
            }
        });
    }

    private static void applySmarts(IModuleObjectManager moduleObjectManager, String sourceId, Module module, SmartsModule smartsModule, UseSpecType sourceType, JSONObject loadOptions, TaskStatus status) {
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        if (smartsModule == null) {
            return;
        }
        SmartsServiceUtil.applySmartsQuerySubjects(module, smartsModule, sourceType, sourceType != UseSpecType.MODULE, loadOptions);
        SmartsServiceUtil.applySmartsCalculations(module, smartsModule, sourceType, sourceType != UseSpecType.MODULE, loadOptions);
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        if (status != null) {
            status.setState("NOT_CANCELLABLE");
        }
        if (UseSpecType.PACKAGE.equals((Object)sourceType)) {
            DataModuleExtractor.removeModuleMetadata((Module)module);
            Module moduleWithTaxonomyOnly = BaseOverrides.generateTaxonomyDiffs(module, null);
            moduleObjectManager.updateBaseModule(sourceId, moduleWithTaxonomyOnly, null);
        } else {
            BaseOverrides.extractSecurityFilters(module);
            moduleObjectManager.updateBaseModule(sourceId, module, null);
        }
    }

    private static void setTaxonomy(BaseQueryItemType qi, ColumnInfo smartColumn, boolean b) {
        if (!b) {
            return;
        }
        qi.getTaxonomy().clear();
        TaxonomyType taxonomyType = SmartsServiceUtil.getTaxonomy(smartColumn);
        if (taxonomyType != null) {
            qi.getTaxonomy().add(taxonomyType);
        }
    }

    private static TaxonomyType getTaxonomy(ColumnInfo smartColumn) {
        List<String> concepts = SmartsServiceUtil.getAttributeAndLeafCategoryConcept(smartColumn.getSemanticInfo());
        if (concepts != null) {
            for (String concept : concepts) {
                TaxonomyType taxonomyType = TaxonomyUtil.getAFTaxonomy(concept);
                if (taxonomyType == null) continue;
                return taxonomyType;
            }
        }
        return null;
    }

    private static List<String> getAttributeAndLeafCategoryConcept(SemanticInfo semanticInfo) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List<ConceptInfo> columnConcepts = SmartsServiceUtil.getSortedDomainConcepts(semanticInfo);
        if (!columnConcepts.isEmpty()) {
            ConceptInfo topConcept = columnConcepts.remove(0);
            ConceptInfo attributeConcept = null;
            ConceptInfo categoryConcept = null;
            for (Relation r : semanticInfo.getRelations()) {
                if (r.getEndFrom().getConceptID().equals(topConcept.getConceptID())) {
                    attributeConcept = r.getEndTo();
                    categoryConcept = topConcept;
                    break;
                }
                if (!r.getEndTo().getConceptID().equals(topConcept.getConceptID())) continue;
                attributeConcept = topConcept;
                categoryConcept = r.getEndFrom();
                break;
            }
            if (attributeConcept == null) {
                attributeConcept = topConcept;
            }
            result.add(ConceptsUtil.getConceptName((ConceptInfo)attributeConcept));
            if (categoryConcept != null) {
                result.add(ConceptsUtil.getConceptName(categoryConcept));
            }
        }
        return new ArrayList<String>(result);
    }

    private static boolean parentHasConcept(ConceptInfo c, String aConcept) {
        Concept concept = ConceptsRegistry.instance().getConcept(c.getConceptID());
        if (concept == null) {
            return false;
        }
        return concept.getAncestors().stream().anyMatch(a -> a.getIRI().equals(aConcept));
    }

    private static List<ConceptInfo> getSortedDomainConcepts(SemanticInfo semanticInfo) {
        return semanticInfo == null ? Collections.emptyList() : semanticInfo.getConcepts().stream().filter(c -> "http://www.ibm.com/ontologies/waca/domain/common".equals(ConceptsUtil.getOntologyId((ConceptInfo)c))).sorted((o1, o2) -> {
            int result = Float.compare(o2.getConfidence(), o1.getConfidence());
            if (result == 0) {
                if (SmartsServiceUtil.parentHasConcept(o2, o1.getConceptID())) {
                    result = 1;
                } else if (SmartsServiceUtil.parentHasConcept(o1, o2.getConceptID())) {
                    result = -1;
                }
            }
            return result;
        }).collect(Collectors.toList());
    }

    private static Map<String, Pair<DatasetInfo, Map<String, ColumnInfo>>> buildSmartMap(SmartsModule smartsModule) {
        HashMap<String, Pair<DatasetInfo, Map<String, ColumnInfo>>> datasetMap = new HashMap<String, Pair<DatasetInfo, Map<String, ColumnInfo>>>();
        smartsModule.getDatasets().forEach(dataset -> {
            HashMap columnInfoMap = new HashMap();
            datasetMap.put(dataset.getId(), new Pair((DatasetInfo)dataset, columnInfoMap));
            SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset).forEach(column -> columnInfoMap.put(column.getId(), column));
        });
        return datasetMap;
    }

    private static void setUsageAndRegularAggregate(BaseQueryItemType queryItem, ColumnInfo smartsColumn, UseSpecType sourceType) {
        SemanticInfo semanticInfo;
        if (sourceType == UseSpecType.DATASET || sourceType == UseSpecType.PACKAGE) {
            return;
        }
        String expression = queryItem.getExpression();
        if (!(expression != null && expression.contains("unsupported") || (semanticInfo = smartsColumn.getSemanticInfo()) == null)) {
            queryItem.setUsage(SmartsServiceUtil.getUsage(semanticInfo));
            queryItem.setRegularAggregate(SmartsServiceUtil.getRegularAggregate(semanticInfo));
        }
    }

    private static UsageType getUsage(SemanticInfo columnInfo) {
        switch (columnInfo.getUsage()) {
            case ATTRIBUTE: {
                return UsageType.ATTRIBUTE;
            }
            case FACT: {
                return UsageType.FACT;
            }
            case IDENTIFIER: {
                return UsageType.IDENTIFIER;
            }
            case AUTOMATIC: {
                return UsageType.AUTOMATIC;
            }
        }
        LoggerAdapter.error(SmartsServiceUtil.class, "unrecognized usage " + columnInfo.getUsage().name());
        return UsageType.ATTRIBUTE;
    }

    private static RegularAggregateType getRegularAggregate(SemanticInfo semanticInfo) {
        AggregationType defaultAggregation = semanticInfo.getDefaultAggregation();
        if (defaultAggregation == null) {
            return RegularAggregateType.NONE;
        }
        switch (defaultAggregation) {
            case AVERAGE: {
                return RegularAggregateType.AVERAGE;
            }
            case SUM: {
                return RegularAggregateType.TOTAL;
            }
            case COUNT: {
                return RegularAggregateType.COUNT;
            }
            case COUNT_DISTINCT: {
                return RegularAggregateType.COUNT_DISTINCT;
            }
            case NONE: {
                return RegularAggregateType.NONE;
            }
        }
        try {
            return RegularAggregateType.fromValue((String)defaultAggregation.value());
        }
        catch (IllegalArgumentException e) {
            LoggerAdapter.errorExceptionStack(SmartsServiceUtil.class, e);
            return RegularAggregateType.NONE;
        }
    }

    private static void setLabel(ObjectType theObject, DatasetInfo smartDataset, UseSpecType sourceType, JSONObject loadOptions) {
        if (!SmartsServiceUtil.getLabelNeedsSetting(sourceType, loadOptions)) {
            return;
        }
        String label = smartDataset.getPrettyName();
        if (label != null && !label.isEmpty()) {
            theObject.setLabel(label);
        }
    }

    private static boolean getLabelNeedsSetting(UseSpecType sourceType, JSONObject loadOptions) {
        if (loadOptions != null && Boolean.FALSE.equals(((JSONObject)loadOptions.get((Object)"loadOptions")).get((Object)"prettifyLabels"))) {
            return false;
        }
        if (sourceType == UseSpecType.FILE && !MoserConfig.getFileCleanTableLabels()) {
            return false;
        }
        return sourceType != UseSpecType.DATASET && sourceType != UseSpecType.PACKAGE;
    }

    private static void setLabel(BaseQueryItemType queryItem, ColumnInfo smartColumn, UseSpecType sourceType, JSONObject loadOptions) {
        if (loadOptions != null && Boolean.FALSE.equals(((JSONObject)loadOptions.get((Object)"loadOptions")).get((Object)"prettifyLabels"))) {
            return;
        }
        if (sourceType == UseSpecType.FILE && !MoserConfig.getFileCleanColumnLabels()) {
            return;
        }
        if (sourceType == UseSpecType.DATASET || sourceType == UseSpecType.PACKAGE) {
            return;
        }
        String label = smartColumn.getPrettyName();
        if (label != null && !label.isEmpty()) {
            queryItem.setLabel(label);
        }
    }

    public static void mergeSmarts(Module module, Module smartsModule, String moduleAlias) {
        if (smartsModule == null) {
            return;
        }
        boolean overrideMode = module.isOverrideMode();
        module.setOverrideMode(false);
        HashMap<String, QuerySubject> smartsQSMap = new HashMap<String, QuerySubject>();
        for (QuerySubject qs : smartsModule.getQuerySubject()) {
            if (moduleAlias != null && !moduleAlias.isEmpty()) {
                smartsQSMap.put(moduleAlias + DOT + qs.getIdentifier(), qs);
                continue;
            }
            smartsQSMap.put(qs.getIdentifier(), qs);
        }
        for (QuerySubject qs : module.getQuerySubject()) {
            QuerySubject smartsQS = (QuerySubject)smartsQSMap.get(qs.getIdentifier());
            if (smartsQS == null) continue;
            block2: for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                for (QueryItem smartsQI : MoserObjectUtils.getQueryItems((QuerySubject)smartsQS)) {
                    if (!qi.getIdentifier().equals(smartsQI.getIdentifier())) continue;
                    SmartsServiceUtil.setSmartsTaxonomy((BaseQueryItemType)qi, (BaseQueryItemType)smartsQI);
                    continue block2;
                }
            }
        }
        HashMap<String, Calculation> smartsCalcMap = new HashMap<String, Calculation>();
        for (Calculation calc : smartsModule.getCalculation()) {
            if (moduleAlias != null && !moduleAlias.isEmpty()) {
                smartsCalcMap.put(moduleAlias + DOT + calc.getIdentifier(), calc);
                continue;
            }
            smartsCalcMap.put(calc.getIdentifier(), calc);
        }
        for (Calculation calc : module.getCalculation()) {
            Calculation smartCalc = (Calculation)smartsCalcMap.get(calc.getIdentifier());
            if (smartCalc == null) continue;
            SmartsServiceUtil.setSmartsTaxonomy((BaseQueryItemType)calc, (BaseQueryItemType)smartCalc);
        }
        module.setOverrideMode(overrideMode);
    }

    private static void setSmartsTaxonomy(BaseQueryItemType qi, BaseQueryItemType smartsQI) {
        qi.getTaxonomy().clear();
        for (TaxonomyType taxonomy : smartsQI.getTaxonomy()) {
            try {
                TaxonomyType clone = (TaxonomyType)taxonomy.clone();
                qi.addTaxonomy(clone);
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.errorExceptionStack(SmartsServiceUtil.class, e);
            }
        }
    }

    public static void initSmartsSubtask(TaskStatus status, Locale productLocale) {
        status.getTaskStep().incrementStepNumber();
        status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_DISCOVER_KNOWLEDGE, (Locale)productLocale));
        TaskStep taskStep = new TaskStep();
        taskStep.setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_PERFORMING_ANALYSIS, (Locale)productLocale));
        status.getTaskStep().setCurrentSubtask(taskStep);
    }

    public static void initSmartsSubtask(TaskStatus status, Locale productLocale, String fileName) {
        status.getTaskStep().incrementStepNumber();
        status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_DISCOVER_KNOWLEDGE, (Locale)productLocale, (String)fileName));
        TaskStep taskStep = new TaskStep();
        taskStep.setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_PERFORMING_ANALYSIS, (Locale)productLocale));
        status.getTaskStep().setCurrentSubtask(taskStep);
    }
}

