/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.IMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public abstract class BaseMoserTask
implements IMoserTask {
    public static final String IMPORT_DATABASE = "import database metadata";
    public static final String FILE_UPLOAD = "file upload";
    public static final String COLLECT_SMARTS = "collect smarts";
    protected URI baseURI;
    protected TaskStatus status;
    protected HttpServletRequest request;
    protected RequestEnvironment requestEnv;
    private CountDownLatch cancelLatch = new CountDownLatch(1);
    private String taskID = null;
    private long maxCancelWaitTimeInSeconds = 10L;

    public BaseMoserTask(RequestEnvironment requestEnv) {
        this.requestEnv = requestEnv;
        if (requestEnv != null) {
            this.request = requestEnv.getHttpServletRequest();
        }
        this.status = new TaskStatus("PENDING");
    }

    @Override
    public synchronized TaskStatus getStatus() {
        return this.status;
    }

    public static boolean equalsNulls(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    public int hashCodeSeed() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseURI == null ? 0 : this.baseURI.hashCode());
        return result;
    }

    public boolean isEqual(Object obj) {
        return obj instanceof BaseMoserTask && BaseMoserTask.equalsNulls(this.baseURI, ((BaseMoserTask)obj).baseURI) && !this.getStatus().getState().equals("ERROR");
    }

    @Override
    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    public static void throwIfCancelled(TaskStatus status, String operation) {
        if (status != null && status.isCancelled()) {
            throw new MoserCancelException(operation);
        }
    }

    protected synchronized void setErrorParm1(IMessageKey.Param1 msgkey, String parm1) {
        Locale locale = this.getRuntimeEnv().getProductLocale();
        this.status.setState("ERROR");
        this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)msgkey, (Locale)locale, (String)parm1));
        this.status.setResponse(MoserUtil.getResponse(Response.Status.NOT_FOUND, msgkey, locale, parm1));
    }

    protected synchronized void setErrorParm2(IMessageKey.Param2 msgkey, String param1, String param2) {
        Locale locale = this.getRuntimeEnv().getProductLocale();
        this.status.setState("ERROR");
        this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param2)msgkey, (Locale)locale, (String)param1, (String)param2));
        this.status.setResponse(MoserUtil.getResponse(Response.Status.NOT_FOUND, msgkey, locale, param1, param2));
    }

    @Override
    public synchronized boolean cancel() {
        if (!this.status.canCancel()) {
            return false;
        }
        this.cancelRemoteTask();
        this.status.setState("CANCELLED");
        return true;
    }

    @Override
    public synchronized void setStatus(TaskStatus aStatus) {
        this.status = aStatus;
    }

    public final void handleCancel(MoserCancelException e) {
        this.cancelHandler(e);
        this.signalDone();
    }

    private void signalDone() {
        this.cancelLatch.countDown();
    }

    public abstract void cancelHandler(MoserCancelException var1);

    @Override
    public void awaitCancellation() {
        try {
            if (!this.cancelLatch.await(this.maxCancelWaitTimeInSeconds, TimeUnit.SECONDS)) {
                LoggerAdapter.debug(this, "Task was removed from MoserTaskManager before a cancel was fully completed");
            }
        }
        catch (InterruptedException e) {
            LoggerAdapter.debug((Object)this, "Task cancel waiting got interrupted", e);
        }
    }

    protected synchronized void completeWithSuccess(MoserInfo response) {
        if (this.status.isCancelled()) {
            throw new MoserCancelException(FILE_UPLOAD);
        }
        this.status.response = response;
        this.status.state = "SUCCESS";
    }

    @Override
    public void setRuntimeEnv(RequestEnvironment runtime) {
        if (runtime != null) {
            this.requestEnv = runtime;
            this.request = runtime.getHttpServletRequest();
        }
    }

    @Override
    public final RequestEnvironment getRuntimeEnv() {
        return this.requestEnv;
    }
}

