/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserExceedQuotaException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.UserInfo;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class FileImportUtils {
    public static final int COMPRESSION_RATIO = 10;

    private FileImportUtils() {
    }

    public static boolean exceededQuotas(JSONObject jsonUserInfo, long fileSize, Locale productLocale, TaskStatus status) {
        long maxStorage = (Long)jsonUserInfo.get((Object)"maxStorageBytes");
        long totalSizeOnDisk = (Long)jsonUserInfo.get((Object)"totalSizeOnDisk");
        long fileSizeOnDisk = fileSize / 10L;
        if (totalSizeOnDisk > maxStorage || totalSizeOnDisk + fileSizeOnDisk > maxStorage) {
            String quota = new DecimalFormat("###.##", DecimalFormatSymbols.getInstance((Locale)productLocale)).format((double)totalSizeOnDisk / 1024.0 / 1024.0);
            String msg = MoserMessages.getMessage((IMessageKey.Param2)MoserError.EXCEEDED_QUOTA, (Locale)productLocale, (String)quota, (String)((Long)jsonUserInfo.get((Object)"DatasetService.maxStorageMBytes")).toString());
            JSONObject entity = new JSONObject();
            entity.put((Object)"msg", (Object)msg);
            Response response = Response.status((int)413).type("application/json").entity((Object)entity).build();
            status.setState("ERROR");
            status.setResponse(response);
            status.setErrorMessage(msg);
            return true;
        }
        long maxUploadSize = (Long)jsonUserInfo.get((Object)"maxUploadSizeBytes");
        if (fileSize > maxUploadSize) {
            String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_TOO_LARGE, (Locale)productLocale, (String)((Long)jsonUserInfo.get((Object)"DatasetService.maxUploadSizeMBytes")).toString());
            JSONObject entity = new JSONObject();
            entity.put((Object)"msg", (Object)msg);
            Response response = Response.status((int)413).type("application/json").entity((Object)entity).build();
            status.setState("ERROR");
            status.setResponse(response);
            status.setErrorMessage(msg);
            return true;
        }
        return false;
    }

    public static void checkQuota(File dataSetFolder, String excludeModuleId, RequestEnvironment requestEnv) {
        int dataSize = 0;
        File[] files = dataSetFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isFile()) continue;
            dataSize = (int)((long)dataSize + f.length());
        }
        if (dataSize == 0) {
            return;
        }
        JSONObject jsonUserInfo = new UserInfo(requestEnv, requestEnv.getUserId()).calculateUsage(excludeModuleId);
        long maxStorage = (Long)jsonUserInfo.get((Object)"maxStorageBytes");
        long totalSizeOnDisk = (Long)jsonUserInfo.get((Object)"totalSizeOnDisk");
        if (totalSizeOnDisk + (long)dataSize > maxStorage) {
            Long maxAllowed = (Long)jsonUserInfo.get((Object)"DatasetService.maxStorageMBytes");
            throw new MoserExceedQuotaException(totalSizeOnDisk, maxAllowed.toString(), requestEnv.getProductLocale());
        }
    }

    public static long getCMFileSize(RequestEnvironment runtime, String uploadedFileId) {
        JSONObject fileInfo;
        JSONObject uploadObject = runtime.getModuleObjectManager().getFileUploadObject(uploadedFileId, null, new String[]{"history"});
        JSONArray history = (JSONArray)uploadObject.get((Object)"history");
        try {
            fileInfo = JSONObject.parse((String)history.get(0).toString());
        }
        catch (IOException e) {
            throw new MoserException((Throwable)e);
        }
        Object size = fileInfo == null ? null : fileInfo.get((Object)"sizeOfFile");
        return size == null ? 0L : Long.parseLong(size.toString());
    }

    public static String getCmObjectType(RequestEnvironment requestEnv, String id, boolean parent) {
        ContentService cs = requestEnv.getContentService();
        RESTClientResponse resp = parent ? cs.get(ContentService.ContentResource.OBJECTS, id, null, null, "parent") : cs.get(ContentService.ContentResource.OBJECTS, id, null, null, "type");
        JSONObject response = resp.getJSONObjectResponse();
        if (Response.Status.OK.getStatusCode() != resp.getResponseCode() || response == null) {
            return null;
        }
        JSONArray data = (JSONArray)response.get((Object)"data");
        JSONObject result = (JSONObject)data.get(0);
        if (parent) {
            JSONArray parents = (JSONArray)result.get((Object)"parent");
            result = parents != null && !parents.isEmpty() ? (JSONObject)parents.get(0) : null;
        }
        return result == null ? null : (String)result.get((Object)"type");
    }
}

