/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.core.importer.file.FileDataCollector;
import com.ibm.bi.platform.moser.core.importer.file.FileRefreshHandler;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.FileUploadTask;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import java.io.InputStream;
import javax.ws.rs.core.Response;

public class FileRefreshTask
extends FileUploadTask {
    public FileRefreshTask(RequestEnvironment requestEnv, FileDataCollector dataCollector) {
        super(requestEnv, dataCollector);
    }

    @Override
    protected Object runImpl() throws Exception {
        this.importHandler = new FileRefreshHandler(this.requestEnv);
        try (InputStream input = this.dataCollector.openContentStream();){
            if (null == input) {
                Response response = MoserUtil.getResponse(Response.Status.BAD_REQUEST, MoserError.MSR_UPL_CONTENT_ERROR, this.requestEnv.getProductLocale());
                return response;
            }
            Object object = ((FileRefreshHandler)this.importHandler).importFile(this.dataCollector.getFileUploadId(), input, this.fileName, this.mimeType, this.fileSize);
            return object;
        }
    }

    @Override
    protected synchronized void completeWithSuccess(MoserInfo response) {
        this.status.response = response;
        this.status.state = "SUCCESS";
    }

    @Override
    protected void undo(MoserInfo response) {
    }
}

