/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.importer.file.FileDataCollector;
import com.ibm.bi.platform.moser.core.importer.file.FileImportHandler;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.UserInfo;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.FileImportUtils;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class FileUploadTask
extends BaseMoserTask {
    protected String fileName;
    protected String mimeType;
    private String destinationId;
    protected FileImportHandler importHandler;
    private boolean fileDeleted = false;
    protected FileDataCollector dataCollector;
    protected long fileSize;

    public FileUploadTask(RequestEnvironment requestEnv, FileDataCollector dataCollector) {
        super(requestEnv);
        this.dataCollector = dataCollector;
        this.destinationId = dataCollector.getDestinationId();
        this.fileName = dataCollector.getFileName();
        this.mimeType = dataCollector.getMimeType();
        this.fileSize = dataCollector.getContentLength();
        this.status = requestEnv.getTaskStatus();
        this.status.setResourceID(dataCollector.getFileUploadId());
        this.status.setTaskType("FileUpload");
        try {
            this.baseURI = new URI(this.request.getContextPath() + this.request.getServletPath());
        }
        catch (URISyntaxException e) {
            LoggerAdapter.error(this, "Invalid URI.");
            LoggerAdapter.errorExceptionStack(this, e);
        }
        Locale productLocale = requestEnv.getProductLocale();
        UserInfo userInfo = new UserInfo(requestEnv, requestEnv.getUserId());
        JSONObject jsonUserInfo = this.getUserInfo(userInfo, dataCollector.getFileUploadId());
        if (dataCollector.getContentLength() > 0L && FileImportUtils.exceededQuotas(jsonUserInfo, dataCollector.getContentLength(), productLocale, this.status)) {
            return;
        }
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FILE_UPLOAD, (Locale)productLocale, (String)this.fileName), 4));
    }

    protected JSONObject getUserInfo(UserInfo userInfo, String uploadedFileId) {
        return userInfo.calculateUsage(uploadedFileId);
    }

    protected IModuleObjectManager getManager() {
        return this.requestEnv.getModuleObjectManager();
    }

    protected void undo(MoserInfo response) {
        this.undo(response.getId());
    }

    protected void undo(String id) {
        if (!this.fileDeleted && id != null) {
            this.fileDeleted = true;
            this.getManager().delete(id, true, true);
        }
    }

    @Override
    protected synchronized void completeWithSuccess(MoserInfo response) {
        if (this.status.isCancelled()) {
            this.undo(response);
            throw new MoserCancelException("file upload");
        }
        this.status.response = response;
        this.status.state = "SUCCESS";
    }

    private synchronized void setExecuting() {
        if ("CANCELLED".equals(this.status.getState())) {
            throw new MoserCancelException("file upload");
        }
        this.status.setState("EXECUTING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Locale productLocale = this.requestEnv.getProductLocale();
        try {
            if (this.status.getState() == "ERROR") {
                return;
            }
            this.setExecuting();
            Object response = this.runImpl();
            if (response != null && response instanceof MoserInfo) {
                this.completeWithSuccess((MoserInfo)response);
            } else {
                if (response != null) {
                    if (response instanceof Response) {
                        JSONObject jObj = (JSONObject)((Response)response).getEntity();
                        if (jObj != null) {
                            this.status.setErrorMessage((String)jObj.get((Object)"msg"));
                        } else {
                            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)productLocale, (String)this.fileName));
                        }
                        this.status.setResponse(response);
                    } else {
                        this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)productLocale, (String)this.fileName));
                        this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, productLocale, this.fileName));
                    }
                } else {
                    this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)productLocale, (String)this.fileName));
                    this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, productLocale, this.fileName));
                }
                this.status.setState("ERROR");
            }
            this.status.setTaskStep(null);
        }
        catch (MoserCancelException c) {
            this.handleCancel(c);
        }
        catch (Throwable e) {
            LoggerAdapter.errorExceptionStack(this, e);
            this.status.setState("ERROR");
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)productLocale, (String)this.fileName));
            this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, productLocale, this.fileName, e));
        }
        finally {
            this.dataCollector.cleanUp();
        }
    }

    protected Object runImpl() throws Exception {
        this.importHandler = new FileImportHandler(this.requestEnv);
        this.importHandler.setDestinationId(this.destinationId);
        try (InputStream input = this.dataCollector.openContentStream();){
            if (null == input) {
                Response response = MoserUtil.getResponse(Response.Status.BAD_REQUEST, MoserError.MSR_UPL_CONTENT_ERROR, this.requestEnv.getProductLocale());
                return response;
            }
            Object object = this.importHandler.importFile(input, this.fileName, this.mimeType, this.fileSize);
            return object;
        }
    }

    @Override
    public void cancelRemoteTask() {
        Object response;
        if ("SUCCESS".equals(this.getStatus().state) && (response = this.getStatus().response) != null && response instanceof MoserInfo) {
            this.undo((MoserInfo)response);
        }
        if (this.requestEnv.getSmartsService() != null && this.importHandler != null && this.importHandler.getFileID() != null) {
            this.requestEnv.getSmartsService().cancelSmartsCollection(this.importHandler.getFileID());
        }
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        if (this.importHandler != null) {
            this.undo(this.importHandler.getFileID());
        }
        LoggerAdapter.error(this, "File upload was cancelled");
    }
}

