/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.cm.History;
import com.ibm.bi.platform.moser.core.cm.HistoryDetailMoserService;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;

public class HistoryUpdater {
    private static final String ERROR = "error";
    private static final String CANCELLED = "cancelled";
    private static final String EXECUTING = "executing";
    private static final String LOADING = "loading";
    private static final String MESSAGE = "message";
    private static final String MESSAGES = "messages";
    private static final String MESSAGE_DETAIL = "messageDetail";
    static final String PENDING = "pending";
    private static final String SEVERITY = "severity";
    private static final String STATISTICS = "statistics";
    private static final String TABLES_LOADED = "tablesLoaded";
    private static final String TABLES_SELECTED = "tablesSelected";
    private static final String HISTORY_EXECUTING = "executing";
    private static final String HISTORY_FAILED = "failed";
    private static final String HISTORY_SUCCEEDED = "succeeded";
    private static final String LOADED = "loaded";
    private static final String SEV_ERROR = "ERROR";
    private static final String SEV_INFO = "INFO";
    String historyStoreId;
    String detailsStoreId;
    JSONObject historyMoserServiceJSON = new JSONObject();
    private String currentStatus;
    private String parentId;
    private ModuleStorageCM cm;
    private JSONObject loadOptions;
    private Locale productLocale;

    public HistoryUpdater(ModuleStorageCM cm, String parentId, String currentStatus, JSONObject loadOptions, Locale productLocale) {
        this.cm = cm;
        this.parentId = parentId;
        this.currentStatus = currentStatus;
        this.loadOptions = loadOptions;
        this.productLocale = productLocale;
    }

    protected boolean init(BaseMoserTask task, String taskName) {
        if (LOADING.equals(this.currentStatus)) {
            return false;
        }
        RESTClientResponse response = this.updateResourceStatus(LOADING);
        if (response.getResponseCode() >= 400) {
            Object error = new ContentServiceException(response.getJSONObjectResponse(), response.getResponseCode());
            if ("CM-REQ-4335".equals(error.getErrorCode())) {
                error = new MoserException(MoserError.MSR_DS_CONNECTION_ACCESS);
                error.setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
            }
            String msg = error.getLocalizedMessage(this.productLocale);
            LoggerAdapter.error(this, msg);
            task.getStatus().setState(SEV_ERROR);
            task.getStatus().setErrorMessage(msg);
            task.getStatus().setResponse(error.getResponse(this.productLocale));
            return false;
        }
        History historyObj = new History();
        HistoryDetailMoserService historyMoserServiceObj = new HistoryDetailMoserService();
        historyObj.setActualExecutionTime(MoserUtil.getCurrentTimeGregorianUTC().toString());
        historyObj.setRequestedExecutionTime(MoserUtil.getCurrentTimeGregorianUTC().toString());
        historyObj.setStatus("executing");
        JSONObject historyJSON = historyObj.toJSONObject();
        historyJSON.put((Object)"type", (Object)"history");
        historyJSON.put((Object)"status", (Object)"executing");
        RESTClientResponse childResp = this.cm.postItems(this.parentId, historyJSON);
        if (childResp.getResponseCode() != 201) {
            return false;
        }
        this.historyStoreId = RESTUtils.getLocationStoreId(childResp);
        historyMoserServiceObj.setDetail("Minor step name");
        historyMoserServiceObj.setStatus(LOADING);
        historyMoserServiceObj.setDetailTime(MoserUtil.getCurrentTimeGregorianUTC().toString());
        historyMoserServiceObj.setProgress(1, "major Info", "minor Info", 12, 1, 11);
        historyMoserServiceObj.setSpecification("all", "1.0", "true", 1000);
        this.historyMoserServiceJSON = historyMoserServiceObj.toJSONObject();
        this.historyMoserServiceJSON.put((Object)"specification", (Object)this.loadOptions);
        this.historyMoserServiceJSON.put((Object)"type", (Object)"historyDetailMoserService");
        this.historyMoserServiceJSON.put((Object)"statusInfo", (Object)new JSONObject());
        childResp = this.cm.postItems(this.historyStoreId, this.historyMoserServiceJSON);
        this.historyMoserServiceJSON.remove((Object)"specification");
        if (childResp.getResponseCode() != 201) {
            String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.CONNECTING_DB_ERROR, (Locale)this.productLocale, (String)taskName);
            LoggerAdapter.error(this, msg);
            task.getStatus().setState(SEV_ERROR);
            task.getStatus().setErrorMessage(msg);
            task.getStatus().setResponse(MoserUtil.getResponse(Response.Status.FORBIDDEN, MoserError.CONNECTING_DB_ERROR, this.productLocale, taskName));
            return false;
        }
        this.detailsStoreId = RESTUtils.getLocationStoreId(childResp);
        return true;
    }

    protected void updateHistoryDetailMessage(String msg, String severity, String messageDetail, String s) {
        this.updateHistoryDetailMessage(msg, severity, messageDetail, s, null);
    }

    protected void updateHistoryDetailMessage(String msg, String severity, String messageDetail, String s, TaskStatus taskStatus) {
        JSONObject si = (JSONObject)this.historyMoserServiceJSON.get((Object)"statusInfo");
        JSONArray messages = (JSONArray)si.get((Object)MESSAGES);
        if (messages == null) {
            messages = new JSONArray();
            si.put((Object)MESSAGES, (Object)messages);
        }
        JSONObject message = new JSONObject();
        message.put((Object)MESSAGE, (Object)msg);
        message.put((Object)SEVERITY, (Object)severity);
        if (messageDetail != null) {
            message.put((Object)MESSAGE_DETAIL, (Object)messageDetail);
        }
        messages.add((Object)message);
        if (s == null) {
            this.historyMoserServiceJSON.remove((Object)"status");
        } else {
            this.historyMoserServiceJSON.put((Object)"status", (Object)s);
        }
        if (taskStatus != null) {
            si.put((Object)"taskStatus", (Object)taskStatus.toJSON());
        }
        this.cm.putResource(this.detailsStoreId, this.historyMoserServiceJSON);
    }

    protected void updateResourceStatusInfo() {
        JSONObject si = (JSONObject)this.historyMoserServiceJSON.get((Object)"statusInfo");
        JSONObject siSchema = new JSONObject();
        siSchema.put((Object)"type", (Object)"dataSourceSchema");
        siSchema.put((Object)"statusInfo", (Object)si);
        this.cm.putResource(this.parentId, siSchema);
    }

    protected void processCancel(MoserCancelException c) {
        if (PENDING.equals(this.currentStatus)) {
            this.cm.delete(this.parentId, true, true);
        } else {
            String msg = c.getLocalizedMessage();
            this.updateResourceStatus(this.currentStatus);
            this.updateHistoryStatus(false);
            this.updateHistoryDetailMessage(msg, SEV_INFO, msg, CANCELLED);
        }
    }

    protected void processError(String msg, String severity, String detail) {
        if (LOADED.equals(this.currentStatus)) {
            String message = MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_RELOAD_SCHEMA_FAIL, (Locale)this.productLocale);
            String currentTime = MoserUtil.formatDateTime(MoserUtil.getCurrentTimeGregorianUTC(), this.productLocale);
            String previousTime = MoserUtil.formatDateTime(this.getLastLoadedTime(), this.productLocale);
            String messageDetail = MoserMessages.getMessage((IMessageKey.Param2)MoserError.MSR_RELOAD_SCHEMA_FAIL, (Locale)this.productLocale, (String)currentTime, (String)previousTime);
            this.updateHistoryDetailMessage(message, SEV_ERROR, messageDetail, ERROR);
            this.updateResourceStatus(LOADED);
        } else {
            this.updateResourceStatus(ERROR);
        }
        this.updateHistoryStatus(false);
        this.updateHistoryDetailMessage(msg, severity, detail, ERROR);
        this.updateResourceStatusInfo();
    }

    private XMLGregorianCalendar getLastLoadedTime() {
        RESTClientResponse resp = this.cm.getItems(this.parentId, "baseModule", "creationTime");
        JSONArray baseModules = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        String lastLoadedTime = "";
        for (Object o : baseModules) {
            JSONObject baseModule = (JSONObject)o;
            String time = (String)baseModule.get((Object)"creationTime");
            if (time.compareTo(lastLoadedTime) <= 0) continue;
            lastLoadedTime = time;
        }
        return MoserUtil.getTimeGregorian(lastLoadedTime);
    }

    protected void updateHistoryStatus(boolean bSucceesed) {
        JSONObject history1 = new JSONObject();
        history1.put((Object)"status", (Object)(bSucceesed ? HISTORY_SUCCEEDED : HISTORY_FAILED));
        history1.put((Object)"type", (Object)"history");
        this.cm.putResource(this.historyStoreId, history1);
    }

    protected RESTClientResponse updateResourceStatus(String schemaStatus) {
        JSONObject sourceSchemaJSON = new JSONObject();
        sourceSchemaJSON.put((Object)"status", (Object)schemaStatus);
        sourceSchemaJSON.put((Object)"type", (Object)"dataSourceSchema");
        return this.cm.putResource(this.parentId, sourceSchemaJSON);
    }

    protected void updateHistoryDetailStatistics(int tablesLoaded, int tablesSelected) {
        JSONObject stats = new JSONObject();
        stats.put((Object)TABLES_LOADED, (Object)tablesLoaded);
        stats.put((Object)TABLES_SELECTED, (Object)tablesSelected);
        JSONObject si = (JSONObject)this.historyMoserServiceJSON.get((Object)"statusInfo");
        si.put((Object)STATISTICS, (Object)stats);
        this.cm.putResource(this.detailsStoreId, this.historyMoserServiceJSON);
    }
}

