/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.api.json.JSONApiError;
import com.ibm.bi.platform.moser.core.api.json.datasource.ModulesData;
import com.ibm.bi.platform.moser.core.api.json.datasource.ModulesResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesBody;
import com.ibm.bi.platform.moser.core.metadata.MetadataEngine;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineConfig;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.module.util.BaseOverrides;
import com.ibm.bi.platform.moser.core.provider.MetadataProviderFactory;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.HistoryUpdater;
import com.ibm.bi.platform.moser.core.tasks.ModuleRowCountTask;
import com.ibm.bi.platform.moser.core.tasks.MoserTaskManager;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class ImportSchemaTask
extends BaseMoserTask {
    private String taskName;
    private String dataSourceId;
    private String dataSourceName;
    private String dataSourceConnectionName = null;
    private String dataSourceSchemaId;
    private String dataSourceSchemaName;
    private String dataSourceSchemaInitStatus;
    private JSONObject dataSourceSchemaSpecification;
    private String catalog;
    private String schema;
    private String username;
    private HistoryUpdater history;
    private MoserConnectionSpec connectionSpec;
    public static final String TABLE_FILTERS = "tableFilters";
    private static final String CLEAN_COLUMN_LABELS = "cleanColumnLabels";
    private static final String CLEAN_TABLE_LABELS = "cleanTableLabels";
    public static final String PRETTIFY_LABELS = "prettifyLabels";
    public static final String DATA_SAMPLING_SIZE = "dataSamplingSize";
    public static final String DATA_STATISTICS = "dataStatistics";
    public static final String EXCLUDED_TABLES = "excludedTables";
    public static final String INCLUDED_TABLES = "includedTables";
    public static final String IMPORT_PRIMARY_FOREIGN_KEYS = "importPrimaryForeignKeys";
    public static final String LOAD_OPTIONS = "loadOptions";
    public static final String VERSION = "version";
    private static final String SEV_ERROR = "ERROR";
    private static final String SEV_INFO = "INFO";
    private static final String SEV_WARNING = "WARNING";
    private static final String LOADED = "loaded";
    private BaseModuleContainer baseModule = null;

    public ImportSchemaTask(RequestEnvironment requestEnv, String schemaStoreID, MoserConnectionSpec connectionSpec, MoserTaskManager tm) throws URISyntaxException {
        super(requestEnv);
        Object ven;
        this.status.setResourceID(schemaStoreID);
        this.status.setTaskType("ImportSchema");
        this.username = requestEnv.getUserId();
        this.connectionSpec = connectionSpec;
        int totalSteps = 7;
        this.baseURI = new URI(this.request.getContextPath() + this.request.getServletPath());
        RESTClientResponse resp = requestEnv.getContentService().get(ContentService.ContentResource.OBJECTS, schemaStoreID, null, null, "defaultName", "ancestors", "status", "catalog", "schema", "specification");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORT_METADATA, (Locale)requestEnv.getProductLocale(), (String)schemaStoreID), 7));
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param0)MoserError.INTERNAL_ERROR, (Locale)requestEnv.getProductLocale()));
            return;
        }
        JSONObject schemaObj = (JSONObject)((JSONArray)resp.getJSONObjectResponse().get((Object)"data")).get(0);
        this.dataSourceSchemaId = schemaStoreID;
        this.dataSourceSchemaName = (String)schemaObj.get((Object)"defaultName");
        this.dataSourceSchemaInitStatus = (String)schemaObj.get((Object)"status");
        this.dataSourceSchemaSpecification = ImportSchemaTask.convertCleanLabelsToPrettifyLabels((JSONObject)schemaObj.get((Object)"specification"));
        this.catalog = (String)schemaObj.get((Object)"catalog");
        this.schema = (String)schemaObj.get((Object)"schema");
        JSONArray ancestors = (JSONArray)schemaObj.get((Object)"ancestors");
        JSONObject ancestor = (JSONObject)ancestors.get(ancestors.size() - 2);
        this.dataSourceId = (String)ancestor.get((Object)"id");
        this.dataSourceName = (String)ancestor.get((Object)"defaultName");
        ancestor = (JSONObject)ancestors.get(ancestors.size() - 1);
        this.dataSourceConnectionName = (String)ancestor.get((Object)"defaultName");
        MoserConnectionSpec cSpec = connectionSpec;
        if (cSpec == null) {
            cSpec = new MoserConnectionSpec(this.dataSourceName, this.dataSourceConnectionName, null);
        }
        if (this.dataSourceSchemaSpecification != null && (ven = this.dataSourceSchemaSpecification.get((Object)"vendor")) instanceof JSONObject) {
            cSpec.addVendor((JSONObject)ven);
        }
        this.requestEnv.setParam("connectionSpec", cSpec.toString());
        this.requestEnv.setParam("dataSourceId", this.dataSourceId);
        this.requestEnv.setParam("catalogName", this.catalog);
        this.requestEnv.setParam("schemaName", this.schema);
        this.taskName = ImportSchemaTask.buildTaskName(this.dataSourceName, this.dataSourceConnectionName, this.dataSourceSchemaName);
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORT_METADATA, (Locale)requestEnv.getProductLocale(), (String)this.taskName), 7));
    }

    private void initHistoryUpdater() {
        this.history = new HistoryUpdater(this.getRuntimeEnv().getModuleStorageCM(), this.dataSourceSchemaId, this.dataSourceSchemaInitStatus, this.dataSourceSchemaSpecification, this.getRuntimeEnv().getProductLocale());
        this.history.init(this, this.taskName);
    }

    private static String buildTaskName(String dataSource, String dataSourceConnection, String dataSourceSchema) {
        StringBuilder composedName = new StringBuilder();
        composedName.append("dataSource=");
        composedName.append(dataSource);
        composedName.append(", dataSourceConnection=");
        composedName.append(dataSourceConnection);
        composedName.append(", dataSourceSchema=");
        composedName.append(dataSourceSchema);
        return composedName.toString();
    }

    @Override
    public void run() {
        if (SEV_ERROR.equals(this.status.getState())) {
            return;
        }
        this.initHistoryUpdater();
        if (SEV_ERROR.equals(this.status.getState())) {
            return;
        }
        Locale productLocale = this.requestEnv.getProductLocale();
        try {
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.status.setState("EXECUTING");
            Module overrides = this.requestEnv.getModuleObjectManager().getBaseModule(this.dataSourceSchemaId, UseSpecType.DATABASE);
            overrides = overrides != null ? BaseOverrides.extractSecurityFilters(overrides) : null;
            this.baseModule = this.requestEnv.getModuleObjectManager().createBaseModuleForDatabase(this.dataSourceId, this.dataSourceSchemaId);
            LoggerAdapter.info(this, "[PERF]: Start MetadataEngine call");
            JSONArray tableFilters = (JSONArray)this.dataSourceSchemaSpecification.get((Object)TABLE_FILTERS);
            JSONArray excludedTables = (JSONArray)this.dataSourceSchemaSpecification.get((Object)EXCLUDED_TABLES);
            TablesBody body = new TablesBody();
            body.setTableFilters(tableFilters);
            MoserJDBCImporter.setInOrExcludedTablesTablesBody(body, this.dataSourceSchemaSpecification);
            MetadataEngine engine = new MetadataEngine(this.requestEnv, new MetadataEngineConfig(MetadataEngineConfig.DEFAULT));
            ModulesResponse modulesResponse = engine.getModules(body);
            this.recordWarnings(modulesResponse.getWarnings());
            LoggerAdapter.info(this, "[PERF]: End - MetadataEngine call");
            LoggerAdapter.info(this, "[PERF]: Start - Base module creation");
            JSONCodec codec = new JSONCodec();
            ModulesData modulesData = modulesResponse.getModules().get(0);
            Module physicalModule = (Module)codec.decode(Module.class, modulesData.getPhysicalDefinition().toString());
            Module baseBusinessModule = (Module)codec.decode(Module.class, modulesData.getBaseDefinition().toString());
            this.baseModule.setPhysicalModule(physicalModule);
            this.baseModule.setBaseModuleOverride(overrides);
            this.baseModule.setBaseBusinessModule(baseBusinessModule);
            this.baseModule.setEndTime(MoserUtil.getCurrentTimeGregorianUTC());
            this.baseModule.setStatus("succeeded");
            LoggerAdapter.info(this, "[PERF]: End - Base module creation");
            LoggerAdapter.info(this, "[PERF]: Start - Saving Base module definition.");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_SAVE_BASEMODULE, (Locale)productLocale, (String)this.taskName));
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.requestEnv.getModuleObjectManager().saveBaseModulesForDatabase(this.baseModule);
            String baseId = this.baseModule.getStoreId();
            String baseModuleHRef = ModuleObjectManager.getBaseModuleHRef(baseId);
            MoserInfo resp = MoserInfoUtil.createMoserInfo(baseModuleHRef, baseId, null, this.dataSourceSchemaName, this.baseModule.getEndTime());
            LoggerAdapter.info(this, "[PERF]: End - Saving Base module definition.");
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryStatus(true);
            LoggerAdapter.info(this, "[PERF]: Start - Update history records");
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Metadata Import import is complete", LOADED, this.status);
            int[] nLoadedSelected = new int[]{0, 0};
            ImportSchemaTask.getLoadedAndSelected(nLoadedSelected, modulesData, null, physicalModule, this.dataSourceSchemaSpecification);
            int tablesLoaded = nLoadedSelected[0];
            int tablesSelected = nLoadedSelected[1];
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryDetailStatistics(tablesLoaded, tablesSelected);
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateResourceStatusInfo();
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateResourceStatus(LOADED);
            LoggerAdapter.info(this, "[PERF]: End - Update history records");
            boolean bOLAP = MetadataProviderFactory.isOLAPConnectionString((String)modulesResponse.getMeta("connectionString"));
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_SMARTS_ANALYSIS, (Locale)productLocale, (String)this.taskName));
            if (!bOLAP) {
                String connSpec;
                LoggerAdapter.info(this, "[PERF]: Start - Smarts analysis");
                SmartsServiceUtil.initSmartsSubtask(this.status, productLocale);
                String string = connSpec = this.connectionSpec == null ? null : this.connectionSpec.toString();
                if (overrides != null) {
                    BaseOverrides.mergeSecurityFilters(baseBusinessModule, overrides);
                }
                SmartsServiceUtil.createSmartsModule(this.dataSourceSchemaId, baseBusinessModule, UseSpecType.DATABASE, Optional.of(baseId), t -> {}, SmartsService.AnalysisMode.DEEP, this.requestEnv, this.getLoadOptions(), this.status, connSpec);
                this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Metadata analysis is complete", LOADED, this.status.clone());
                LoggerAdapter.info(this, "[PERF]: End - Smarts analysis");
            }
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.collectStatistics(bOLAP);
            if (!this.status.isError()) {
                this.status.setResponse(resp);
                this.status.setTaskStep(null);
                this.status.setState("SUCCESS");
                this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Schema import is complete", LOADED, this.status);
            }
        }
        catch (MoserCancelException e) {
            this.handleCancel(e);
        }
        catch (MoserException e) {
            if (this.baseModule != null) {
                this.requestEnv.getModuleStorageCM().delete(this.baseModule.getStoreId(), true, true);
            }
            String msg = e.getLocalizedMessage(productLocale);
            this.history.processError(msg, SEV_ERROR, msg);
            LoggerAdapter.debug((Object)this, msg, e);
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(msg);
            this.status.setResponse(e.getResponse(productLocale));
        }
        catch (Exception e) {
            if (this.baseModule != null) {
                this.requestEnv.getModuleStorageCM().delete(this.baseModule.getStoreId(), true, true);
            }
            String errMsg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.INTERNAL_BASEMODULE_ERROR, (Locale)productLocale, (String)this.taskName);
            String description = this.status.getTaskStep().getCurrentSubTask() != null ? this.status.getTaskStep().getCurrentSubTask().getCurrentStepDescription() : this.status.getTaskStep().getCurrentStepDescription();
            this.history.processError(errMsg + " " + description, SEV_ERROR, e.getLocalizedMessage());
            LoggerAdapter.errorExceptionStack(this, e);
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(errMsg);
            this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.INTERNAL_BASEMODULE_ERROR, productLocale, this.taskName, e));
        }
    }

    private void recordWarnings(JSONArray warnings) {
        if (warnings == null) {
            return;
        }
        for (Object o : warnings) {
            JSONApiError warning = new JSONApiError((JSONObject)o);
            LoggerAdapter.warn(this, "Exception in JMD import metadata: " + warning.getTitle());
            this.history.updateHistoryDetailMessage(warning.getTitle(), SEV_WARNING, warning.getTitle(), null);
        }
    }

    private void collectStatistics(boolean bOLAP) {
        this.status.getTaskStep().incrementStepNumber();
        this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_STATS_COLLECT, (Locale)this.requestEnv.getProductLocale(), (String)this.taskName));
        Long sampling = (Long)this.dataSourceSchemaSpecification.get((Object)DATA_SAMPLING_SIZE);
        boolean stats = "all".equals(this.dataSourceSchemaSpecification.get((Object)DATA_STATISTICS));
        if (!bOLAP && !Long.valueOf(-1L).equals(sampling) && stats) {
            LoggerAdapter.info(this, "[PERF]: Start - Module statistics");
            ModuleRowCountTask task = new ModuleRowCountTask(this.requestEnv, this.baseModule.getStoreId(), this.baseModule.getBaseBusinessModule(), this.connectionSpec, null);
            task.run();
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Module statistics is collected", LOADED, this.status);
            LoggerAdapter.info(this, "[PERF]: End - Module statistics");
        } else {
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Module statistics is skipped", LOADED, this.status);
        }
        BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
    }

    private JSONObject getLoadOptions() {
        JSONObject loadOptions = new JSONObject();
        loadOptions.put((Object)LOAD_OPTIONS, (Object)this.dataSourceSchemaSpecification);
        return loadOptions;
    }

    private static int calculateTablesLoaded(Module physicalModule) {
        int result = 0;
        for (DataSource ds : physicalModule.getDataSource()) {
            result += ds.getTable().size();
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.hashCodeSeed();
        result = 31 * result + (this.dataSourceSchemaId == null ? 0 : this.dataSourceSchemaId.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this.isEqual(obj) && obj instanceof ImportSchemaTask && ImportSchemaTask.equalsNulls(this.dataSourceSchemaId, ((ImportSchemaTask)obj).dataSourceSchemaId) && ImportSchemaTask.equalsNulls(this.username, ((ImportSchemaTask)obj).username);
    }

    @Override
    public void cancelRemoteTask() {
        if (this.requestEnv.getSmartsService() != null) {
            this.requestEnv.getSmartsService().cancelSmartsCollection(this.dataSourceSchemaId);
        }
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        if (this.baseModule != null) {
            this.requestEnv.getModuleStorageCM().delete(this.baseModule.getStoreId(), true, true);
        }
        this.history.processCancel(e);
        LoggerAdapter.error(ImportSchemaTask.class, "Importing schema was cancelled.");
    }

    public static JSONObject convertCleanLabelsToPrettifyLabels(JSONObject spec) {
        if (spec == null) {
            return spec;
        }
        Object cleanTableLabel = spec.get((Object)CLEAN_TABLE_LABELS);
        Object cleanColumnLabel = spec.get((Object)CLEAN_COLUMN_LABELS);
        if (cleanTableLabel == null && cleanColumnLabel == null) {
            return spec;
        }
        boolean bPretty = true;
        if (cleanTableLabel != null) {
            if (Boolean.FALSE.equals(cleanTableLabel)) {
                bPretty = false;
            }
            spec.remove((Object)CLEAN_TABLE_LABELS);
        }
        if (cleanColumnLabel != null) {
            if (Boolean.FALSE.equals(cleanColumnLabel)) {
                bPretty = false;
            }
            spec.remove((Object)CLEAN_COLUMN_LABELS);
        }
        if (!spec.containsKey((Object)PRETTIFY_LABELS)) {
            spec.put((Object)PRETTIFY_LABELS, (Object)bPretty);
        }
        return spec;
    }

    protected static void getLoadedAndSelected(int[] nLoadedSelected, ModulesData jsonData, Map<String, Object> feedBack, Module physicalModule, JSONObject dataSourceSchemaSpecification) {
        nLoadedSelected[0] = ImportSchemaTask.calculateTablesLoaded(physicalModule);
        if (dataSourceSchemaSpecification.get((Object)INCLUDED_TABLES) != null) {
            nLoadedSelected[1] = nLoadedSelected[0];
            Object numTables = null;
            numTables = feedBack != null ? feedBack.get("NumberOfTables") : jsonData.getAttribute("NumberOfTables");
            if (numTables instanceof Number) {
                nLoadedSelected[1] = ((Number)numTables).intValue();
            }
        } else {
            nLoadedSelected[1] = nLoadedSelected[0] + ((JSONArray)dataSourceSchemaSpecification.get((Object)EXCLUDED_TABLES)).size();
        }
    }
}

