/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.common.provider.metadata.IMetadataProvider;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.cm.Connection;
import com.ibm.bi.platform.moser.core.cm.DBDescriptor;
import com.ibm.bi.platform.moser.core.cm.UserProfile;
import com.ibm.bi.platform.moser.core.ma.DataSourceException;
import com.ibm.bi.platform.moser.core.ma.LogonFailureException;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.module.transformation.PhysicalToBaseModule;
import com.ibm.bi.platform.moser.core.module.transformation.PrimaryKeyToItemNormalization;
import com.ibm.bi.platform.moser.core.module.transformation.UnsupportedTypes;
import com.ibm.bi.platform.moser.core.module.util.BaseOverrides;
import com.ibm.bi.platform.moser.core.provider.MetadataProviderFactory;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.HistoryUpdater;
import com.ibm.bi.platform.moser.core.tasks.ImportSchemaTask;
import com.ibm.bi.platform.moser.core.tasks.ModuleRowCountTask;
import com.ibm.bi.platform.moser.core.tasks.MoserTaskManager;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.provider.jdbc.metadata.JDBCWKCMetadataProvider;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class ImportSchemaTaskLegacy
extends BaseMoserTask {
    private String taskName;
    private String dataSourceId;
    private String dataSourceName;
    private String dataSourceConnectionName = null;
    private String connectionSignonName = null;
    private String dataSourceSchemaId;
    private String dataSourceSchemaName;
    private String dataSourceSchemaInitStatus;
    private JSONObject dataSourceSchemaSpecification;
    private String baseModuleOldStoreId;
    private String catalog;
    private String schema;
    private String username;
    private HistoryUpdater history;
    private MoserConnectionSpec connectionSpec;
    public static final String TABLE_FILTERS = "tableFilters";
    public static final String CONDITION = "condition";
    public static final String VALUE = "value";
    public static final String STARTS_WITH = "startsWith";
    public static final String ENDS_WITH = "endsWith";
    public static final String CONTAINS = "contains";
    public static final String MATCHES = "matches";
    public static final String CLEAN_COLUMN_LABELS = "cleanColumnLabels";
    public static final String CLEAN_TABLE_LABELS = "cleanTableLabels";
    public static final String DATA_SAMPLING_SIZE = "dataSamplingSize";
    public static final String DATA_STATISTICS = "dataStatistics";
    public static final String EXCLUDED_TABLES = "excludedTables";
    public static final String IMPORT_PRIMARY_FOREIGN_KEYS = "importPrimaryForeignKeys";
    public static final String LOAD_OPTIONS = "loadOptions";
    public static final String VERSION = "version";
    private static final String SEV_ERROR = "ERROR";
    private static final String SEV_INFO = "INFO";
    private static final String SEV_WARNING = "WARNING";
    private static final String LOADED = "loaded";
    private BaseModuleContainer baseModule = null;

    @Deprecated
    public ImportSchemaTaskLegacy(RequestEnvironment requestEnv, String schemaStoreID, MoserConnectionSpec connectionSpec, MoserTaskManager tm) throws URISyntaxException {
        super(requestEnv);
        Object ven;
        this.status.setResourceID(schemaStoreID);
        this.status.setTaskType("ImportSchema");
        this.username = requestEnv.getUserId();
        this.connectionSpec = connectionSpec;
        int totalSteps = 7;
        this.baseURI = new URI(this.request.getContextPath() + this.request.getServletPath());
        RESTClientResponse resp = requestEnv.getModuleStorageCM().getResource(schemaStoreID, "defaultName", "ancestors", "status", "catalog", "schema", "specification");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORT_METADATA, (Locale)requestEnv.getProductLocale(), (String)schemaStoreID), 7));
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param0)MoserError.INTERNAL_ERROR, (Locale)requestEnv.getProductLocale()));
            return;
        }
        JSONObject schemaObj = (JSONObject)((JSONArray)resp.getJSONObjectResponse().get((Object)"data")).get(0);
        this.dataSourceSchemaId = schemaStoreID;
        this.dataSourceSchemaName = (String)schemaObj.get((Object)"defaultName");
        this.dataSourceSchemaInitStatus = (String)schemaObj.get((Object)"status");
        this.dataSourceSchemaSpecification = ImportSchemaTask.convertCleanLabelsToPrettifyLabels((JSONObject)schemaObj.get((Object)"specification"));
        this.catalog = (String)schemaObj.get((Object)"catalog");
        this.schema = (String)schemaObj.get((Object)"schema");
        JSONArray ancestors = (JSONArray)schemaObj.get((Object)"ancestors");
        JSONObject ancestor = (JSONObject)ancestors.get(ancestors.size() - 2);
        this.dataSourceId = (String)ancestor.get((Object)"id");
        this.dataSourceName = (String)ancestor.get((Object)"defaultName");
        if (this.dataSourceConnectionName == null) {
            ancestor = (JSONObject)ancestors.get(ancestors.size() - 1);
            this.dataSourceConnectionName = (String)ancestor.get((Object)"defaultName");
        }
        if (connectionSpec != null) {
            this.connectionSignonName = connectionSpec.getSignon();
        }
        if (this.dataSourceSchemaSpecification != null && (ven = this.dataSourceSchemaSpecification.get((Object)"vendor")) instanceof JSONObject) {
            this.connectionSpec.addVendor((JSONObject)ven);
        }
        this.taskName = ImportSchemaTaskLegacy.buildTaskName(this.dataSourceName, this.dataSourceConnectionName, this.dataSourceSchemaName);
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_IMPORT_METADATA, (Locale)requestEnv.getProductLocale(), (String)this.taskName), 7));
    }

    private void initHistoryUpdater() {
        this.history = new HistoryUpdater(this.getRuntimeEnv().getModuleStorageCM(), this.dataSourceSchemaId, this.dataSourceSchemaInitStatus, this.dataSourceSchemaSpecification, this.getRuntimeEnv().getProductLocale());
        this.history.init(this, this.taskName);
    }

    private static String buildTaskName(String dataSource, String dataSourceConnection, String dataSourceSchema) {
        StringBuilder composedName = new StringBuilder();
        composedName.append("dataSource=");
        composedName.append(dataSource);
        composedName.append(", dataSourceConnection=");
        composedName.append(dataSourceConnection);
        composedName.append(", dataSourceSchema=");
        composedName.append(dataSourceSchema);
        return composedName.toString();
    }

    @Override
    public void run() {
        if (SEV_ERROR.equals(this.status.getState())) {
            return;
        }
        this.initHistoryUpdater();
        if (SEV_ERROR.equals(this.status.getState())) {
            return;
        }
        Locale productLocale = this.requestEnv.getProductLocale();
        try {
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.status.setState("EXECUTING");
            LoggerAdapter.info(this, "[PERF]: Start - Connect to datasource");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_CONNECTING_DB, (Locale)productLocale, (String)this.taskName));
            Module overrides = this.requestEnv.getModuleObjectManager().getBaseModule(this.dataSourceSchemaId, UseSpecType.DATABASE);
            String baseModuleOldDefaultName = null;
            if (overrides != null) {
                JSONObject data = this.requestEnv.getModuleStorageCM().getBaseModule(this.dataSourceSchemaId, "id", "defaultName");
                this.baseModuleOldStoreId = (String)data.get((Object)"id");
                baseModuleOldDefaultName = (String)data.get((Object)"defaultName");
            }
            overrides = overrides != null ? BaseOverrides.extractSecurityFilters(overrides) : null;
            this.baseModule = this.requestEnv.getModuleObjectManager().createBaseModuleForDatabase(this.dataSourceId, this.dataSourceSchemaId);
            DBDescriptor dbDescriptor = new DBDescriptor(this.dataSourceName, this.dataSourceConnectionName, this.connectionSignonName, this.connectionSpec == null ? null : this.connectionSpec.getVendor(), this.requestEnv);
            DBDescriptor.STATUS bInit = dbDescriptor.init();
            if (bInit != DBDescriptor.STATUS.OK) {
                String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.CONNECTING_DB_ERROR, (Locale)productLocale, (String)this.taskName);
                this.history.processError(msg, SEV_ERROR, dbDescriptor.getStatusMessage(bInit, productLocale));
                this.removeFailedImport();
                LoggerAdapter.error(this, msg);
                this.status.setState(SEV_ERROR);
                this.status.setErrorMessage(msg);
                this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.CONNECTING_DB_ERROR, productLocale, this.taskName));
                return;
            }
            LoggerAdapter.info(this, "[PERF]: End - Connect to datasource");
            LoggerAdapter.info(this, "[PERF]: - Start Retrieve metadata from datasource");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_IMPORT_PHYSICAL_METADATA, (Locale)productLocale));
            Connection connection = dbDescriptor.getConnection();
            this.setImportProperties(dbDescriptor.getProviderProperties());
            HashMap<String, Object> feedBack = new HashMap<String, Object>();
            IMetadataProvider mdProvider = MetadataProviderFactory.create(this.dataSourceName, connection, dbDescriptor.getProviderProperties(), this.requestEnv);
            List<Module> modules = this.importMetadata(mdProvider, connection, dbDescriptor.getProviderProperties(), feedBack);
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            if (modules == null || modules.size() != 1) {
                String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.EMPTY_OR_INACCESSIBLE_SCHEMA, (Locale)productLocale, (String)this.dataSourceSchemaName);
                this.history.processError(msg, SEV_ERROR, msg);
                this.requestEnv.getModuleStorageCM().delete(this.baseModule.getStoreId(), true, true);
                LoggerAdapter.error(this, msg);
                this.status.setState(SEV_ERROR);
                this.status.setErrorMessage(msg);
                this.status.setResponse(MoserUtil.getResponse(Response.Status.FORBIDDEN, MoserError.EMPTY_OR_INACCESSIBLE_SCHEMA, productLocale, this.dataSourceSchemaName));
                return;
            }
            Module physicalModule = modules.get(0);
            physicalModule.setIdentifier("physicalmodule");
            String container = this.getRowContainer();
            physicalModule.setContainer(container);
            LoggerAdapter.info(this, "[PERF]: End - Retrieve metadata from datasource");
            LoggerAdapter.info(this, "[PERF]: Start - Base module creation");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_PHYSICAL_BUILD, (Locale)productLocale, (String)this.taskName));
            PhysicalToBaseModule physicalTransformation = new PhysicalToBaseModule();
            Module baseBusinessModule = physicalTransformation.apply(physicalModule);
            if (!physicalTransformation.getEmptyTables().isEmpty()) {
                String listTables = StringUtils.join(physicalTransformation.getEmptyTables(), (String)", ");
                String msg = MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_EMPTY_TABLES, (Locale)productLocale, (String)listTables);
                this.history.updateHistoryDetailMessage(msg, SEV_WARNING, msg, null);
            }
            PrimaryKeyToItemNormalization keyTranformation = new PrimaryKeyToItemNormalization(physicalModule);
            baseBusinessModule = keyTranformation.apply(baseBusinessModule);
            UnsupportedTypes unsupportedTypesTranformation = new UnsupportedTypes(physicalModule);
            baseBusinessModule = unsupportedTypesTranformation.apply(baseBusinessModule);
            baseBusinessModule.setContainer(container);
            String baseId = this.baseModule.getStoreId();
            String baseModuleHRef = ModuleObjectManager.getBaseModuleHRef(baseId);
            this.baseModule.setPhysicalModule(physicalModule);
            this.baseModule.setBaseModuleOverride(overrides);
            this.baseModule.setBaseBusinessModule(baseBusinessModule);
            this.baseModule.setEndTime(MoserUtil.getCurrentTimeGregorianUTC());
            this.baseModule.setStatus("succeeded");
            LoggerAdapter.info(this, "[PERF]: End - Base module creation");
            LoggerAdapter.info(this, "[PERF]: Start - Saving Base module definition.");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_SAVE_BASEMODULE, (Locale)productLocale, (String)this.taskName));
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.requestEnv.getModuleObjectManager().saveBaseModulesForDatabase(this.baseModule);
            MoserInfo resp = MoserInfoUtil.createMoserInfo(baseModuleHRef, this.baseModule.getStoreId(), null, this.dataSourceSchemaName, this.baseModule.getEndTime());
            LoggerAdapter.info(this, "[PERF]: End - Saving Base module definition.");
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryStatus(true);
            LoggerAdapter.info(this, "[PERF]: Start - Update history records");
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Metadata Import import is complete", LOADED, this.status);
            int[] nLoadedSelected = new int[]{0, 0};
            ImportSchemaTask.getLoadedAndSelected(nLoadedSelected, null, feedBack, physicalModule, this.dataSourceSchemaSpecification);
            int tablesLoaded = nLoadedSelected[0];
            int tablesSelected = nLoadedSelected[1];
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateHistoryDetailStatistics(tablesLoaded, tablesSelected);
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateResourceStatusInfo();
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.history.updateResourceStatus(LOADED);
            LoggerAdapter.info(this, "[PERF]: End - Update history records");
            boolean bOLAP = MetadataProviderFactory.isOLAPConnectionString(connection.getConnectionString());
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_SMARTS_ANALYSIS, (Locale)productLocale, (String)this.taskName));
            if (!bOLAP) {
                String connSpec;
                LoggerAdapter.info(this, "[PERF]: Start - Smarts analysis");
                SmartsServiceUtil.initSmartsSubtask(this.status, productLocale);
                String string = connSpec = this.connectionSpec == null ? null : this.connectionSpec.toString();
                if (overrides != null) {
                    BaseOverrides.mergeSecurityFilters(baseBusinessModule, overrides);
                }
                SmartsServiceUtil.createSmartsModule(this.dataSourceSchemaId, baseBusinessModule, UseSpecType.DATABASE, Optional.of(baseId), t -> {}, SmartsService.AnalysisMode.DEEP, this.requestEnv, this.getLoadOptions(), this.status, connSpec);
                this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Metadata analysis is complete", LOADED, this.status.clone());
                LoggerAdapter.info(this, "[PERF]: End - Smarts analysis");
            }
            BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
            this.collectStatistics(bOLAP);
            if (!this.status.isError()) {
                this.status.setResponse(resp);
                this.status.setTaskStep(null);
                this.status.setState("SUCCESS");
                this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Schema import is complete", LOADED, this.status);
                if (this.baseModuleOldStoreId != null) {
                    this.requestEnv.getModuleStorageCM().delete(this.baseModuleOldStoreId, true, true);
                }
                this.setBaseModuleDefaultName(baseModuleOldDefaultName);
            }
        }
        catch (MoserCancelException e) {
            this.handleCancel(e);
        }
        catch (DataSourceException e) {
            this.removeFailedImport();
            this.history.processError(e.getLocalizedMessage(), SEV_ERROR, e.getLocalizedMessage());
            LoggerAdapter.debug((Object)this, e.getLocalizedMessage(), (Throwable)((Object)e));
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(e.getLocalizedMessage());
            this.status.setResponse(e.getResponse(productLocale));
        }
        catch (MoserException e) {
            this.removeFailedImport();
            String msg = e.getLocalizedMessage(productLocale);
            this.history.processError(msg, SEV_ERROR, msg);
            LoggerAdapter.debug((Object)this, msg, e);
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(msg);
            this.status.setResponse(e.getResponse(productLocale));
        }
        catch (Throwable e) {
            this.removeFailedImport();
            String errMsg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.INTERNAL_BASEMODULE_ERROR, (Locale)productLocale, (String)this.taskName);
            String description = this.status.getTaskStep().getCurrentSubTask() != null ? this.status.getTaskStep().getCurrentSubTask().getCurrentStepDescription() : this.status.getTaskStep().getCurrentStepDescription();
            this.history.processError(errMsg + " " + description, SEV_ERROR, e.getLocalizedMessage());
            LoggerAdapter.errorExceptionStack(this, e);
            this.status.setState(SEV_ERROR);
            this.status.setErrorMessage(errMsg);
            this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.INTERNAL_BASEMODULE_ERROR, productLocale, this.taskName, e));
        }
    }

    private void setBaseModuleDefaultName(String oldDefaultName) {
        String dafaultName = oldDefaultName != null ? oldDefaultName : this.baseModule.getBaseBusinessModule().getLabel();
        JSONObject entry = new JSONObject();
        entry.put((Object)"defaultName", (Object)dafaultName);
        entry.put((Object)"type", (Object)"baseModule");
        RESTClientResponse resp = this.requestEnv.getContentService().put(ContentService.ContentResource.OBJECTS, this.baseModule.getStoreId(), null, entry);
        if (resp.getResponseCode() != Response.Status.NO_CONTENT.getStatusCode()) {
            LoggerAdapter.error(this, "Failed update base module name.");
        }
    }

    private void removeFailedImport() {
        if (this.baseModule != null) {
            this.requestEnv.getModuleStorageCM().delete(this.baseModule.getStoreId(), true, true);
        }
    }

    private void collectStatistics(boolean bOLAP) {
        this.status.getTaskStep().incrementStepNumber();
        this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_STATS_COLLECT, (Locale)this.requestEnv.getProductLocale(), (String)this.taskName));
        Long sampling = (Long)this.dataSourceSchemaSpecification.get((Object)DATA_SAMPLING_SIZE);
        boolean stats = "all".equals(this.dataSourceSchemaSpecification.get((Object)DATA_STATISTICS));
        if (!bOLAP && !Long.valueOf(-1L).equals(sampling) && stats) {
            LoggerAdapter.info(this, "[PERF]: Start - Module statistics");
            ModuleRowCountTask task = new ModuleRowCountTask(this.requestEnv, this.baseModule.getStoreId(), this.baseModule.getBaseBusinessModule(), this.connectionSpec, null);
            task.run();
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Module statistics is collected", LOADED, this.status);
            LoggerAdapter.info(this, "[PERF]: End - Module statistics");
        } else {
            this.history.updateHistoryDetailMessage("SUCCESS", SEV_INFO, "Module statistics is skipped", LOADED, this.status);
        }
        BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
    }

    private JSONObject getLoadOptions() {
        JSONObject loadOptions = new JSONObject();
        loadOptions.put((Object)LOAD_OPTIONS, (Object)this.dataSourceSchemaSpecification);
        return loadOptions;
    }

    private static int calculateTablesLoaded(Module physicalModule) {
        int result = 0;
        for (DataSource ds : physicalModule.getDataSource()) {
            result += ds.getTable().size();
        }
        return result;
    }

    private String getRowContainer() {
        String sep = ".";
        return this.dataSourceName + "." + this.dataSourceConnectionName + "." + this.catalog + "." + this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Module> importMetadata(IMetadataProvider mdProvider, Connection connection, ProviderProperties providerProperties, Map<String, Object> feedBack) throws Exception {
        LoggerAdapter.info(this, "[PERF]: JMD import started");
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            ArrayList<Module> modules = new ArrayList<Module>();
            Module module = mdProvider instanceof JDBCWKCMetadataProvider ? ((JDBCWKCMetadataProvider)mdProvider).getPhysicalModule(providerProperties.getDataSource(), providerProperties.getCatalog(), providerProperties.getSchema(), providerProperties.getTable(), MoserJDBCImporter.getInOrExcludedTablesFromProviderProperties(providerProperties), this.connectionSpec.getVendor(), connection, providerProperties, exceptions, feedBack) : mdProvider.getPhysicalModule(providerProperties, exceptions, feedBack);
            if (module != null) {
                modules.add(module);
            }
            if (!exceptions.isEmpty()) {
                if (DBDescriptor.isSignonError((Exception)exceptions.get(0))) {
                    if (!DBDescriptor.setPromptedSignon(new UserProfile(this.requestEnv), this.dataSourceName, this.dataSourceConnectionName, providerProperties.getProperties())) {
                        throw new LogonFailureException(this.dataSourceConnectionName, this.dataSourceName, 1);
                    }
                    exceptions.clear();
                    feedBack.clear();
                    List<Module> list = this.importMetadataWithPromptedSignon(providerProperties, mdProvider, exceptions, feedBack);
                    return list;
                }
                if (module == null) {
                    throw (Exception)exceptions.get(0);
                }
            }
            ArrayList<Module> arrayList = modules;
            return arrayList;
        }
        finally {
            LoggerAdapter.info(this, "[PERF]: JMD import done");
            for (Exception ex : exceptions) {
                LoggerAdapter.warn((Object)this, "Exception in JMD import metadata", ex);
                this.history.updateHistoryDetailMessage(ex.getLocalizedMessage(), SEV_WARNING, ex.getLocalizedMessage(), null);
            }
        }
    }

    private List<Module> importMetadataWithPromptedSignon(ProviderProperties properties, IMetadataProvider mdProvider, List<Exception> exceptions, Map<String, Object> feedBack) throws Exception {
        ArrayList<Module> modules = new ArrayList<Module>();
        Module module = mdProvider.getPhysicalModule(properties, exceptions, feedBack);
        if (module != null) {
            modules.add(module);
        }
        if (!exceptions.isEmpty()) {
            if (DBDescriptor.isSignonError(exceptions.get(0))) {
                throw new LogonFailureException(this.dataSourceConnectionName, this.dataSourceName, 1);
            }
            throw exceptions.get(0);
        }
        return modules;
    }

    private void setImportProperties(ProviderProperties props) {
        props.setCatalog(this.catalog);
        props.setSchema(this.schema);
        props.setDataSource(this.dataSourceName);
        Boolean importPrimaryForeignKeys = (Boolean)this.dataSourceSchemaSpecification.get((Object)IMPORT_PRIMARY_FOREIGN_KEYS);
        props.setImportPrimaryForeignKeys(importPrimaryForeignKeys.booleanValue());
        JSONArray tableFilters = (JSONArray)this.dataSourceSchemaSpecification.get((Object)TABLE_FILTERS);
        props.setTable(ImportSchemaTaskLegacy.buildTableFilter(tableFilters));
        MoserJDBCImporter.setInOrExcludedTablesProviderProperties(props, this.dataSourceSchemaSpecification);
    }

    public static String buildTableFilter(JSONArray tableFilters) {
        if (tableFilters == null) {
            return "\ufffds";
        }
        StringBuilder tableFilter = new StringBuilder();
        for (Object obj : tableFilters) {
            if (tableFilter.length() > 0) {
                tableFilter.append("\ufffdo");
            }
            JSONObject filter = (JSONObject)obj;
            String condition = (String)filter.get((Object)CONDITION);
            String value = (String)filter.get((Object)VALUE);
            if (STARTS_WITH.equals(condition)) {
                tableFilter.append(value);
                tableFilter.append("\ufffds");
                continue;
            }
            if (ENDS_WITH.equals(condition)) {
                tableFilter.append("\ufffds");
                tableFilter.append(value);
                continue;
            }
            if (MATCHES.equals(condition)) {
                tableFilter.append(value);
                continue;
            }
            if (!CONTAINS.equals(condition)) continue;
            tableFilter.append("\ufffds");
            tableFilter.append(value);
            tableFilter.append("\ufffds");
        }
        return tableFilter.length() > 0 ? tableFilter.toString() : "\ufffds";
    }

    public int hashCode() {
        int prime = 31;
        int result = this.hashCodeSeed();
        result = 31 * result + (this.dataSourceSchemaId == null ? 0 : this.dataSourceSchemaId.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this.isEqual(obj) && obj instanceof ImportSchemaTaskLegacy && ImportSchemaTaskLegacy.equalsNulls(this.dataSourceSchemaId, ((ImportSchemaTaskLegacy)obj).dataSourceSchemaId) && ImportSchemaTaskLegacy.equalsNulls(this.username, ((ImportSchemaTaskLegacy)obj).username);
    }

    @Override
    public void cancelRemoteTask() {
        if (this.requestEnv.getSmartsService() != null) {
            this.requestEnv.getSmartsService().cancelSmartsCollection(this.dataSourceSchemaId);
        }
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        this.removeFailedImport();
        this.history.processCancel(e);
        LoggerAdapter.error(ImportSchemaTaskLegacy.class, "Importing schema was cancelled.");
    }
}

