/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.ModuleNotFoundException;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.RequestCacheManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;

public class ModuleRowCountTask
extends BaseMoserTask {
    public static final String ROWS = "rows";
    public static final String ERRORS = "errors";
    private static final String DATA_STR = "data";
    private static final String NAME = "name";
    private String moduleId;
    RequestEnvironment reqEnv;
    private QueryTask[] tasks;
    private List<String> tableFilter;
    private List<QuerySubject> tables;
    private JSONArray data = new JSONArray();
    private CountDownLatch timer;
    private MoserConnectionSpec connSpec = null;
    private Module module;

    public ModuleRowCountTask(RequestEnvironment reqEnv, String moduleId, Module module, MoserConnectionSpec connectionSpec, List<String> tbl) {
        super(reqEnv);
        this.moduleId = moduleId;
        this.module = module;
        this.reqEnv = reqEnv;
        this.connSpec = connectionSpec;
        this.tableFilter = tbl;
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param1)MoserMessageKeys.MSR_STS_FETCHING_MODULE_STATS, (Locale)this.requestEnv.getProductLocale(), (String)moduleId), 1));
    }

    @Override
    public void run() {
        Locale productLocale = this.requestEnv.getProductLocale();
        try {
            LoggerAdapter.debug(this, "Start to collect row count.");
            if ("ERROR".equals(this.status.getState())) {
                return;
            }
            this.status.setState("EXECUTING");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_SENT_MODULE_STATS, (Locale)productLocale));
            IModuleObjectManager mm = this.reqEnv.getModuleObjectManager();
            if (this.module == null) {
                this.module = mm.getBusinessModule(this.moduleId, null);
                if (null == this.module) {
                    this.module = mm.getBaseModule(this.moduleId, null);
                }
            }
            if (null == this.module) {
                throw new ModuleNotFoundException(MoserError.MSR_MODULE_NOT_FOUND, this.moduleId);
            }
            this.runQueries();
            if (this.status.isCancelled()) {
                this.status.setCompletionTimestamp(RequestCacheManager.registerResponseTimestamp(this.moduleId));
                this.status.setTaskStep(null);
                return;
            }
            if (ModuleUtil.isBaseModule(this.module)) {
                this.updateModule();
                mm.updateBaseModule(this.moduleId, this.module);
            }
            this.status.setState("SUCCESS");
            this.status.setCompletionTimestamp(RequestCacheManager.registerResponseTimestamp(this.moduleId));
            this.status.setTaskStep(null);
            this.status.setResponse(MoserUtil.getResponse(Response.Status.OK, (Object)this.createResponse()));
            LoggerAdapter.debug(this, "Finished to count rows.");
        }
        catch (MoserCancelException ce) {
            this.handleCancel(ce);
            LoggerAdapter.debug(this, "Handle cancel request.");
        }
        catch (Throwable e) {
            LoggerAdapter.errorExceptionStack(this, e);
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.MODULE_STATS_ERROR, (Locale)productLocale, (String)this.moduleId);
            this.status.setState("ERROR");
            this.status.setErrorMessage(locmsg);
            this.status.setResponse(MoserUtil.getResponse(Response.Status.BAD_REQUEST, MoserError.MODULE_STATS_ERROR, productLocale, this.moduleId, e));
            this.status.setTaskStep(null);
        }
    }

    private JSONObject createResponse() {
        this.reportUnprocessedTables();
        JSONObject ret = new JSONObject();
        ret.put((Object)DATA_STR, (Object)this.data);
        return ret;
    }

    private void runQueries() {
        if (this.module == null || this.module.basicGetQuerySubject() == null || this.module.basicGetQuerySubject().isEmpty()) {
            return;
        }
        this.selectQuerySubjects();
        if (!this.initializeThreads()) {
            return;
        }
        int maxTime = MoserConfig.getMaxTimeStatistics();
        try {
            if (maxTime == 0) {
                this.timer.await();
            } else if (!this.timer.await(maxTime, TimeUnit.SECONDS)) {
                LoggerAdapter.debug(this, "Time out for row count is reached in " + maxTime + " sec.");
                this.stopQueries();
            }
        }
        catch (InterruptedException e) {
            LoggerAdapter.debug((Object)this, "Row counting is interrupted.", e);
            this.stopQueries();
        }
    }

    private void selectQuerySubjects() {
        this.tables = new ArrayList<QuerySubject>(this.module.getQuerySubject());
        if (this.tableFilter != null && !this.tableFilter.isEmpty()) {
            HashSet<String> missingQS = new HashSet<String>(this.tableFilter);
            int i = this.tables.size();
            while (--i >= 0) {
                String id = this.tables.get(i).getIdentifier();
                if (missingQS.remove(id)) continue;
                this.tables.remove(i);
            }
            if (!missingQS.isEmpty()) {
                Locale productLocale = this.requestEnv.getProductLocale();
                for (String id : missingQS) {
                    String locmsg = MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_MODULE_STATS_ERROR_MISSING_TABLE, (Locale)productLocale, (String)id);
                    this.addResultError(id, locmsg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeThreads() {
        int nThreads = Math.max(1, MoserConfig.getDegreeOfParallelism());
        nThreads = Math.min(nThreads, this.tables.size());
        ModuleRowCountTask moduleRowCountTask = this;
        synchronized (moduleRowCountTask) {
            if (this.status.isCancelled()) {
                return false;
            }
            this.timer = new CountDownLatch(nThreads);
            this.tasks = new QueryTask[nThreads];
            for (int i = 0; i < nThreads; ++i) {
                this.tasks[i] = new QueryTask(this.requestEnv, i);
                new Thread(this.tasks[i]).start();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopQueries() {
        ModuleRowCountTask moduleRowCountTask = this;
        synchronized (moduleRowCountTask) {
            if (this.tasks == null) {
                return;
            }
            LoggerAdapter.debug(this, "Stop queries for task: " + this.getTaskID());
            for (QueryTask current : this.tasks) {
                current.cancelRemoteTask();
            }
            try {
                this.timer.await();
            }
            catch (InterruptedException e) {
                LoggerAdapter.debug((Object)this, "Not all threads are completed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResult(String table, JSONObject result) {
        JSONArray jSONArray = this.data;
        synchronized (jSONArray) {
            if (!this.status.isCancelled()) {
                JSONObject json = new JSONObject();
                json.put((Object)NAME, (Object)table);
                Object rows = result.get((Object)ROWS);
                try {
                    json.put((Object)ROWS, null == rows ? null : Long.valueOf(rows.toString()));
                }
                catch (NumberFormatException e) {
                    json.put((Object)ERRORS, rows);
                }
                this.data.add((Object)json);
                LoggerAdapter.debug(this, "End row count for table: " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultError(String table, String msg) {
        JSONArray jSONArray = this.data;
        synchronized (jSONArray) {
            JSONObject json = new JSONObject();
            json.put((Object)NAME, (Object)table);
            json.put((Object)ERRORS, (Object)msg);
            this.data.add((Object)json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuerySubject getNextTask() {
        List<QuerySubject> list = this.tables;
        synchronized (list) {
            if (!this.tables.isEmpty()) {
                return this.tables.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModule() {
        JSONArray jSONArray = this.data;
        synchronized (jSONArray) {
            if (this.module == null || this.module.basicGetQuerySubject() == null || this.module.basicGetQuerySubject().isEmpty()) {
                return;
            }
            for (Object current : this.data) {
                JSONObject json = (JSONObject)current;
                if (json.get((Object)ROWS) == null) continue;
                String qsName = (String)json.get((Object)NAME);
                Optional<QuerySubject> qs = this.module.basicGetQuerySubject().stream().filter(x -> x.getIdentifier().equals(qsName)).findFirst();
                if (!qs.isPresent()) continue;
                qs.get().setRowCount((Long)json.get((Object)ROWS));
            }
        }
    }

    private void reportUnprocessedTables() {
        this.tables.forEach(v -> this.addResultError(v.getIdentifier(), "Not processed"));
    }

    @Override
    public void cancelRemoteTask() {
        this.status.setState("CANCELLED");
        this.stopQueries();
        LoggerAdapter.debug(this, "Cancel main task.");
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
    }

    public class QueryTask
    extends BaseMoserTask {
        private static final String MOSER_FUNCTION_TYPE = "moserFunctionType";
        private static final String CMD_GETSTATISTICS = "getTableStatistics";
        private static final String PAR_MODULE = "module";
        public static final String PAR_IDENTIFIER = "identifier";
        private String table;

        public QueryTask(RequestEnvironment reqEnv, int index) {
            super(reqEnv);
            this.setTaskID(ModuleRowCountTask.this.moduleId + "_" + index);
            this.status.setState("PENDING");
        }

        @Override
        public void cancelRemoteTask() {
            if (!this.status.isCancelled()) {
                this.requestEnv.getMoserCommandService().cancelMoserCommand(this.getTaskID());
                this.status.setState("CANCELLED");
                if (this.table != null) {
                    ModuleRowCountTask.this.addResultError(this.table, "Canceled");
                    LoggerAdapter.debug(this, String.format("Task '%s' is cancelled for table: %s", this.getTaskID(), this.table));
                } else {
                    LoggerAdapter.debug(this, String.format("Task '%s' is canceled.", this.getTaskID()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.status.setState("EXECUTING");
                while (!this.status.isCancelled()) {
                    QuerySubject qs = ModuleRowCountTask.this.getNextTask();
                    if (qs == null) {
                        this.status.setState("SUCCESS");
                        LoggerAdapter.debug(this, String.format("Task '%s' is completed.", this.getTaskID()));
                        break;
                    }
                    this.table = qs.getIdentifier();
                    LoggerAdapter.debug(this, "Start row count for table: " + this.table);
                    try {
                        JSONObject functionSpec = this.buildFunctionSpecification();
                        RESTClientResponse resp = this.requestEnv.getMoserCommandService().doMoserCommand(functionSpec);
                        ModuleRowCountTask.this.addResult(this.table, resp.getJSONObjectResponse());
                    }
                    catch (Exception e) {
                        ModuleRowCountTask.this.addResultError(this.table, e.getLocalizedMessage());
                        LoggerAdapter.debug((Object)this, String.format("Failed row count for table '%s': %s", this.table, e.getLocalizedMessage()), e);
                    }
                }
            }
            finally {
                ModuleRowCountTask.this.timer.countDown();
            }
        }

        private JSONObject buildFunctionSpecification() {
            JSONObject functionSpec = new JSONObject();
            functionSpec.put((Object)MOSER_FUNCTION_TYPE, (Object)CMD_GETSTATISTICS);
            functionSpec.put((Object)PAR_MODULE, (Object)ModuleRowCountTask.this.moduleId);
            functionSpec.put((Object)PAR_IDENTIFIER, (Object)this.table);
            if (ModuleRowCountTask.this.connSpec != null) {
                functionSpec.putAll((Map)ModuleRowCountTask.this.connSpec.toJSON());
            }
            return functionSpec;
        }

        public boolean equals(Object obj) {
            boolean equal = obj != null && obj instanceof QueryTask && super.equals(obj);
            return equal && this.getTaskID().equals(((QueryTask)obj).getTaskID());
        }

        public int hashCode() {
            int prime = 31;
            return 31 * super.hashCode() + this.getTaskID().hashCode();
        }

        @Override
        public void cancelHandler(MoserCancelException e) {
        }
    }
}

