/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.generic.SQLProjectionOverflowException;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class MoserCommandTask
extends BaseMoserTask {
    public static final String DO_MOSERCOMMAND = "do mosercommand";
    public static final String MOSER_FUNCTION_TYPE = "moserFunctionType";
    public static final String DESC_SQL = "describeDataSourceQuery";
    public static final String EXPAND_MACRO = "expandMacros";
    public static final String MODULE = "module";
    public static final String JOIN_GRAPH = "joingraph";
    protected JSONObject functionSpec;

    public MoserCommandTask(RequestEnvironment requestEnv, JSONObject funcSpec) {
        super(requestEnv);
        this.functionSpec = funcSpec;
    }

    @Override
    public void cancelRemoteTask() {
    }

    @Override
    public void run() {
        try {
            String funcType = (String)this.functionSpec.get((Object)MOSER_FUNCTION_TYPE);
            if (DESC_SQL.equals(funcType)) {
                this.runDescribeDataSourceQuery(this.functionSpec);
            } else if (EXPAND_MACRO.equals(funcType) || JOIN_GRAPH.equals(funcType)) {
                this.runMoserCommandOneStep(this.functionSpec);
            } else {
                this.status.setState("ERROR");
                this.status.setResponse(this.functionSpec);
            }
        }
        catch (MoserCancelException ce) {
            this.handleCancel(ce);
        }
        catch (Throwable e) {
            LoggerAdapter.errorExceptionStack(this, e);
            String errMsg = MoserMessages.getMessage((IMessageKey.Param0)MoserError.INTERNAL_ERROR, (Locale)this.requestEnv.getProductLocale());
            TaskStatus newStatus = new TaskStatus("ERROR");
            newStatus.setErrorMessage(errMsg);
            newStatus.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.INTERNAL_ERROR, this.requestEnv.getProductLocale(), e));
            this.setStatus(newStatus);
            this.cancelRemoteTask();
        }
    }

    protected void runDescribeDataSourceQuery(JSONObject jFuncSpec) {
        int nSteps = 2;
        String taskDesc = MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_DESCRIBE_SQL, (Locale)this.requestEnv.getProductLocale());
        this.status.setTaskStep(new TaskStep(taskDesc, nSteps));
        BaseMoserTask.throwIfCancelled(this.status, DO_MOSERCOMMAND);
        this.status.setState("EXECUTING");
        this.status.getTaskStep().incrementStepNumber();
        this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_DESCRIBE_SQL_QUERYSERVICE, (Locale)this.requestEnv.getProductLocale()));
        RESTClientResponse resp = this.requestEnv.getMoserCommandService().doMoserCommand(this.functionSpec);
        JSONObject jResp = resp.getJSONObjectResponse();
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            this.status.setState("ERROR");
            this.status.setResponse(resp.toResponse());
            this.status.setTaskStep(null);
            return;
        }
        if (nSteps == 1) {
            this.status.setResponse(jResp);
            this.status.setTaskStep(null);
            this.status.setState("SUCCESS");
            return;
        }
        BaseMoserTask.throwIfCancelled(this.status, DO_MOSERCOMMAND);
        this.status.getTaskStep().incrementStepNumber();
        this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_DESCRIBE_SQL_SMARTS, (Locale)this.requestEnv.getProductLocale()));
        ObjectFactory factory = new ObjectFactory();
        QuerySubject qs = QuerySubject.fromJSON((JSONObject)jResp, (ObjectFactory)factory);
        if (qs.getItem().size() > MoserConfig.getTypeInSQLMaxNumberOfColumns()) {
            throw new SQLProjectionOverflowException(qs.getItem().size(), MoserConfig.getTypeInSQLMaxNumberOfColumns());
        }
        String moduleId = (String)jFuncSpec.get((Object)MODULE);
        Module module = this.requestEnv.getModuleObjectManager().getBusinessModule(moduleId, UseSpecType.MODULE);
        MoserCommandTask.clearList(module.basicGetCalculation());
        MoserCommandTask.clearList(module.basicGetDataSource());
        MoserCommandTask.clearList(module.basicGetDrillGroup());
        MoserCommandTask.clearList(module.basicGetFilter());
        MoserCommandTask.clearList(module.basicGetMetadataTreeView());
        MoserCommandTask.clearList(module.basicGetNamedSet());
        MoserCommandTask.clearList(module.basicGetParameterMap());
        MoserCommandTask.clearList(module.basicGetQuerySubject());
        MoserCommandTask.clearList(module.basicGetRelationship());
        MoserCommandTask.clearList(module.basicGetTextResource());
        MoserCommandTask.clearList(module.basicGetUse());
        module.addQuerySubject(qs);
        BaseMoserTask.throwIfCancelled(this.status, DO_MOSERCOMMAND);
        if (!SmartsServiceUtil.smartsDecorateDataModule(module, this.requestEnv.getSmartsService(), this.status, null)) {
            return;
        }
        JSONObject decoratedQS = ((QuerySubject)module.basicGetQuerySubject().get(0)).toJSON();
        this.status.setResponse(decoratedQS);
        this.status.setTaskStep(null);
        this.status.setState("SUCCESS");
    }

    private static void clearList(List<?> l) {
        if (l != null) {
            l.clear();
        }
    }

    protected void runMoserCommandOneStep(JSONObject jFuncSpec) {
        String taskDesc = MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_MOSER_COMMAND, (Locale)this.requestEnv.getProductLocale());
        this.status.setTaskStep(new TaskStep(taskDesc, 1));
        BaseMoserTask.throwIfCancelled(this.status, DO_MOSERCOMMAND);
        this.status.setState("EXECUTING");
        this.status.getTaskStep().incrementStepNumber();
        this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_MOSER_COMMAND_QUERYSERVICE, (Locale)this.requestEnv.getProductLocale()));
        RESTClientResponse resp = this.requestEnv.getMoserCommandService().doMoserCommand(this.functionSpec);
        JSONObject jResp = resp.getJSONObjectResponse();
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            this.status.setState("ERROR");
            this.status.setResponse(resp.toResponse());
            this.status.setTaskStep(null);
            return;
        }
        this.status.setResponse(jResp);
        this.status.setTaskStep(null);
        this.status.setState("SUCCESS");
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        LoggerAdapter.error((Object)this, "do moser command was cancelled", e);
    }
}

