/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.tasks.IMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class MoserTaskManager {
    private static volatile MoserTaskManager instance = null;
    ExecutorService workerThreads = null;
    long deleteTaskSleepInterval = 10L;
    long maxDeleteTaskWait = 10000L;
    long updateInterval = 5000L;
    private Map<String, MoserTaskEntry> tasksMap = new ConcurrentHashMap<String, MoserTaskEntry>();
    private long maxTimeToKeepInTaskRepositoryAfterDone = 60000L;
    private AtomicLong nextTaskID = new AtomicLong();

    private MoserTaskManager(ExecutorService execSvc) {
        this.workerThreads = execSvc;
        this.startTaskTrackerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoserTaskManager getInstance(ExecutorService execSvc) {
        if (instance != null) return instance;
        Class<MoserTaskManager> clazz = MoserTaskManager.class;
        synchronized (MoserTaskManager.class) {
            if (instance != null) return instance;
            instance = new MoserTaskManager(execSvc);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<MoserTaskManager> clazz = MoserTaskManager.class;
        synchronized (MoserTaskManager.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void startTaskTrackerThread() {
        this.workerThreads.submit(new TaskCleanerAndUpdaterThread());
    }

    private String getExistingTaskID(IMoserTask task) {
        for (Map.Entry<String, MoserTaskEntry> entry : this.tasksMap.entrySet()) {
            MoserTaskEntry iTask = entry.getValue();
            if (iTask.isDone() || !task.equals(iTask.task)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String submitTask(IMoserTask task) {
        return this.submitTask(null, task);
    }

    public String submitTask(IModuleObjectManager mm, IMoserTask task) {
        String running = this.getExistingTaskID(task);
        if (running != null) {
            return running;
        }
        String taskID = this.getNextTaskID();
        task.setTaskID(taskID);
        task.getStatus().setTaskID(taskID);
        Future<IMoserTask> submittedTask = this.workerThreads.submit(task);
        if (submittedTask == null) {
            throw new MoserException(MoserError.MSR_TASK_CREATE_ERROR);
        }
        MoserTaskEntry moserTask = new MoserTaskEntry(taskID, task, submittedTask, mm);
        this.tasksMap.put(taskID, moserTask);
        return taskID;
    }

    private String getNextTaskID() {
        return "task" + this.nextTaskID.incrementAndGet() + System.currentTimeMillis();
    }

    public TaskStatus getTaskStatus(IModuleObjectManager mm, String taskID, String resourceID) {
        MoserTaskEntry moserTask = null;
        if (taskID != null) {
            moserTask = this.tasksMap.get(taskID);
        }
        if (moserTask == null) {
            List<TaskStatus> tasks = this.getTasksForResource(mm, resourceID);
            if (tasks == null || tasks.isEmpty()) {
                return MoserTaskManager.taskNotAvailable();
            }
            return tasks.get(0).clone();
        }
        IMoserTask task = moserTask.getTask();
        if (task != null) {
            if (moserTask.getFuture().isDone()) {
                this.removeTask(taskID);
            }
            return task.getStatus().clone();
        }
        return MoserTaskManager.taskNotAvailable();
    }

    private void removeTask(String taskID) {
        MoserTaskManager.toConsole("removing task from task repository: " + taskID);
        this.tasksMap.remove(taskID);
    }

    public static TaskStatus taskNotAvailable() {
        return new TaskStatus("NOT_AVAILABLE");
    }

    public boolean deleteTask(String taskID) {
        MoserTaskManager.toConsole("deleting task: " + taskID);
        MoserTaskEntry moserTask = this.tasksMap.get(taskID);
        boolean isCancelled = true;
        if (moserTask != null) {
            MoserTaskManager.toConsole("Found task to delete: " + taskID);
            isCancelled = moserTask.cancel();
            if (isCancelled) {
                if (!moserTask.isDone()) {
                    moserTask.getTask().awaitCancellation();
                }
                this.removeTask(taskID);
            }
        }
        return isCancelled;
    }

    public List<TaskStatus> getTasks() {
        return this.getTasks(null, null, null);
    }

    public List<TaskStatus> getTasks(IModuleObjectManager mm, String resourceID, String taskType) {
        List<TaskStatus> tasks = this.getLocalTasks();
        if (tasks != null && (resourceID != null || taskType != null)) {
            ArrayList<TaskStatus> filteredTasks = new ArrayList<TaskStatus>();
            for (TaskStatus task : tasks) {
                if (resourceID != null && !resourceID.equals(task.getResourceID()) || taskType != null && !taskType.equals(task.getTaskType())) continue;
                filteredTasks.add(task);
            }
            tasks = filteredTasks;
        }
        if ((tasks == null || tasks.isEmpty()) && resourceID != null && mm != null) {
            tasks = this.getTasksForResource(mm, resourceID);
        }
        this.removeFinishedTasks(tasks);
        return tasks;
    }

    private List<TaskStatus> getLocalTasks() {
        ArrayList<MoserTaskEntry> taskEntries = new ArrayList<MoserTaskEntry>();
        ArrayList<TaskStatus> tasks = new ArrayList<TaskStatus>();
        taskEntries.addAll(this.tasksMap.values());
        for (MoserTaskEntry tEntry : taskEntries) {
            if (tEntry.getTask() == null || tEntry.getTask().getStatus() == null) continue;
            tasks.add(tEntry.getTask().getStatus().clone());
        }
        return tasks;
    }

    private void removeFinishedTasks(List<TaskStatus> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        for (TaskStatus task : tasks) {
            if (task.isRunning() || task.getTaskID() == null || task.getTaskID().isEmpty()) continue;
            this.removeTask(task.getTaskID());
        }
    }

    private List<TaskStatus> getTasksForResource(IModuleObjectManager mm, String resourceID) {
        TaskStatus status;
        JSONObject jStatus;
        ArrayList<TaskStatus> tasks = new ArrayList<TaskStatus>();
        if (mm == null) {
            return tasks;
        }
        JSONObject statusInfo = mm.getResourceStatusInfo(resourceID);
        if (statusInfo != null && (jStatus = (JSONObject)statusInfo.get((Object)"taskStatus")) != null && this.isStillRunning(status = (TaskStatus)new JSONCodec().decode(TaskStatus.class, jStatus.toString()))) {
            tasks.add(status);
        }
        return tasks;
    }

    private boolean isStillRunning(TaskStatus status) {
        if (status == null) {
            return false;
        }
        if (!status.isRunning()) {
            return false;
        }
        long lastUpdateInCM = status.getCMUpdateTime();
        if (lastUpdateInCM == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUpdateInCM <= this.maxTimeToKeepInTaskRepositoryAfterDone) {
            return true;
        }
        LoggerAdapter.warn(this, "The following task is no longer running: \n" + status.toString());
        return false;
    }

    public void setSleepInterval(long interval) {
        this.updateInterval = interval;
    }

    public static void toConsole(String string) {
    }

    public void setThreadCleanerParms(long theWakeupInterval, long theTotalTimeInTaskManInterval) {
        this.updateInterval = theWakeupInterval;
        this.maxTimeToKeepInTaskRepositoryAfterDone = theTotalTimeInTaskManInterval;
    }

    private class MoserTaskEntry {
        public long timeCheckedDone = 0L;
        Future<IMoserTask> future;
        IMoserTask task;
        String taskID;
        private IModuleObjectManager mm;
        private boolean lastCMUpdateStatus;

        public MoserTaskEntry(String taskID, IMoserTask task, Future<IMoserTask> future, IModuleObjectManager mm) {
            this.taskID = taskID;
            this.task = task;
            this.future = future;
            this.mm = mm;
            this.lastCMUpdateStatus = true;
        }

        public boolean isDone() {
            Future<IMoserTask> f = this.getFuture();
            return f == null || f.isCancelled() || f.isDone();
        }

        public String getTaskID() {
            return this.taskID;
        }

        public Future<IMoserTask> getFuture() {
            return this.future;
        }

        public IMoserTask getTask() {
            return this.task;
        }

        public boolean cancel() {
            MoserTaskManager.toConsole("Adding to cancelled tasks: " + this.taskID);
            if (this.getTask().cancel()) {
                MoserTaskManager.this.removeTask(this.taskID);
                this.updateStatusInCM();
                return true;
            }
            return false;
        }

        public void updateStatusInCM() {
            if (this.mm == null) {
                return;
            }
            TaskStatus status = this.getTask().getStatus().clone();
            if (status == null || status.isNotCancellable()) {
                return;
            }
            if (!this.lastCMUpdateStatus) {
                return;
            }
            if (status.getResourceID() != null) {
                this.lastCMUpdateStatus = this.mm.updateResourceHistory(null, status.getResourceID(), null, null, null, status);
            }
        }
    }

    private class TaskCleanerAndUpdaterThread
    implements Runnable {
        private TaskCleanerAndUpdaterThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(MoserTaskManager.this.updateInterval);
                        ArrayList tasks = new ArrayList();
                        tasks.addAll(MoserTaskManager.this.tasksMap.values());
                        Iterator iterator = tasks.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            MoserTaskEntry task = (MoserTaskEntry)iterator.next();
                            if (this.removeIfFinished(task)) continue;
                            task.updateStatusInCM();
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    LoggerAdapter.debug((Object)this, "Task cleaner thread got interrupt", e);
                    continue;
                }
                break;
            }
        }

        private boolean removeIfFinished(MoserTaskEntry task) {
            if (task.isDone()) {
                if (task.timeCheckedDone == 0L) {
                    task.timeCheckedDone = System.currentTimeMillis();
                } else {
                    long currTime = System.currentTimeMillis();
                    if (currTime - task.timeCheckedDone >= MoserTaskManager.this.maxTimeToKeepInTaskRepositoryAfterDone) {
                        MoserTaskManager.this.removeTask(task.getTaskID());
                    }
                }
                return true;
            }
            return false;
        }
    }
}

