/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.ParquetUpgradeMultiTask;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.SmartsModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class ParquetSmartsUpgradeTask
extends ParquetUpgradeMultiTask {
    public ParquetSmartsUpgradeTask(RequestEnvironment requestEnv, String searchPath, String sourceType) {
        super(requestEnv, null, sourceType, sourceType, Boolean.TRUE);
    }

    @Override
    protected Object upgrade(ModuleStorageCM moduleStorageCM, List<JSONObject> sourceList) throws IOException {
        ArrayList<JSONObject> retList = new ArrayList<JSONObject>();
        if (sourceList == null) {
            return retList;
        }
        for (JSONObject parquetInfo : sourceList) {
            JSONObject smartInfo;
            if (!this.isSmarstUpgradeNeeded(parquetInfo) || (smartInfo = this.createSmartModel(parquetInfo)) == null) continue;
            this.status.getTaskStep().setCurrentStepDescription(smartInfo.serialize());
            retList.add(smartInfo);
        }
        return retList;
    }

    private boolean isSmarstUpgradeNeeded(JSONObject parquetInfo) {
        try {
            String assetId = (String)parquetInfo.get((Object)"AssetId");
            SmartsService smartService = SmartsService.from(this.requestEnv.getRESTClientConfig());
            BaseMoserTask.throwIfCancelled(this.status, "collect smarts");
            this.status.getTaskStep().setCurrentStepDescription("Geeting the smart module:" + assetId);
            RESTClientResponse response = smartService.getSmartsModule(assetId);
            if (response.getResponseCode() != Response.Status.OK.getStatusCode()) {
                return true;
            }
            byte[] smartsModuleBytes = response.getRawResponse();
            if (smartsModuleBytes.length == 0) {
                LoggerAdapter.error(this, "Missing smarts module: " + assetId);
                return true;
            }
            this.status.getTaskStep().setCurrentStepDescription("Decoding the smart module:" + assetId);
            SmartsModule sm = SmartsService.decodeSmartsModule(smartsModuleBytes);
            BaseMoserTask.throwIfCancelled(this.status, "collect smarts");
            if (sm != null) {
                AnalysisModeType analysisMode = sm.getAnalysisMode();
                return analysisMode == null || !analysisMode.equals((Object)AnalysisModeType.DEEP);
            }
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Upgred create smart moudule: ", e);
        }
        return true;
    }
}

