/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.ParquetUpgradeTaskBase;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.ParquetUtils;
import com.ibm.bi.soap.services.CamException;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ParquetUpgradeMultiTask
extends ParquetUpgradeTaskBase {
    protected final String searchPath;
    protected final String sourceType;
    protected final Boolean smartsUpgrade;

    public ParquetUpgradeMultiTask(RequestEnvironment requestEnv, String searchPath, String version, String sourceType, Boolean smartsUpgrade) {
        super(requestEnv, version);
        this.searchPath = searchPath;
        this.sourceType = sourceType;
        this.smartsUpgrade = smartsUpgrade;
        Locale productLocale = requestEnv.getProductLocale();
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_PARQUET_UPGRADE, (Locale)productLocale), 1));
    }

    @Override
    protected Object upgrade() {
        try {
            ModuleStorageCM moduleStorageCM = this.requestEnv.getModuleStorageCM();
            return this.upgrade(moduleStorageCM, this.getListOfFilesToUpgrade(moduleStorageCM));
        }
        catch (Exception e) {
            this.status.setState("ERROR");
            LoggerAdapter.errorExceptionStack(this, e);
            return new Object();
        }
    }

    protected Object upgrade(ModuleStorageCM moduleStorageCM, List<JSONObject> sourceList) throws IOException {
        ArrayList<JSONObject> retList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> smartList = new ArrayList<JSONObject>();
        if (sourceList == null) {
            return retList;
        }
        for (JSONObject current : sourceList) {
            JSONObject parquetInfo = ParquetUtils.getParquetInfo(current);
            if (!ParquetUtils.getPermission(parquetInfo)) {
                retList.add(parquetInfo);
                continue;
            }
            if (!ParquetUtils.isUpgradable(this.version, parquetInfo)) continue;
            parquetInfo = this.upgrade(moduleStorageCM, parquetInfo);
            retList.add(parquetInfo);
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(parquetInfo.serialize());
            LoggerAdapter.info(this, parquetInfo.toString());
            smartList.add(current);
        }
        if (this.smartsUpgrade != null && this.smartsUpgrade.booleanValue()) {
            for (JSONObject parquetInfo : smartList) {
                JSONObject smartInfo = this.createSmartModel(parquetInfo);
                if (smartInfo == null) continue;
                this.status.getTaskStep().incrementStepNumber();
                this.status.getTaskStep().setCurrentStepDescription(smartInfo.serialize());
                retList.add(smartInfo);
            }
        }
        return retList;
    }

    protected List<JSONObject> getListOfFilesToUpgrade(ModuleStorageCM moduleStorageCM) throws CamException {
        return ParquetUtils.getListOfFilesToUpgrade(moduleStorageCM, this.searchPath, this.sourceType);
    }
}

