/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.ParquetUpgradeTaskBase;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.ParquetUtils;
import com.ibm.json.java.JSONObject;

public class ParquetUpgradeTask
extends ParquetUpgradeTaskBase {
    protected String storeId = null;

    public ParquetUpgradeTask(RequestEnvironment requestEnv, String storeId, String version) {
        super(requestEnv, version);
        this.storeId = storeId;
    }

    @Override
    protected Object upgrade() {
        ModuleStorageCM moduleStorageCM = this.requestEnv.getModuleStorageCM();
        try {
            if (MoserUtil.isStoreId(this.storeId)) {
                JSONObject parquetInfo = ParquetUtils.getParquetInfo(moduleStorageCM, this.storeId);
                if (!ParquetUtils.getPermission(parquetInfo)) {
                    this.status.setState("ERROR");
                    return parquetInfo;
                }
                if (ParquetUtils.isUpgradable(this.version, parquetInfo)) {
                    parquetInfo = this.upgrade(moduleStorageCM, parquetInfo);
                    this.status.getTaskStep().incrementStepNumber();
                    this.status.getTaskStep().setCurrentStepDescription(parquetInfo.serialize());
                    LoggerAdapter.info(this, parquetInfo.toString());
                }
                if (parquetInfo.containsKey((Object)"error")) {
                    this.status.setState("ERROR");
                }
                return parquetInfo;
            }
        }
        catch (Exception e) {
            this.status.setState("ERROR");
            LoggerAdapter.errorExceptionStack(this, e);
        }
        return new Object();
    }
}

