/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.ParquetUtils;
import com.ibm.bi.platform.moser.core.utils.RequestCacheManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import javax.ws.rs.core.Response;

public abstract class ParquetUpgradeTaskBase
extends BaseMoserTask {
    protected static final String ERROR = "error";
    protected final String version;

    public ParquetUpgradeTaskBase(RequestEnvironment requestEnv, String version) {
        super(requestEnv);
        this.version = version;
        Locale productLocale = requestEnv.getProductLocale();
        this.status.setTaskStep(new TaskStep(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_PARQUET_UPGRADE, (Locale)productLocale), 1));
    }

    @Override
    protected synchronized void completeWithSuccess(MoserInfo response) {
        this.status.response = response;
        this.status.state = "SUCCESS";
    }

    @Override
    public void cancelRemoteTask() {
    }

    @Override
    public void run() {
        Locale productLocale = this.requestEnv.getProductLocale();
        try {
            if ("ERROR".equals(this.status.getState())) {
                return;
            }
            this.status.setState("EXECUTING");
            this.status.getTaskStep().incrementStepNumber();
            this.status.getTaskStep().setCurrentStepDescription(MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_STS_PARQUET_UPGRADE, (Locale)productLocale));
            Object results = this.upgrade();
            ParquetUpgradeTaskBase.throwIfCancelled(this.status, "parquet upgrade");
            this.status.setCompletionTimestamp(RequestCacheManager.registerResponseTimestamp("parquet upgrade"));
            this.status.setResponse(results);
            this.status.setTaskStep(null);
            if ("EXECUTING".equals(this.status.getState())) {
                this.status.setState("SUCCESS");
            }
        }
        catch (MoserCancelException c) {
            this.handleCancel(c);
        }
        catch (Exception e) {
            String locmsg = MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_PARQUET_UPGRADE_TASK_ERROR, (Locale)productLocale);
            this.status.setState("ERROR");
            this.status.setErrorMessage(locmsg);
            this.status.setResponse(MoserUtil.getResponse(Response.Status.BAD_REQUEST, MoserError.MSR_PARQUET_UPGRADE_TASK_ERROR, productLocale, (Throwable)e));
            this.status.setTaskStep(null);
        }
    }

    protected JSONObject createSmartModel(JSONObject parquetInfo) {
        try {
            String assetId = (String)parquetInfo.get((Object)"AssetId");
            String moduleId = (String)parquetInfo.get((Object)"ModuleId");
            String sourceType = (String)parquetInfo.get((Object)"sourceType");
            this.status.getTaskStep().setCurrentStepDescription("Upgrading the smart module:" + assetId);
            IModuleObjectManager mm = this.requestEnv.getModuleObjectManager();
            Module baseModule = mm.getBaseModule(moduleId, null);
            LoggerAdapter.info(this, "[PERF:UPGRADE]: Begin - Smarts analysis for file ");
            boolean result = SmartsServiceUtil.createSmartsModule(assetId, baseModule, sourceType != null && "dataset".equals(sourceType) ? UseSpecType.DATASET : UseSpecType.FILE, Optional.empty(), t -> {}, SmartsService.AnalysisMode.DEEP, this.requestEnv, null, this.requestEnv.getTaskStatus(), null);
            LoggerAdapter.info(this, "[PERF:UPGRADE]: End - Smarts analysis for file");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"SmartUpdate", (Object)result);
            jsonObject.put((Object)"AssetId", (Object)assetId);
            jsonObject.put((Object)"ModuleId", (Object)moduleId);
            jsonObject.put((Object)"sourceType", (Object)sourceType);
            return jsonObject;
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Upgrade failed to create a smart moudule: ", e);
            return null;
        }
    }

    protected abstract Object upgrade();

    protected JSONObject upgrade(ModuleStorageCM moduleStorageCM, JSONObject parquetInfo) {
        String objectId = (String)parquetInfo.get((Object)"storeID");
        RESTClientResponse resp = moduleStorageCM.getResource(objectId, "format", "defaultName", "type", "dataDescriptor");
        if (resp.getResponseCode() != 200) {
            JSONObject res = new JSONObject();
            res.put((Object)ERROR, (Object)resp.getResponseCode());
            return res;
        }
        JSONObject output = new JSONObject();
        Random random = new Random(1000L);
        String tempDir = "parquetFile_" + objectId + "_" + Integer.toString(random.nextInt());
        RESTClientResponse response = this.requestEnv.getModuleObjectManager().upgradeParquetFile(objectId, tempDir, this.status);
        int respCode = response.getResponseCode();
        if (respCode != 201 && respCode != 204 && respCode != 200) {
            output.put((Object)ERROR, (Object)resp.getResponseCode());
            LoggerAdapter.error(this, "Failed to upload after upgrade, code : '" + Integer.valueOf(respCode) + "'");
            return output;
        }
        JSONArray children = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        Iterator iterator = children.iterator();
        if (iterator.hasNext()) {
            Object c = iterator.next();
            JSONObject child = (JSONObject)c;
            output = ParquetUtils.createOutputContainerJSON(child, this.version, this.getTaskID());
        }
        moduleStorageCM.putResource(objectId, output);
        return output;
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        LoggerAdapter.errorExceptionStack(ParquetUpgradeTaskBase.class, e);
    }
}

