/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.IMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.soap.services.ClonedServletRequest;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RunInClonedPassportTask
extends BaseMoserTask {
    private BaseMoserTask mTask;
    private String clonedPassport = null;
    private long logoutDelay = 0L;

    public RunInClonedPassportTask(RequestEnvironment runtime, IMoserTask task) {
        this(runtime, task, MoserConfig.getDefaultLogoutDelay());
    }

    public RunInClonedPassportTask(RequestEnvironment runtime, IMoserTask task, long delay) {
        super(runtime);
        this.mTask = (BaseMoserTask)task;
        this.logoutDelay = delay;
        this.setupEnvToRunWithClonedPassport();
    }

    @Override
    public void cancelRemoteTask() {
        this.mTask.cancelRemoteTask();
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
    }

    @Override
    public void run() {
        try {
            LoggerAdapter.trace(this, "Running task with cloned passport");
            this.mTask.run();
        }
        finally {
            this.logoff();
        }
    }

    @Override
    public synchronized TaskStatus getStatus() {
        return this.mTask.getStatus();
    }

    @Override
    public void awaitCancellation() {
        this.mTask.awaitCancellation();
    }

    @Override
    public synchronized boolean cancel() {
        return this.mTask.cancel();
    }

    @Override
    public int hashCodeSeed() {
        return this.mTask.hashCodeSeed();
    }

    @Override
    public boolean isEqual(Object obj) {
        return this.mTask.isEqual(obj);
    }

    private void logoff() {
        final RequestEnvironment runtime = this.getRuntimeEnv();
        if (runtime == null) {
            return;
        }
        if (this.clonedPassport != null) {
            if (this.getLogoutDelay() > 0L) {
                LoggerAdapter.trace(this, "Firing off a timer to logoff.");
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LoggerAdapter.trace(this, "Logging off task running with cloned passport");
                        runtime.getUserProfileService().logoff();
                    }
                }, this.getLogoutDelay());
            } else {
                runtime.getUserProfileService().logoff();
            }
        }
    }

    private long getLogoutDelay() {
        return this.logoutDelay;
    }

    private void setupEnvToRunWithClonedPassport() {
        RequestEnvironment runtime = this.getRuntimeEnv();
        if (runtime == null) {
            return;
        }
        String newPassport = runtime.getClonePassportService().get();
        if (newPassport == null) {
            LoggerAdapter.error(this, "Unable to setup task to run with cloned passport. Will run task with original passport");
            return;
        }
        ClonedServletRequest moserServletRequest = new ClonedServletRequest(runtime.getHttpServletRequest());
        String xsrfCookieValue = null;
        if (moserServletRequest.getCookies() != null) {
            for (Cookie cookie : moserServletRequest.getCookies()) {
                if (!"XSRF-TOKEN".equalsIgnoreCase(cookie.getName())) continue;
                xsrfCookieValue = cookie.getValue();
                break;
            }
        }
        Cookie[] cookies = xsrfCookieValue != null ? new Cookie[]{new Cookie("cam_passport", newPassport), new Cookie("XSRF-TOKEN", xsrfCookieValue)} : new Cookie[]{new Cookie("cam_passport", newPassport)};
        moserServletRequest.setCookies(cookies);
        RequestEnvironment newEnv = new RequestEnvironment((HttpServletRequest)moserServletRequest, runtime);
        this.clonedPassport = newPassport;
        LoggerAdapter.trace(this, "Running task with cloned passport");
        this.setRuntimeEnv(newEnv);
        this.mTask.setRuntimeEnv(newEnv);
    }
}

