/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class SmartsCollectionTask
extends BaseMoserTask {
    String resourceID;
    JSONObject loadOptions;
    String type;
    private String connectionInfo;
    private SmartsService.AnalysisMode analysisMode;

    public SmartsCollectionTask(RequestEnvironment requestEnv, String resourceID, JSONObject loadOptions, String type, String connectionInfo, SmartsService.AnalysisMode mode) {
        super(requestEnv);
        this.status.setResourceID(resourceID);
        this.status.setTaskType("SmartsCollection");
        this.resourceID = resourceID;
        this.loadOptions = loadOptions;
        this.type = type;
        this.connectionInfo = connectionInfo;
        this.analysisMode = mode;
    }

    @Override
    public void cancelRemoteTask() {
        this.requestEnv.getSmartsService().cancelSmartsCollection(this.resourceID);
    }

    @Override
    public void run() {
        try {
            BaseMoserTask.throwIfCancelled(this.status, "collect smarts");
            this.status.setState("EXECUTING");
            UseSpecType moduleType = this.requestEnv.getModuleObjectManager().getModuleType(this.resourceID, this.type);
            Module module = this.requestEnv.getModuleObjectManager().getBaseModule(this.resourceID, moduleType);
            if (module == null) {
                module = this.requestEnv.getModuleObjectManager().getBusinessModuleMetadata(this.resourceID, moduleType);
            }
            BaseMoserTask.throwIfCancelled(this.status, "collect smarts");
            if (SmartsServiceUtil.createSmartsModule(this.resourceID, module, moduleType, Optional.empty(), t -> {}, this.analysisMode, this.requestEnv, this.loadOptions, this.status, this.connectionInfo)) {
                this.status.setResponse(MoserUtil.getResponse(Response.Status.CREATED));
                this.status.setState("SUCCESS");
            }
        }
        catch (MoserCancelException ce) {
            this.handleCancel(ce);
        }
        catch (Throwable e) {
            LoggerAdapter.errorExceptionStack(this, e);
            String errMsg = MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_SMT_INTERNAL_SMARTS, (Locale)this.requestEnv.getProductLocale());
            TaskStatus newStatus = new TaskStatus("ERROR");
            newStatus.setErrorMessage(errMsg);
            newStatus.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.MSR_SMT_INTERNAL_SMARTS, this.requestEnv.getProductLocale(), e));
            this.setStatus(newStatus);
            this.requestEnv.getSmartsService().cancelSmartsCollection(this.resourceID);
        }
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
        LoggerAdapter.error((Object)this, "Smarts collection was cancelled", e);
    }
}

