/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"state", "errorMessage", "response", "taskStep", "resourceID", "taskType", "taskID"})
@XmlRootElement(name="taskStatus")
public class TaskStatus {
    public static final String PENDING = "PENDING";
    public static final String EXECUTING = "EXECUTING";
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    public static final String CANCELLED = "CANCELLED";
    public static final String NOT_AVAILABLE = "NOT_AVAILABLE";
    public static final String NOT_CANCELLABLE = "NOT_CANCELLABLE";
    protected String state = "PENDING";
    protected String errorMessage;
    protected Object response;
    protected TaskStep taskStep = null;
    protected Date completionTimestamp = null;
    String resourceID = null;
    String taskType = null;
    String taskID = null;
    long cmUpdateTime = 0L;

    public TaskStatus() {
    }

    public TaskStatus(String state) {
        this.state = state;
    }

    public synchronized TaskStatus clone() {
        TaskStatus clone = new TaskStatus();
        clone.state = this.state;
        clone.errorMessage = this.errorMessage;
        clone.response = this.response;
        if (this.taskStep != null) {
            clone.taskStep = this.taskStep.clone();
        }
        clone.completionTimestamp = this.completionTimestamp == null ? null : (Date)this.completionTimestamp.clone();
        clone.taskID = this.taskID;
        clone.resourceID = this.resourceID;
        clone.taskType = this.taskType;
        clone.cmUpdateTime = this.cmUpdateTime;
        return clone;
    }

    public synchronized void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public synchronized String getResourceID() {
        return this.resourceID;
    }

    public synchronized void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public synchronized String getTaskType() {
        return this.taskType;
    }

    public synchronized void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public synchronized String getTaskID() {
        return this.taskID;
    }

    public synchronized void setState(String state) {
        this.state = state;
    }

    public synchronized String getState() {
        return this.state;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public synchronized void setResponse(Object response) {
        this.response = response;
    }

    public synchronized void setTaskStep(TaskStep taskStep) {
        this.taskStep = taskStep;
    }

    public synchronized void setCompletionTimestamp(Date completionTimestamp) {
        this.completionTimestamp = completionTimestamp == null ? null : (Date)completionTimestamp.clone();
    }

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized Object getResponse() {
        return this.response;
    }

    public synchronized TaskStep getTaskStep() {
        return this.taskStep;
    }

    public synchronized Date getCompletionTimestamp() {
        return this.completionTimestamp == null ? null : (Date)this.completionTimestamp.clone();
    }

    public synchronized void setCMUpdateTime(long t) {
        this.cmUpdateTime = t;
    }

    public synchronized long getCMUpdateTime() {
        return this.cmUpdateTime;
    }

    public boolean isCancelled() {
        return CANCELLED.equals(this.getState());
    }

    public synchronized boolean canCancel() {
        return PENDING.equals(this.state) || EXECUTING.equals(this.state);
    }

    public String toString() {
        JSONCodec jsonCodec = new JSONCodec();
        return jsonCodec.encode(this);
    }

    public boolean isError() {
        return ERROR.equals(this.getState());
    }

    public boolean isPending() {
        return PENDING.equals(this.getState());
    }

    public boolean isExecuting() {
        return EXECUTING.equals(this.getState());
    }

    public boolean isSuccess() {
        return SUCCESS.equals(this.getState());
    }

    public boolean isNotCancellable() {
        return NOT_CANCELLABLE.equals(this.getState());
    }

    public JSONObject toJSON() {
        return MoserUtil.toJSON(this);
    }

    public boolean isRunning() {
        return !this.isError() && !this.isSuccess() && !this.isCancelled();
    }

    public boolean isNotAvailable() {
        return NOT_AVAILABLE.equals(this.getState());
    }
}

