/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"taskDescription", "currentStepDescription", "currentStep", "numCompleted", "nTotalSteps", "currentSubTask", "info", "concurrentTasks"})
@XmlRootElement(name="taskStep")
public class TaskStep {
    protected String taskDescription = null;
    protected String currentStepDescription = null;
    protected int currentStepNum = 0;
    protected int numTotalSteps = -1;
    protected TaskStep currentSubTask = null;
    protected Integer numCompleted;
    protected String info;
    List<TaskStep> concurrentTasks;

    public TaskStep(String taskDescription, int nTotalSteps) {
        this.taskDescription = taskDescription;
        this.numTotalSteps = nTotalSteps;
    }

    public TaskStep() {
    }

    public TaskStep clone() {
        TaskStep clone = new TaskStep();
        clone.taskDescription = this.taskDescription;
        clone.currentStepDescription = this.currentStepDescription;
        clone.currentStepNum = this.currentStepNum;
        clone.numTotalSteps = this.numTotalSteps;
        clone.numCompleted = this.numCompleted;
        clone.info = this.info;
        clone.currentSubTask = this.currentSubTask != null ? this.currentSubTask.clone() : null;
        if (this.concurrentTasks != null) {
            clone.concurrentTasks = new ArrayList<TaskStep>();
            for (TaskStep aTask : this.concurrentTasks) {
                clone.concurrentTasks.add(aTask.clone());
            }
        }
        return clone;
    }

    public void setCurrentSubtask(TaskStep subtask) {
        this.currentSubTask = subtask;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public int getNumTotalSteps() {
        return this.numTotalSteps;
    }

    public long getCurrentStep() {
        return this.currentStepNum;
    }

    public TaskStep getCurrentSubTask() {
        return this.currentSubTask;
    }

    public void incrementStepNumber() {
        ++this.currentStepNum;
        this.currentSubTask = null;
    }

    public String getCurrentStepDescription() {
        return this.currentStepDescription;
    }

    public void setCurrentStepDescription(String description) {
        this.currentStepDescription = description;
    }

    public void setTotalSteps(int nSteps) {
        this.numTotalSteps = nSteps;
    }

    public void setNumCompleted(int num) {
        this.numCompleted = num;
    }

    public Integer getNumCompleted() {
        return this.numCompleted;
    }

    public void setStepInfo(String infoMsg) {
        this.info = infoMsg;
    }

    public void setConcurrentTasks(List<TaskStep> taskSteps) {
        this.concurrentTasks = taskSteps;
    }

    public TaskStep getConcurrentTask(String name) {
        for (TaskStep tStep : this.concurrentTasks) {
            if (!name.equals(tStep.getTaskDescription())) continue;
            return tStep;
        }
        return null;
    }
}

