/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks.upload;

import com.ibm.bi.platform.moser.common.exceptions.file.WrongTypeException;
import com.ibm.bi.platform.moser.core.importer.IImportHandler;
import com.ibm.bi.platform.moser.core.importer.ImportReceipt;
import com.ibm.bi.platform.moser.core.importer.file.FileDataCollector;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.upload.UploadTask;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ReplaceTask
extends UploadTask {
    protected final String objectId;

    public ReplaceTask(RequestEnvironment requestEnv, FileDataCollector dataCollector) {
        super(requestEnv, dataCollector);
        this.objectId = dataCollector.getFileUploadId();
    }

    @Override
    protected ImportReceipt runHandler(IImportHandler importHandler, InputStream data) {
        return importHandler.replaceData(data, this.fileName, this.mimeType, this.objectId);
    }

    public static void preReplaceData(RequestEnvironment requestEnv, String objectId, String fileName, String mimeType) {
        List<Constructor<?>> importHandlers = ReplaceTask.assignImportHandlers(HANDLER_MAPPINGS, mimeType, fileName);
        for (Constructor<?> handler : importHandlers) {
            try {
                IImportHandler importHandler = (IImportHandler)handler.newInstance(requestEnv);
                importHandler.preReplaceData(fileName, objectId);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LoggerAdapter.errorExceptionStack(UploadTask.class, e);
            }
            catch (WrongTypeException e) {
                LoggerAdapter.debug(UploadTask.class, "Unexpected existing object type for handler '" + handler.getDeclaringClass().getSimpleName() + "'", e);
            }
        }
    }
}

