/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.tasks.upload;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.file.UnsupportedFileTypeException;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.importer.IImportHandler;
import com.ibm.bi.platform.moser.core.importer.ImportReceipt;
import com.ibm.bi.platform.moser.core.importer.file.FileDataCollector;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;

public class UploadTask
extends BaseMoserTask {
    public static final JSONObject HANDLER_MAPPINGS = MoserConfig.getImportHandlerMapping();
    protected static final Map<String, Constructor<?>> CONSTRUCTORS = new ConcurrentHashMap();
    protected final FileDataCollector dataCollector;
    protected final String mimeType;
    protected final String fileName;
    protected final String destinationId;
    protected final List<Constructor<?>> importHandlers;

    public UploadTask(RequestEnvironment requestEnv, FileDataCollector dataCollector) {
        super(requestEnv);
        this.dataCollector = dataCollector;
        this.mimeType = dataCollector.getMimeType();
        this.fileName = dataCollector.getFileName();
        this.destinationId = dataCollector.getDestinationId();
        this.importHandlers = UploadTask.assignImportHandlers(HANDLER_MAPPINGS, this.mimeType, this.fileName);
        requestEnv.getTaskStatus().setTaskType("Upload");
        Locale productLocale = requestEnv.getProductLocale();
        if (!this.isReallySupported()) {
            this.status.setState("ERROR");
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_UNSUPPORTED_FILE_TYPE, (Locale)productLocale, (String)this.fileName));
            this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.MSR_UNSUPPORTED_FILE_TYPE, productLocale, this.fileName, null));
        }
    }

    protected static List<Constructor<?>> assignImportHandlers(JSONObject importHandlerMappings, String mimeType, String fileName) {
        String ext = FilenameUtils.getExtension((String)fileName).toLowerCase();
        ArrayList handlers = new ArrayList();
        for (Object e : importHandlerMappings.entrySet()) {
            Constructor<?> constructor;
            Map.Entry entry = (Map.Entry)e;
            String className = (String)entry.getKey();
            JSONObject mapping = (JSONObject)entry.getValue();
            JSONArray extensions = (JSONArray)mapping.get((Object)mimeType);
            if (extensions == null || !extensions.contains((Object)ext) && !extensions.contains((Object)"*") || (constructor = UploadTask.getConstructor(className)) == null) continue;
            handlers.add(constructor);
        }
        return handlers;
    }

    private static Constructor<?> getConstructor(String className) {
        Constructor<?> constructor = CONSTRUCTORS.get(className);
        if (constructor == null) {
            try {
                Class<?> clazz = Class.forName(className);
                constructor = clazz.getConstructor(RequestEnvironment.class);
                CONSTRUCTORS.put(className, constructor);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                LoggerAdapter.errorExceptionStack(UploadTask.class, e);
            }
        }
        return constructor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReallySupported() {
        Iterator<Constructor<?>> iterator = this.importHandlers.iterator();
        while (iterator.hasNext()) {
            Constructor<?> handler = iterator.next();
            try {
                InputStream data = this.dataCollector.openContentStream();
                Throwable throwable = null;
                try {
                    IImportHandler importHandler = (IImportHandler)handler.newInstance(this.requestEnv);
                    if (!importHandler.isReallySupported(this.mimeType, this.fileName, data)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (data == null) continue;
                    if (throwable != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    data.close();
                }
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LoggerAdapter.errorExceptionStack(this, e);
            }
        }
        return false;
    }

    private synchronized void setExecuting() {
        if ("CANCELLED".equals(this.status.getState())) {
            throw new MoserCancelException("file upload");
        }
        this.status.setState("EXECUTING");
    }

    @Override
    public void run() {
        try {
            this.setExecuting();
            ImportReceipt receipt = this.runHandlers();
            this.completeWithSuccess(MoserInfoUtil.createMoserInfo(MoserUtil.getTimeGregorianUTC(receipt.getStartTime()).toString(), MoserUtil.getTimeGregorianUTC(receipt.getEndTime()).toString(), receipt.getIds().toArray(new String[receipt.getIds().size()])));
        }
        catch (MoserCancelException c) {
            this.handleCancel(c);
        }
        catch (MoserException e) {
            LoggerAdapter.debug((Object)this, "Upload failed due to: " + e.getLocalizedMessage(), e);
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)this.requestEnv.getProductLocale(), (String)this.fileName));
            this.status.setResponse(e.getResponse(this.requestEnv.getProductLocale()));
            this.status.setState("ERROR");
        }
        catch (Exception e) {
            LoggerAdapter.errorExceptionStack(this, e);
            this.status.setState("ERROR");
            this.status.setErrorMessage(MoserMessages.getMessage((IMessageKey.Param1)MoserError.FILE_UPLOAD_ERROR, (Locale)this.requestEnv.getProductLocale(), (String)this.fileName));
            this.status.setResponse(MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, MoserError.FILE_UPLOAD_ERROR, this.requestEnv.getProductLocale(), this.fileName, e));
            this.status.setState("ERROR");
        }
        finally {
            this.dataCollector.cleanUp();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImportReceipt runHandlers() {
        UnsupportedFileTypeException unsupportedFileTypeException;
        Object initialException = null;
        for (Constructor<?> handler : this.importHandlers) {
            try (InputStream data = this.dataCollector.openContentStream();){
                IImportHandler importHandler = (IImportHandler)handler.newInstance(this.requestEnv);
                ImportReceipt importReceipt = this.runHandler(importHandler, data);
                return importReceipt;
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LoggerAdapter.errorExceptionStack(this, e);
            }
            catch (MoserException e) {
                LoggerAdapter.debug((Object)this, "Import handler '" + handler.getDeclaringClass().getSimpleName() + "' failed to import file: " + this.fileName, e);
                initialException = initialException == null ? e : initialException;
            }
        }
        if (initialException == null) {
            unsupportedFileTypeException = new UnsupportedFileTypeException(this.fileName);
            throw unsupportedFileTypeException;
        }
        unsupportedFileTypeException = initialException;
        throw unsupportedFileTypeException;
    }

    protected ImportReceipt runHandler(IImportHandler importHandler, InputStream data) {
        return importHandler.importData(data, this.fileName, this.mimeType, this.destinationId);
    }

    @Override
    public void cancelRemoteTask() {
    }

    @Override
    public void cancelHandler(MoserCancelException e) {
    }

    public static boolean isGenericUpload(RequestEnvironment requestEnv, String fileName, String mimeType) {
        List<Constructor<?>> importHandlers = UploadTask.assignImportHandlers(HANDLER_MAPPINGS, mimeType, fileName);
        for (Constructor<?> handler : importHandlers) {
            try {
                IImportHandler importHandler = (IImportHandler)handler.newInstance(requestEnv);
                if (!importHandler.isSupported(mimeType, fileName)) continue;
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LoggerAdapter.errorExceptionStack(UploadTask.class, e);
            }
        }
        return false;
    }

    public static void preImportData(RequestEnvironment requestEnv, String destinationId, String fileName, String mimeType) {
        List<Constructor<?>> importHandlers = UploadTask.assignImportHandlers(HANDLER_MAPPINGS, mimeType, fileName);
        for (Constructor<?> handler : importHandlers) {
            try {
                IImportHandler importHandler = (IImportHandler)handler.newInstance(requestEnv);
                importHandler.preImportData(fileName, destinationId);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LoggerAdapter.errorExceptionStack(UploadTask.class, e);
            }
        }
    }
}

