/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.translator.report;

import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.core.translator.report.IReportVisitor;
import com.ibm.bi.platform.moser.core.translator.report.TranslatorUtils;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Report
extends Module
implements IReportVisitor {
    private static final String INTERMEDIATE_QUERIES = "Intermediate queries";
    private static final String INTERMEDIATE_QUERIES_ID = "[Intermediate queries]";
    private static final String INTERMEDIATE_QUERIES_DESC = "Queries that are not directly used in the report's pages";
    private static final String MODULE_DESC = "This module was converted from a report using: %s";
    private static final String PROMPT_QUERIES = "Prompt queries";
    private static final String PROMPT_QUERIES_ID = "[Prompt queries]";
    private static final String PROMPT_QUERIES_DESC = "Queries that are only used in the report's prompt pages";
    private static final String EXPRESSION_LOCALE = "expressionLocale";
    private static final String LAYOUTS = "layouts";
    private static final String MODEL_PATH = "modelPath";
    private static final String NAME = "name";
    private static final String PROMPT_PAGES = "promptPages";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final String REF_DATA_STORE = "refDataStore";
    private static final String REF_QUERY = "refQuery";
    private static final String REPORT_DATASTORE = "reportDataStore";
    private static final String REPORT_DATASTORES = "reportDataStores";
    private static final String REPORT_NAME = "reportName";
    private static final String REPORT_PAGES = "reportPages";
    private static final String TYPE = "type";
    @XmlTransient
    private FolderType rootFolder = null;
    @XmlTransient
    private FolderType parentFolder = null;
    @XmlTransient
    private FolderType promptFolder = null;
    @XmlTransient
    private FolderType unusedFolder = null;
    @XmlTransient
    private Set<String> promptQueries = new HashSet<String>();
    @XmlTransient
    private Set<String> promptDataStores = new HashSet<String>();
    @XmlTransient
    private Set<String> pageQueries = new HashSet<String>();
    @XmlTransient
    private Set<String> pageDataStores = new HashSet<String>();
    @XmlTransient
    private Map<String, String> dataStoreToQuery = new HashMap<String, String>();

    @Override
    public void visit(Element element) {
        Node child;
        int i;
        this.setContainer("C");
        this.setVersion("11.1");
        this.setComment(String.format(MODULE_DESC, this.getClass().getName()));
        this.rootFolder = new FolderType();
        this.addMetadataTreeView(this.rootFolder);
        this.parentFolder = this.rootFolder;
        String expLocale = element.getAttribute(EXPRESSION_LOCALE);
        if (StringUtils.isNotEmpty((CharSequence)expLocale)) {
            this.setExpressionLocale(expLocale);
        }
        NodeList children = TranslatorUtils.getNodeList(element);
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.visitPages((Element)child);
        }
        this.cleanQueries();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.visitReportChild((Element)child);
        }
    }

    private void visitPages(Element element) {
        String name = element.getNodeName();
        if (LAYOUTS.equals(name)) {
            this.visitLayouts(element);
        } else if (REPORT_DATASTORES.equals(name)) {
            this.visitReportDataStores(element);
        }
    }

    private void cleanQueries() {
        for (String storeName : this.pageDataStores) {
            this.pageQueries.add(this.dataStoreToQuery.get(storeName));
        }
        for (String storeName : this.promptDataStores) {
            this.promptQueries.add(this.dataStoreToQuery.get(storeName));
        }
        if (!this.promptQueries.isEmpty()) {
            this.promptQueries.removeAll(this.pageQueries);
        }
    }

    private void visitReportChild(Element element) {
        String name = element.getNodeName();
        if (MODEL_PATH.equals(name)) {
            this.visitModelPath(element);
        } else if (QUERIES.equals(name)) {
            NodeList children = element.getElementsByTagName(QUERY);
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                this.visitQuery(child);
            }
        } else if (REPORT_NAME.equals(name)) {
            this.visitReportName(element);
        }
    }

    private void visitModelPath(Element element) {
        String type = element.getAttribute(TYPE);
        String searchPath = TranslatorUtils.getValue(element);
        if (StringUtils.isEmpty((CharSequence)searchPath)) {
            return;
        }
        Module.UseSpec uSpec = new Module.UseSpec();
        uSpec.setType(TranslatorUtils.getUseSpecType(type));
        uSpec.setDataCacheExpiry("0");
        uSpec.setSearchPath(searchPath);
        uSpec.setIdentifier("M" + Integer.toString(this.getUseSpec().size() + 1));
        this.addUseSpec(uSpec);
    }

    private void visitQuery(Element element) {
        Query query = new Query();
        query.visit(element);
        if (StringUtils.isEmpty((CharSequence)query.getIdentifier())) {
            return;
        }
        if (query.isFolder()) {
            FolderType folder = new FolderType();
            folder.setIdentifier(query.getIdentifier());
            folder.setLabel(query.getLabel());
            this.addToParentFolder((ObjectType)folder);
        } else {
            this.addQuerySubject(query);
            if (this.promptQueries.contains(query.getLabel())) {
                this.addToPromptFolder(query);
            } else if (!this.pageQueries.contains(query.getLabel())) {
                this.addToIntermediateFolder(query);
            } else {
                this.addToParentFolder((ObjectType)query);
            }
            Module.UseSpec uSpec = query.getUseSpec();
            if (uSpec != null) {
                uSpec.setIdentifier("M" + Integer.toString(this.getUseSpec().size() + 1));
                this.addUseSpec(uSpec);
            }
        }
    }

    private void addToParentFolder(ObjectType object) {
        if ("QuerySubject".equals(object.getObjectType())) {
            FolderItemType folderItem = new FolderItemType();
            folderItem.setRef(object.getIdentifier());
            this.parentFolder.addFolderItem(folderItem);
        } else if ("FolderType".equals(object.getObjectType())) {
            FolderItemType folderItem = new FolderItemType();
            folderItem.setFolder((FolderType)object);
            this.rootFolder.addFolderItem(folderItem);
            this.parentFolder = (FolderType)object;
        }
    }

    private void addToPromptFolder(QuerySubject qs) {
        FolderItemType folderItem;
        if (this.promptFolder == null) {
            this.promptFolder = new FolderType();
            this.promptFolder.setIdentifier(PROMPT_QUERIES_ID);
            this.promptFolder.setLabel(PROMPT_QUERIES);
            this.promptFolder.setDescription(PROMPT_QUERIES_DESC);
            folderItem = new FolderItemType();
            folderItem.setFolder(this.promptFolder);
            this.rootFolder.addFolderItemAt(0, folderItem);
        }
        folderItem = new FolderItemType();
        folderItem.setRef(qs.getIdentifier());
        this.promptFolder.addFolderItem(folderItem);
    }

    private void addToIntermediateFolder(QuerySubject qs) {
        FolderItemType folderItem;
        if (this.unusedFolder == null) {
            this.unusedFolder = new FolderType();
            this.unusedFolder.setIdentifier(INTERMEDIATE_QUERIES_ID);
            this.unusedFolder.setLabel(INTERMEDIATE_QUERIES);
            this.unusedFolder.setDescription(INTERMEDIATE_QUERIES_DESC);
            folderItem = new FolderItemType();
            folderItem.setFolder(this.unusedFolder);
            this.rootFolder.addFolderItemAt(0, folderItem);
        }
        folderItem = new FolderItemType();
        folderItem.setRef(qs.getIdentifier());
        this.unusedFolder.addFolderItem(folderItem);
    }

    private void visitReportName(Element element) {
        String reportName = TranslatorUtils.getValue(element);
        if (StringUtils.isNotEmpty((CharSequence)reportName)) {
            this.setIdentifier(TranslatorUtils.nameToBracketedIdentifierSimple(reportName));
            this.setLabel(reportName);
        }
    }

    private void visitLayouts(Element element) {
        NodeList children = TranslatorUtils.getNodeList(element);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.visitLayout((Element)child);
        }
    }

    private void visitLayout(Element element) {
        NodeList children = TranslatorUtils.getNodeList(element);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.visitLayoutChild((Element)child);
        }
    }

    private void visitLayoutChild(Element element) {
        String name = element.getNodeName();
        if (PROMPT_PAGES.equals(name)) {
            this.visitPromptPages(element);
        } else if (REPORT_PAGES.equals(name)) {
            this.visitReportPages(element);
        }
    }

    private void visitPromptPages(Node node) {
        String dataStoreName;
        String queryName = TranslatorUtils.getAttribute(node, REF_QUERY);
        if (StringUtils.isNotEmpty((CharSequence)queryName)) {
            this.promptQueries.add(queryName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(dataStoreName = TranslatorUtils.getAttribute(node, REF_DATA_STORE)))) {
            this.promptDataStores.add(dataStoreName);
        }
        NodeList children = TranslatorUtils.getNodeList(node);
        for (int i = 0; i < children.getLength(); ++i) {
            this.visitPromptPages(children.item(i));
        }
    }

    private void visitReportPages(Node node) {
        String dataStoreName;
        String queryName = TranslatorUtils.getAttribute(node, REF_QUERY);
        if (StringUtils.isNotEmpty((CharSequence)queryName)) {
            this.pageQueries.add(queryName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(dataStoreName = TranslatorUtils.getAttribute(node, REF_DATA_STORE)))) {
            this.pageDataStores.add(dataStoreName);
        }
        NodeList children = TranslatorUtils.getNodeList(node);
        for (int i = 0; i < children.getLength(); ++i) {
            this.visitReportPages(children.item(i));
        }
    }

    private void visitReportDataStores(Node node) {
        String name = node.getNodeName();
        if (REPORT_DATASTORE.equals(name)) {
            String storeName = TranslatorUtils.getAttribute(node, NAME);
            if (StringUtils.isNotEmpty((CharSequence)storeName)) {
                this.visitReportDataStoreChild(storeName, node);
            }
        } else {
            NodeList children = TranslatorUtils.getNodeList(node);
            for (int i = 0; i < children.getLength(); ++i) {
                this.visitReportDataStores(children.item(i));
            }
        }
    }

    private void visitReportDataStoreChild(String storeName, Node node) {
        String queryName = TranslatorUtils.getAttribute(node, REF_QUERY);
        if (StringUtils.isNotEmpty((CharSequence)queryName)) {
            this.dataStoreToQuery.put(storeName, queryName);
        } else {
            NodeList children = TranslatorUtils.getNodeList(node);
            for (int i = 0; i < children.getLength(); ++i) {
                this.visitReportDataStoreChild(storeName, children.item(i));
            }
        }
    }
}

