/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.translator.report;

import com.ibm.bi.platform.moser.common.exceptions.translator.report.ReportEmptyException;
import com.ibm.bi.platform.moser.common.exceptions.translator.report.ReportNotFoundException;
import com.ibm.bi.platform.moser.common.exceptions.translator.report.TranslationException;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.cm.objects.TempReport;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerCM;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.ReportService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.bi.platform.moser.core.translator.IModuleTranslator;
import com.ibm.bi.platform.moser.core.translator.report.Report;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ReportTranslator
implements IModuleTranslator {
    private static final String REPORT = "report";
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private final RequestEnvironment requestEnv;
    private final String spec;
    private String etag;
    private long lastModified;
    private String lastId;
    private String normalizedSpec;

    public ReportTranslator(RequestEnvironment requestEnv, String spec) {
        this.requestEnv = requestEnv;
        this.spec = spec;
        this.etag = null;
        this.lastModified = 0L;
    }

    @Override
    public boolean isSupported(String type) {
        return REPORT.equals(type);
    }

    @Override
    public boolean isModified(String id, String eTag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return true;
        }
        if (this.isSessionReport(id)) {
            return this.isModifiedTemp(id, eTag);
        }
        ContentService contentService = this.requestEnv.getContentService();
        RESTClientResponse resp = MoserUtil.isStoreId(id) ? contentService.getWithEtag(ContentService.ContentResource.OBJECTS, id, null, null, eTag, "defaultName") : contentService.getBySearchPathWithEtag(id, eTag, "defaultName");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode() && resp.getResponseCode() != Response.Status.NOT_MODIFIED.getStatusCode()) {
            throw new ReportNotFoundException(id);
        }
        this.etag = resp.getResponseHeader("ETag");
        String lm = resp.getResponseHeader("Last-Modified");
        if (StringUtils.isNotEmpty((CharSequence)lm)) {
            try {
                this.lastModified = DateUtil.parseDate((String)lm).getTime();
            }
            catch (DateParseException e) {
                LoggerAdapter.errorExceptionStack(ModuleObjectManagerCM.class, e);
            }
        }
        return resp.getResponseCode() != Response.Status.NOT_MODIFIED.getStatusCode();
    }

    public boolean isSessionReport(String id) {
        return UserProfileService.isSessionReport(id);
    }

    private boolean isModifiedTemp(String id, String eTag) {
        TempReport tempReport = this.getTempReport(id);
        this.etag = tempReport.getEtag();
        String ts = tempReport.getTimestamp();
        if (StringUtils.isNotEmpty((CharSequence)ts)) {
            this.lastModified = MoserUtil.getTimeInMillis(ts);
        }
        this.lastId = id;
        this.normalizedSpec = tempReport.getSpecification();
        return StringUtils.isEmpty((CharSequence)this.etag) || !this.etag.equals(eTag) && !("\"" + this.etag + "\"").equals(eTag);
    }

    private TempReport getTempReport(String id) {
        String tempId;
        UserProfileService ups = this.requestEnv.getUserProfileService();
        RESTClientResponse resp = ups.get(UserProfileService.UserProfileResource.TEMP, null, UserProfileService.UserProfileSubResource.REPORTS, tempId = id.replace("_sessionReport", ""));
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new ReportNotFoundException(id);
        }
        return new TempReport(resp.getJSONObjectResponse());
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getRawSource(String id) {
        if (StringUtils.isEmpty((CharSequence)this.normalizedSpec) || ObjectUtils.compare((Comparable)((Object)id), (Comparable)((Object)this.lastId)) != 0) {
            this.normalizedSpec = this.isSessionReport(id) ? this.getNormalizedSpecTemp(id) : this.getNormalizedSpec(id);
            this.lastId = id;
        }
        return this.normalizedSpec;
    }

    private String getNormalizedSpec(String id) {
        ReportService reportService = this.requestEnv.getReportService();
        RESTClientResponse resp = reportService.normalizedSpec(id, this.spec);
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            throw new ReportNotFoundException(id);
        }
        return new String(resp.getRawResponse(), StandardCharsets.UTF_8);
    }

    private String getNormalizedSpecTemp(String id) {
        TempReport tempReport = this.getTempReport(id);
        this.etag = tempReport.getEtag();
        String ts = tempReport.getTimestamp();
        if (StringUtils.isNotEmpty((CharSequence)ts)) {
            this.lastModified = MoserUtil.getTimeInMillis(ts);
        }
        return tempReport.getSpecification();
    }

    @Override
    public Module translate(String id) {
        Report report = null;
        try {
            this.getRawSource(id);
            DocumentBuilder builder = FACTORY.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(this.normalizedSpec)));
            NodeList children = document.getElementsByTagName(REPORT);
            if (children.getLength() != 1) {
                throw new TranslationException();
            }
            Element child = (Element)children.item(0);
            report = new Report();
            report.visit(child);
            if (!ReportTranslator.emptyModule(report)) {
                return report;
            }
        }
        catch (MoserException e) {
            throw e;
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, e.getLocalizedMessage(), e);
            throw new TranslationException(e);
        }
        throw new ReportEmptyException(StringUtils.isNotEmpty((CharSequence)report.getLabel()) ? report.getLabel() : id);
    }

    private static boolean emptyModule(Module module) {
        return module.getQuerySubject().isEmpty() || module.getMetadataTreeView().isEmpty();
    }

    public int getVersion(String id) {
        ContentService contentService = this.requestEnv.getContentService();
        RESTClientResponse resp = MoserUtil.isStoreId(id) ? contentService.get(ContentService.ContentResource.OBJECTS, id, null, null, null, "version") : contentService.getBySearchPath(id, "version");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode() && resp.getResponseCode() != Response.Status.NOT_MODIFIED.getStatusCode()) {
            throw new ReportNotFoundException(id);
        }
        JSONObject jObj = resp.getJSONObjectResponse();
        if (jObj == null) {
            throw new ReportNotFoundException(id);
        }
        return ModuleObjectManagerCM.getVersion(jObj);
    }
}

