/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.translator.report;

import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.dom.DOMNodeHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TranslatorUtils {
    private static final NodeList EMPTY_NODE_LIST = new DOMNodeHelper.EmptyNodeList();

    private TranslatorUtils() {
    }

    public static NodeList getNodeList(Node node) {
        if (node == null) {
            return EMPTY_NODE_LIST;
        }
        NodeList children = node.getChildNodes();
        return children == null ? EMPTY_NODE_LIST : children;
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes == null ? null : TranslatorUtils.getNodeValue(attributes.getNamedItem(name));
    }

    public static String getValue(Node node) {
        NodeList children = TranslatorUtils.getNodeList(node);
        return children.getLength() > 0 ? TranslatorUtils.getNodeValue(children.item(0)) : null;
    }

    private static String getNodeValue(Node node) {
        return node == null ? null : node.getNodeValue();
    }

    public static String nameToBracketedIdentifierSimple(String name) {
        StringBuilder result = new StringBuilder("[");
        result.append(name);
        result.append("]");
        return result.toString();
    }

    public static String nameToBracketedIdentifier(String name) {
        return TranslatorUtils.nameToBracketedIdentifierSimple(name.replaceAll("]", "]]"));
    }

    public static UseSpecType getUseSpecType(String type) {
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            return UseSpecType.fromValue((String)type);
        }
        return UseSpecType.PACKAGE;
    }
}

