/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.translator.report.query;

import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.core.metadata.util.ReferenceResolver;
import com.ibm.bi.platform.moser.core.translator.report.IReportVisitor;
import com.ibm.bi.platform.moser.core.translator.report.TranslatorUtils;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataItem
extends QueryItem
implements IReportVisitor {
    private static final String AGGREGATE = "aggregate";
    private static final String DATA_ITEM = "dataItem";
    private static final String DATA_ITEM_MEASURE = "dataItemMeasure";
    private static final String DATA_ITEM_MEMBER_PROPERTY = "dataItemMemberProperty";
    private static final String EXPRESSION = "expression";
    private static final String LABEL = "label";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String XML_ATTRIBUTE = "XMLAttribute";
    private static final String RS_DATA_TYPE = "RS_dataType";
    private static final String RS_DATA_USAGE = "RS_dataUsage";
    private static final String DOT = ".";
    @XmlTransient
    private final Query parentQuery;
    @XmlTransient
    private String dataItemName = null;

    public DataItem(Query parentQuery) {
        this.parentQuery = parentQuery;
    }

    @Override
    public void visit(Element element) {
        this.dataItemName = TranslatorUtils.getAttribute(element, NAME);
        if (StringUtils.isEmpty((CharSequence)this.dataItemName)) {
            return;
        }
        String elementLabel = TranslatorUtils.getAttribute(element, LABEL);
        if (StringUtils.isEmpty((CharSequence)elementLabel)) {
            elementLabel = this.dataItemName;
        }
        this.setLabel(elementLabel);
        this.setIdentifier(TranslatorUtils.nameToBracketedIdentifierSimple(this.dataItemName));
        this.setUsageAndDataType(element);
        this.setSourceCategory(element);
        String aggregate = TranslatorUtils.getAttribute(element, AGGREGATE);
        if (StringUtils.isNotEmpty((CharSequence)aggregate)) {
            this.setRegularAggregate(RegularAggregateType.fromValue((String)aggregate));
        }
        this.setIdForExpression(this.generateIdForExpression());
        NodeList children = TranslatorUtils.getNodeList(element);
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!(c instanceof Element)) continue;
            this.visitChild((Element)c);
        }
        FacetType facet = new FacetType();
        this.setFacetDefinition(facet);
        facet.setEnabled(ReferenceResolver.resolveAutomatic(this));
    }

    private void setUsageAndDataType(Element element) {
        NodeList attributes = element.getElementsByTagName(XML_ATTRIBUTE);
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            Element at = (Element)attributes.item(i);
            String aName = at.getAttribute(NAME);
            String aValue = at.getAttribute(VALUE);
            switch (aName) {
                case "RS_dataType": {
                    this.setHighLevelDatatype(aValue);
                    continue block8;
                }
                case "RS_dataUsage": {
                    this.setUsage(aValue);
                    continue block8;
                }
            }
        }
    }

    private void setHighLevelDatatype(String aValue) {
        switch (aValue) {
            case "1": {
                this.setHighlevelDatatype(HighLevelDataType.INTEGER);
                break;
            }
            case "2": {
                this.setHighlevelDatatype(HighLevelDataType.DECIMAL);
                break;
            }
            case "3": {
                this.setHighlevelDatatype(HighLevelDataType.STRING);
                break;
            }
            case "4": {
                this.setHighlevelDatatype(HighLevelDataType.DATETIME);
                break;
            }
            case "5": {
                this.setHighlevelDatatype(HighLevelDataType.INTERVAL);
                break;
            }
            case "6": {
                this.setHighlevelDatatype(HighLevelDataType.STRING);
                break;
            }
            case "7": {
                this.setHighlevelDatatype(HighLevelDataType.DATE);
                break;
            }
            case "8": {
                this.setHighlevelDatatype(HighLevelDataType.TIME);
                break;
            }
            case "9": {
                this.setHighlevelDatatype(HighLevelDataType.DECIMAL);
                break;
            }
        }
    }

    private void setUsage(String aValue) {
        switch (aValue) {
            case "1": 
            case "identifier": {
                this.setUsage(UsageType.IDENTIFIER);
                break;
            }
            case "0": 
            case "attribute": {
                this.setUsage(UsageType.ATTRIBUTE);
                break;
            }
            case "2": 
            case "fact": {
                this.setUsage(UsageType.FACT);
                break;
            }
            default: {
                this.setUsage(UsageType.AUTOMATIC);
            }
        }
    }

    private void setSourceCategory(Element element) {
        switch (element.getNodeName()) {
            case "dataItem": {
                this.setSourceCategory(SourceCategoryType.CALCULATION);
                break;
            }
            case "dataItemMeasure": {
                this.setSourceCategory(SourceCategoryType.MEASURE);
                break;
            }
            case "dataItemMemberProperty": {
                this.setSourceCategory(SourceCategoryType.PROPERTY);
                break;
            }
        }
    }

    private String generateIdForExpression() {
        StringBuilder result = new StringBuilder(TranslatorUtils.nameToBracketedIdentifier(this.parentQuery.getLabel()));
        result.append(DOT);
        result.append(TranslatorUtils.nameToBracketedIdentifier(this.dataItemName));
        return result.toString();
    }

    private void visitChild(Element element) {
        if (EXPRESSION.equals(element.getNodeName())) {
            this.setExpression(TranslatorUtils.getNodeList(element).item(0).getNodeValue());
        }
    }
}

