/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.translator.report.query;

import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.core.translator.report.IReportVisitor;
import com.ibm.bi.platform.moser.core.translator.report.TranslatorUtils;
import com.ibm.bi.platform.moser.core.translator.report.query.DataItem;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Query
extends QuerySubject
implements IReportVisitor {
    private static final String DATA_ITEM = "dataItem";
    private static final String METADATA_PATH = "metadataPath";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String SELECTION = "selection";
    private static final String SOURCE = "source";
    @XmlTransient
    private boolean isFolder = true;
    @XmlTransient
    private Module.UseSpec useSpec = null;

    @Override
    public void visit(Element element) {
        String name = TranslatorUtils.getAttribute(element, NAME);
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        this.setLabel(name);
        this.setIdentifier(TranslatorUtils.nameToBracketedIdentifierSimple(name));
        NodeList children = TranslatorUtils.getNodeList(element);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.visitChild(child);
        }
        this.cleanupLabelAndId();
    }

    public Module.UseSpec getUseSpec() {
        return this.useSpec;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    private void visitChild(Node node) {
        String name = node.getNodeName();
        if (SOURCE.equals(name)) {
            this.visitSource(node);
        } else if (SELECTION.equals(name)) {
            this.visitSelection(node);
        }
    }

    private void visitSource(Node node) {
        NodeList children = TranslatorUtils.getNodeList(node);
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!(c instanceof Element)) continue;
            Element child = (Element)c;
            this.visitSourceChild(child);
        }
    }

    private void visitSourceChild(Element element) {
        if (!METADATA_PATH.equals(element.getNodeName())) {
            return;
        }
        String searchPath = element.getAttribute(PATH);
        if (StringUtils.isEmpty((CharSequence)searchPath)) {
            return;
        }
        this.useSpec = new Module.UseSpec();
        this.useSpec.setType(UseSpecType.PACKAGE);
        this.useSpec.setDataCacheExpiry("0");
        this.useSpec.setSearchPath(searchPath);
    }

    private void visitSelection(Node node) {
        NodeList children = TranslatorUtils.getNodeList(node);
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!(c instanceof Element)) continue;
            Element child = (Element)c;
            if (!DATA_ITEM.equals(child.getNodeName())) {
                this.isFolder = false;
                continue;
            }
            DataItem dataItem = new DataItem(this);
            dataItem.visit(child);
            if (Query.emptyQueryItem(dataItem)) continue;
            ItemType it = new ItemType();
            it.setQueryItem((QueryItem)dataItem);
            this.addItem(it);
            this.isFolder = false;
        }
    }

    private void cleanupLabelAndId() {
        if (!this.isFolder()) {
            return;
        }
        String name = this.getLabel();
        name = name.replaceFirst("^[\\W_]{3,}", "");
        name = name.replaceFirst("[\\W_]{3,}$", "");
        this.setLabel(name);
        String id = TranslatorUtils.nameToBracketedIdentifierSimple(name);
        this.setIdentifier(id);
    }

    private static boolean emptyQueryItem(QueryItem item) {
        return StringUtils.isEmpty((CharSequence)item.getIdentifier()) || StringUtils.isEmpty((CharSequence)item.getIdForExpression());
    }
}

