/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.utils.ModuleWashException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.utils.DuplicateRemover;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;

public class DashboardWash {
    private static final String WASH = "wash";
    private static final String DATA_SOURCES = "dataSources";
    private static final String VERSION = "version";
    private static final String SOURCES = "sources";
    private static final String ID = "id";
    private static final String SHAPING = "shaping";
    private static final String MOSER_JSON = "moserJSON";
    private static DashboardWash INSTANCE = new DashboardWash();

    public static void clean(JSONObject dashboardSpec) {
        INSTANCE.removeDuplicates(dashboardSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDuplicates(JSONObject dashboardSpec) {
        JSONObject dataSources = (JSONObject)dashboardSpec.get((Object)DATA_SOURCES);
        if (dataSources == null || !"1.0".equals(dataSources.get((Object)VERSION))) {
            throw new ModuleWashException(Response.Status.NOT_FOUND.getStatusCode());
        }
        JSONArray sources = (JSONArray)dataSources.get((Object)SOURCES);
        if (sources == null) {
            throw new ModuleWashException(Response.Status.NOT_FOUND.getStatusCode());
        }
        String resourcesLocation = MoserConfig.getInstance().getTempDirectory() + File.separator + WASH + File.separator;
        File folder = new File(resourcesLocation);
        try {
            String sourceID;
            JSONObject source;
            folder.mkdirs();
            for (Object aSource : sources) {
                source = (JSONObject)aSource;
                sourceID = (String)source.get((Object)ID);
                JSONObject shaping = (JSONObject)source.get((Object)SHAPING);
                JSONObject moserJSON = shaping == null ? null : (JSONObject)shaping.get((Object)MOSER_JSON);
                if (moserJSON == null) continue;
                File output = new File(folder, sourceID);
                try {
                    FileOutputStream fos = FileUtils.openOutputStream((File)output);
                    Throwable throwable = null;
                    try {
                        moserJSON.serialize((OutputStream)fos);
                        shaping.put((Object)MOSER_JSON, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (IOException e) {
                    LoggerAdapter.debug((Object)this, "Failed to serialize dashboard source " + sourceID + " during duplicate cleanup", e);
                }
            }
            for (Object aSource : sources) {
                source = (JSONObject)aSource;
                sourceID = (String)source.get((Object)ID);
                File output = new File(folder, sourceID);
                try {
                    FileInputStream fis = FileUtils.openInputStream((File)output);
                    Throwable throwable = null;
                    try {
                        JSONCodec codec = new JSONCodec();
                        Module module = (Module)codec.decode(Module.class, fis);
                        if (module == null) continue;
                        DuplicateRemover soap = new DuplicateRemover();
                        soap.cleanUp(module);
                        JSONObject moserJSON = module.toJSON();
                        JSONObject shaping = (JSONObject)source.get((Object)SHAPING);
                        shaping.put((Object)MOSER_JSON, (Object)moserJSON);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
                catch (IOException e) {
                    LoggerAdapter.debug((Object)this, "Failed to serialize dashboard source " + sourceID + " during duplicate cleanup", e);
                }
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException e) {
                LoggerAdapter.debug((Object)this, "Failed to delete temporary files in " + folder.getAbsolutePath(), e);
            }
        }
    }
}

