/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DuplicateRemover {
    public void cleanUp(Module module) {
        for (QuerySubject querySubject : module.getQuerySubject()) {
            DuplicateRemover.removeDuplicateFilters(querySubject);
            DuplicateRemover.removeDuplicateQueryItems(querySubject);
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static void removeDuplicateFilters(QuerySubject querySubject) {
        if (querySubject.getFilter().size() < 2) {
            return;
        }
        List distinctElements = querySubject.getFilter().stream().filter(DuplicateRemover.distinctByKey(p -> p.getIdentifier())).collect(Collectors.toList());
        querySubject.getFilter().clear();
        ((ArrayList)querySubject.getFilter()).trimToSize();
        querySubject.getFilter().addAll(distinctElements);
    }

    private static void removeDuplicatePropertyOverrides(QueryItem item) {
        if (item.getPropertyOverride().size() < 2) {
            return;
        }
        List distinctElements = item.getPropertyOverride().stream().distinct().collect(Collectors.toList());
        item.getPropertyOverride().clear();
        ((ArrayList)item.getPropertyOverride()).trimToSize();
        item.getPropertyOverride().addAll(distinctElements);
    }

    private static void removeDuplicateQueryItems(QuerySubject querySubject) {
        querySubject.getItem().stream().filter(a -> a.getQueryItem() != null).forEach(item -> DuplicateRemover.removeDuplicatePropertyOverrides(item.getQueryItem()));
    }
}

