/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.nio.charset.StandardCharsets;

public class EncryptedObject<T> {
    private byte[] mSecureData = null;

    public EncryptedObject() {
    }

    public EncryptedObject(T value) {
        this.set(value);
    }

    public void set(T value) {
        if (null == value) {
            this.mSecureData = null;
            return;
        }
        this.encryptString((String)value);
    }

    public T decrypt() {
        if (null == this.mSecureData) {
            return null;
        }
        return (T)this.decryptString();
    }

    public boolean hasValue() {
        return this.mSecureData != null;
    }

    private void encryptString(String value) {
        try {
            byte[] stringData = value.getBytes(StandardCharsets.UTF_8);
            this.mSecureData = JCAMCrypto.createEncryptingSession().encryptData(stringData);
        }
        catch (Exception ex) {
            LoggerAdapter.error(EncryptedObject.class, "Failed to ecrypt: " + ex.getMessage(), ex);
            throw new MoserException((Throwable)ex);
        }
    }

    private String decryptString() {
        try {
            byte[] stringData = JCAMCrypto.createEncryptingSession().decryptData(this.mSecureData);
            return new String(stringData, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            LoggerAdapter.error(EncryptedObject.class, "Failed to decrypt: " + ex.getMessage(), ex);
            throw new MoserException((Throwable)ex);
        }
    }
}

