/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerAdapter {
    private LoggerAdapter() {
    }

    private static Logger getLoggerInst(Object obj) {
        if (obj instanceof Class) {
            return LoggerFactory.getLogger((Class)((Class)obj));
        }
        return LoggerFactory.getLogger(obj.getClass());
    }

    private static boolean isErrorEnabled(Object obj) {
        return LoggerAdapter.getLoggerInst(obj).isErrorEnabled();
    }

    private static boolean isWarnEnabled(Object obj) {
        return LoggerAdapter.getLoggerInst(obj).isWarnEnabled();
    }

    public static boolean isInfoEnabled(Object obj) {
        return LoggerAdapter.getLoggerInst(obj).isInfoEnabled();
    }

    public static boolean isDebugEnabled(Object obj) {
        return LoggerAdapter.getLoggerInst(obj).isDebugEnabled();
    }

    public static boolean isTraceEnabled(Object obj) {
        return LoggerAdapter.getLoggerInst(obj).isTraceEnabled();
    }

    public static void error(Object obj, String msg) {
        if (LoggerAdapter.isErrorEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).error(msg);
        }
    }

    public static void error(Object obj, String format, Object ... argArray) {
        if (LoggerAdapter.isErrorEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).error(format, argArray);
        }
    }

    public static void error(Object obj, String msg, Throwable t) {
        if (LoggerAdapter.isErrorEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).error(msg, t);
        }
    }

    public static void warn(Object obj, String msg) {
        if (LoggerAdapter.isWarnEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).warn(msg);
        }
    }

    public static void warn(Object obj, String format, Object ... argArray) {
        if (LoggerAdapter.isWarnEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).warn(format, argArray);
        }
    }

    public static void warn(Object obj, String msg, Throwable t) {
        if (LoggerAdapter.isWarnEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).warn(msg, t);
        }
    }

    public static void trace(Object obj, String msg) {
        if (LoggerAdapter.isTraceEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).trace(msg);
        }
    }

    public static void trace(Object obj, String format, Object ... argArray) {
        if (LoggerAdapter.isTraceEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).trace(format, argArray);
        }
    }

    public static void trace(Object obj, String msg, Throwable t) {
        if (LoggerAdapter.isTraceEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).trace(msg, t);
        }
    }

    public static void debug(Object obj, String msg) {
        if (LoggerAdapter.isDebugEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).debug(msg);
        }
    }

    public static void debug(Object obj, String format, Object ... argArray) {
        if (LoggerAdapter.isDebugEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).debug(format, argArray);
        }
    }

    public static void errorExceptionStack(Object obj, Throwable t) {
        if (LoggerAdapter.isErrorEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).error(t.getLocalizedMessage(), t);
        }
    }

    public static void debug(Object obj, String msg, Throwable t) {
        if (LoggerAdapter.isDebugEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).debug(msg, t);
        }
    }

    public static void info(Object obj, String msg) {
        if (LoggerAdapter.isInfoEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).info(msg);
        }
    }

    public static void info(Object obj, String format, Object ... argArray) {
        if (LoggerAdapter.isInfoEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).info(format, argArray);
        }
    }

    public static void info(Object obj, String msg, Throwable t) {
        if (LoggerAdapter.isInfoEnabled(obj)) {
            LoggerAdapter.getLoggerInst(obj).info(msg, t);
        }
    }
}

