/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.MemberType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.core.metadata.util.ResolverUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleIdentifiersConverter {
    public static final String IDENTIFIER = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String DOT = "\\.";
    static final Pattern SHORT_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z_0-9]*(\\.[A-Za-z_][A-Za-z_0-9]*)?$");
    static final Pattern LONG_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z_0-9]*(\\.[A-Za-z_][A-Za-z_0-9]*){2,3}$");
    static final Pattern PCKG_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z_0-9]*(\\.\\[.+]){2,}$");
    static final Pattern BRACK_PATTERN = Pattern.compile("^\\[.+](\\.\\[.+]){2,}$");
    static final Pattern SHORT_BRACK_PATTERN = Pattern.compile("^\\[[A-Za-z_][A-Za-z_0-9]*](\\.\\[[A-Za-z_][A-Za-z_0-9]*])?$");
    static final Pattern PACKAGE_USE_PATTERN = Pattern.compile(".*/package\\[@name=.*");

    public static boolean matchShort(String in) {
        Matcher m = SHORT_PATTERN.matcher(in);
        return m.find();
    }

    public static boolean matchLong(String in) {
        Matcher m = LONG_PATTERN.matcher(in);
        return m.find();
    }

    public static boolean matchPackage(String in) {
        Matcher m = PCKG_PATTERN.matcher(in);
        return m.find();
    }

    public static boolean matchBracket(String in) {
        Matcher m = BRACK_PATTERN.matcher(in);
        return m.find();
    }

    public static boolean matchShortBracket(String in) {
        Matcher m = SHORT_BRACK_PATTERN.matcher(in);
        return m.find();
    }

    public static boolean isBracketed(String in) {
        return in.startsWith(LEFT_BRACKET);
    }

    public static boolean isPackage(String in) {
        return in.contains(LEFT_BRACKET) && !ModuleIdentifiersConverter.isBracketed(in);
    }

    public static IdentifierType getType(String in, String container, String moduleId) {
        if (ModuleIdentifiersConverter.isBracketed(in)) {
            String[] parts = in.split(DOT);
            if (ModuleIdentifiersConverter.matchShortBracket(in)) {
                return IdentifierType.SHORT_BRACKETS;
            }
            if (container != null && parts[0].equals(ModuleIdentifiersConverter.applyBrackets(container)) && moduleId != null && parts[1].equals(ModuleIdentifiersConverter.applyBrackets(moduleId))) {
                return IdentifierType.LONG_BRACKETS;
            }
            return IdentifierType.PACKAGE_BRACKETS;
        }
        if (ModuleIdentifiersConverter.matchShort(in)) {
            return IdentifierType.SHORT;
        }
        if (ModuleIdentifiersConverter.matchLong(in)) {
            return IdentifierType.LONG;
        }
        if (ModuleIdentifiersConverter.matchPackage(in)) {
            return IdentifierType.PACKAGE;
        }
        return IdentifierType.UNKNOWN;
    }

    public static String convert(IdentifierType out, String in, String container, String moduleId) {
        IdentifierType inType = ModuleIdentifiersConverter.getType(in, container, moduleId);
        if (inType.equals((Object)IdentifierType.UNKNOWN)) {
            return null;
        }
        if (inType.equals((Object)out)) {
            return out.equals((Object)IdentifierType.PACKAGE) || out.equals((Object)IdentifierType.PACKAGE_BRACKETS) ? null : in;
        }
        switch (inType) {
            case SHORT: {
                return ModuleIdentifiersConverter.convertShort(out, in, container, moduleId);
            }
            case LONG: {
                return ModuleIdentifiersConverter.convertLong(out, in);
            }
            case PACKAGE: {
                return ModuleIdentifiersConverter.convertPackage(out, in);
            }
            case SHORT_BRACKETS: {
                return ModuleIdentifiersConverter.convertShortBrackets(out, in, container, moduleId);
            }
            case LONG_BRACKETS: {
                return ModuleIdentifiersConverter.convertLongBrackets(out, in);
            }
            case PACKAGE_BRACKETS: {
                return ModuleIdentifiersConverter.convertPackageBrackets(out, in);
            }
        }
        return null;
    }

    private static String convertPackageBrackets(IdentifierType out, String in) {
        switch (out) {
            case SHORT: 
            case LONG: {
                String[] parts = in.split(DOT);
                parts[0] = ModuleIdentifiersConverter.removeBrackets(parts[0]);
                return String.join((CharSequence)".", Arrays.asList(parts));
            }
            case SHORT_BRACKETS: 
            case LONG_BRACKETS: {
                return in;
            }
        }
        return null;
    }

    private static String convertLongBrackets(IdentifierType out, String in) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] parts = in.split(DOT);
        switch (out) {
            case SHORT: {
                for (int i = 2; i < parts.length; ++i) {
                    ret.add(ModuleIdentifiersConverter.removeBrackets(parts[i]));
                }
                return String.join((CharSequence)".", ret);
            }
            case SHORT_BRACKETS: {
                for (int i = 2; i < parts.length; ++i) {
                    ret.add(parts[i]);
                }
                return String.join((CharSequence)".", ret);
            }
            case LONG: {
                Arrays.stream(parts).forEach(e -> ret.add(ModuleIdentifiersConverter.removeBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
        }
        return null;
    }

    private static String convertShortBrackets(IdentifierType out, String in, String container, String moduleId) {
        ArrayList<String> ret = new ArrayList<String>();
        switch (out) {
            case LONG: {
                ret.add(container);
                ret.add(moduleId);
                Arrays.stream(in.split(DOT)).forEach(e -> ret.add(ModuleIdentifiersConverter.removeBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
            case SHORT: {
                Arrays.stream(in.split(DOT)).forEach(e -> ret.add(ModuleIdentifiersConverter.removeBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
            case LONG_BRACKETS: {
                ret.add(ModuleIdentifiersConverter.applyBrackets(container));
                ret.add(ModuleIdentifiersConverter.applyBrackets(moduleId));
                ret.add(in);
                return String.join((CharSequence)".", ret);
            }
        }
        return null;
    }

    private static String removeBrackets(String e) {
        if (e.lastIndexOf(RIGHT_BRACKET) == e.length() - 1) {
            if (e.startsWith(LEFT_BRACKET)) {
                return e.substring(1, e.length() - 1);
            }
            return e.substring(0, e.length() - 1);
        }
        if (e.startsWith(LEFT_BRACKET)) {
            return e.substring(1, e.length());
        }
        return e;
    }

    private static String convertPackage(IdentifierType out, String in) {
        switch (out) {
            case SHORT: 
            case LONG: {
                return in;
            }
            case SHORT_BRACKETS: 
            case LONG_BRACKETS: {
                String[] parts = in.split(DOT);
                parts[0] = ModuleIdentifiersConverter.applyBrackets(parts[0]);
                return String.join((CharSequence)".", Arrays.asList(parts));
            }
        }
        return null;
    }

    private static String convertLong(IdentifierType out, String in) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] parts = in.split(DOT);
        switch (out) {
            case SHORT: {
                for (int i = 2; i < parts.length; ++i) {
                    ret.add(parts[i]);
                }
                return String.join((CharSequence)".", ret);
            }
            case SHORT_BRACKETS: {
                for (int i = 2; i < parts.length; ++i) {
                    ret.add(ModuleIdentifiersConverter.applyBrackets(parts[i]));
                }
                return String.join((CharSequence)".", ret);
            }
            case LONG_BRACKETS: {
                Arrays.stream(parts).forEach(e -> ret.add(ModuleIdentifiersConverter.applyBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
        }
        return null;
    }

    private static String convertShort(IdentifierType out, String in, String container, String moduleId) {
        ArrayList<String> ret = new ArrayList<String>();
        switch (out) {
            case LONG: {
                return String.format("%s.%s.%s", container, moduleId, in);
            }
            case LONG_BRACKETS: {
                ret.add(ModuleIdentifiersConverter.applyBrackets(container));
                ret.add(ModuleIdentifiersConverter.applyBrackets(moduleId));
                Arrays.stream(in.split(DOT)).forEach(e -> ret.add(ModuleIdentifiersConverter.applyBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
            case SHORT_BRACKETS: {
                Arrays.stream(in.split(DOT)).forEach(e -> ret.add(ModuleIdentifiersConverter.applyBrackets(e)));
                return String.join((CharSequence)".", ret);
            }
        }
        return null;
    }

    private static String applyBrackets(String part) {
        return LEFT_BRACKET + part + RIGHT_BRACKET;
    }

    public static boolean isPackageBaseModule(Module module) {
        return module.basicGetUse() != null && !module.basicGetUse().isEmpty() && PACKAGE_USE_PATTERN.matcher((CharSequence)module.basicGetUse().get(0)).find();
    }

    public static JSONObject convert(String format, Module module, String idArray) {
        IdentifierType out = IdentifierType.fromString(format);
        if (IdentifierType.UNKNOWN.equals((Object)out)) {
            return null;
        }
        List<String> ids = ModuleIdentifiersConverter.parseIdentifiers(idArray);
        HashMap moduleObjects = new HashMap();
        List<String> valid = ModuleIdentifiersConverter.selectModuleIdentifiers(module);
        String notMapped = "";
        if (ModuleIdentifiersConverter.isPackageBaseModule(module)) {
            ids.forEach(e -> moduleObjects.put(e, valid.contains(e) ? e : notMapped));
        } else if (ModuleIdentifiersConverter.isLwOlapModule(module)) {
            String aliasPrefix = ((Module.UseSpec)module.getUseSpec().get(0)).getIdentifier() + ".";
            int prefixLength = aliasPrefix.length();
            boolean bShort = out.equals((Object)IdentifierType.SHORT) || out.equals((Object)IdentifierType.SHORT_BRACKETS);
            ids.forEach(e -> {
                if (valid.contains(e)) {
                    moduleObjects.put(e, bShort ? e : e.substring(prefixLength));
                } else {
                    String moduleId = aliasPrefix + e;
                    if (valid.contains(moduleId)) {
                        moduleObjects.put(e, bShort ? moduleId : e);
                    } else {
                        moduleObjects.put(e, notMapped);
                    }
                }
            });
        } else {
            String container = module.getContainer();
            String moduleId = module.getIdentifier();
            ids.forEach(e -> {
                String longId = ModuleIdentifiersConverter.convert(IdentifierType.LONG, e, container, moduleId);
                if (longId == null || !valid.contains(longId)) {
                    moduleObjects.put(e, notMapped);
                } else {
                    String current = ModuleIdentifiersConverter.convert(out, e, container, moduleId);
                    moduleObjects.put(e, current != null ? current : notMapped);
                }
            });
        }
        JSONObject ret = new JSONObject();
        ret.putAll(moduleObjects);
        return ret;
    }

    private static boolean isLwOlapModule(Module module) {
        return module.basicGetUseSpec() != null && module.basicGetUseSpec().size() == 1 && ((Module.UseSpec)module.getUseSpec().get(0)).getType() == UseSpecType.LW_OLAP;
    }

    private static List<String> parseIdentifiers(String idArray) {
        String[] idsEncoded = idArray.split(",");
        ArrayList<String> ids = new ArrayList<String>();
        Arrays.stream(idsEncoded).forEach(e -> {
            String s = new String(Base64.getDecoder().decode((String)e), StandardCharsets.UTF_8);
            try {
                ids.add(URLDecoder.decode(s, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                LoggerAdapter.errorExceptionStack(ModuleIdentifiersConverter.class, e1);
                ids.add(s);
            }
        });
        return ids;
    }

    private static List<String> selectModuleIdentifiers(Module module) {
        ArrayList<String> valid = new ArrayList<String>();
        module.getCalculation().forEach(e -> valid.add(e.getIdForExpression()));
        module.getQuerySubject().forEach(qs -> qs.getItem().forEach(item -> ModuleIdentifiersConverter.selectItemIdForExpression(ResolverUtil.getObject(item), valid)));
        return valid;
    }

    private static void selectItemIdForExpression(ObjectType item, List<String> valid) {
        if (item == null) {
            return;
        }
        String expId = item.getIdForExpression();
        if (expId != null) {
            if (valid.contains(expId)) {
                return;
            }
            valid.add(expId);
        }
        if (item instanceof ItemHierarchy) {
            ((ItemHierarchy)item).getCalculatedMember().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression((ObjectType)itm, valid));
        } else if (item instanceof MemberType) {
            ((MemberType)item).getMembers().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression((ObjectType)itm, valid));
        } else if (item instanceof QueryItem) {
            ((QueryItem)item).getCalculatedMember().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression((ObjectType)itm, valid));
            ((QueryItem)item).getMembers().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression((ObjectType)itm, valid));
        }
        if (item instanceof BaseQueryItemType) {
            ((BaseQueryItemType)item).getItem().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression(ResolverUtil.getObject(itm), valid));
        }
        if (item instanceof ItemType.Folder) {
            ((ItemType.Folder)item).getItem().forEach(itm -> ModuleIdentifiersConverter.selectItemIdForExpression(ResolverUtil.getObject(itm), valid));
        }
    }

    public static enum IdentifierType {
        SHORT("short"),
        LONG("long"),
        SHORT_BRACKETS("shortBracketed"),
        LONG_BRACKETS("longBracketed"),
        PACKAGE(null),
        PACKAGE_BRACKETS(null),
        UNKNOWN(null);

        private final String format;

        private IdentifierType(String val) {
            this.format = val;
        }

        public String getFormat() {
            return this.format;
        }

        public static IdentifierType fromString(String in) {
            if (in != null) {
                for (IdentifierType current : IdentifierType.values()) {
                    if (!in.equals(current.format)) continue;
                    return current;
                }
            }
            return UNKNOWN;
        }
    }
}

