/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.common.generated.info.ActionType;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.info.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.info.State;
import com.ibm.bi.platform.moser.common.generated.info.StateType;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class MoserInfoUtil {
    private static final ObjectFactory factory = new ObjectFactory();

    private MoserInfoUtil() {
    }

    public static MoserInfo createMoserInfo(String hRef, String id, StateType state, String label, XMLGregorianCalendar lastModified) {
        return MoserInfoUtil.createMoserInfo(hRef, id, state, label, lastModified, null, null, null, id);
    }

    public static MoserInfo createMoserInfo(String hRef, String id, StateType state, String label, XMLGregorianCalendar lastModified, String startTime, String endTime) {
        return MoserInfoUtil.createMoserInfo(hRef, id, state, label, lastModified, null, startTime, endTime, id);
    }

    public static MoserInfo createMoserInfo(String hRef, String id, StateType state, String label, XMLGregorianCalendar lastModified, String model, String startTime, String endTime) {
        return MoserInfoUtil.createMoserInfo(hRef, id, state, label, lastModified, model, startTime, endTime, id);
    }

    public static MoserInfo createMoserInfo(String startTime, String endTime, String ... ids) {
        return MoserInfoUtil.createMoserInfo(null, null, null, null, null, null, startTime, endTime, ids);
    }

    public static MoserInfo createMoserInfo(String hRef, String id, StateType state, String label, XMLGregorianCalendar lastModified, String model, String startTime, String endTime, String ... ids) {
        MoserInfo info = factory.createMoserInfo();
        info.setHref(hRef);
        info.setId(ids == null ? id : ids[0]);
        info.setState(MoserInfoUtil.getStateFromStateType(state));
        info.setLabel(label);
        info.setLastModified(lastModified == null ? null : lastModified.toString());
        info.setModel(model);
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        if (ids != null) {
            info.getIds().addAll(Arrays.asList(ids));
        }
        return info;
    }

    private static State getStateFromString(String stringState) {
        StateType stateType = null;
        try {
            if (stringState != null) {
                stateType = StateType.valueOf((String)stringState);
            }
        }
        catch (IllegalArgumentException iae) {
            LoggerAdapter.errorExceptionStack(MoserInfoUtil.class, iae);
            stateType = null;
        }
        return MoserInfoUtil.getStateFromStateType(stateType);
    }

    private static State getStateFromStateType(StateType stateType) {
        State state = null;
        if (stateType != null) {
            state = new State();
            state.setType(stateType);
            List actions = state.getActions();
            switch (stateType) {
                case NOTLOADED: {
                    actions.add(ActionType.LOAD);
                    break;
                }
                case PENDING: {
                    actions.add(ActionType.CANCEL);
                    break;
                }
                case LOADING: {
                    actions.add(ActionType.CANCEL);
                    break;
                }
                case LOADED: {
                    actions.add(ActionType.REFRESH);
                    actions.add(ActionType.CLEAR);
                    break;
                }
                case ERROR: {
                    actions.add(ActionType.LOAD);
                    actions.add(ActionType.CLEAR);
                    break;
                }
                default: {
                    actions.add(ActionType.LOAD);
                }
            }
        }
        return state;
    }

    public static MoserInfo createMoserInfo(JSONObject jsonObject) {
        MoserInfo info = factory.createMoserInfo();
        info.setHref((String)jsonObject.get((Object)"href"));
        info.setId((String)jsonObject.get((Object)"id"));
        info.setState(MoserInfoUtil.getStateFromString((String)jsonObject.get((Object)"state")));
        info.setLabel((String)jsonObject.get((Object)"label"));
        info.setLastModified((String)jsonObject.get((Object)"lastModified"));
        info.setModel((String)jsonObject.get((Object)"model"));
        info.setStartTime((String)jsonObject.get((Object)"startTime"));
        info.setEndTime((String)jsonObject.get((Object)"endTime"));
        return info;
    }

    public static MoserInfo updateMoserInfoState(MoserInfo info, StateType stateType) {
        XMLGregorianCalendar lastModified = null;
        if (info.getLastModified() != null) {
            lastModified = MoserUtil.getTimeGregorian(info.getLastModified());
        }
        return MoserInfoUtil.createMoserInfo(info.getHref(), info.getId(), stateType, info.getLabel(), lastModified, info.getModel(), info.getStartTime(), info.getEndTime());
    }
}

