/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.common.utils.ResponseUtils;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.ma.MoserPassThroughXQEException;
import com.ibm.bi.platform.moser.core.metadata.util.ICodec;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.metadata.util.XMLCodec;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.migration.MigrationManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.xml.XMLToJSONTransformer;
import com.ibm.neo.dataimport.api.WAImportException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class MoserUtil {
    public static final String TO_CM = "toCM";
    public static final String TO_FILE = "toFile";
    public static final Pattern STOREID_PATTERN = Pattern.compile("i[A-F0-9]{32}");
    public static final Pattern CMNEXT_STOREID_PATTERN = Pattern.compile("^(?=.*\\.)[a-zA-Z0-9\\.-]+$");
    public static final Pattern OBJECT_TYPE_PATTERN = Pattern.compile("(.*)(/\\w*\\[@name=)(.*)$");
    public static final Pattern WHITESPACE = Pattern.compile("\\s+");
    public static final String MY_FOLDERS = ".my_folders";
    public static final String PUBLIC_FOLDERS = ".public_folders";
    public static final String ETAG_TYPE_MODIFICATIONTIME = "modificationTime";
    public static final String DOUBLEQUOTE = "\"";
    public static final String BLANK = "";
    public static final String UNDERSCORE = "_";
    public static final String DOT = ".";
    public static final String OPEN_SQBRACKET = "[";
    public static final String CLOSE_SQBRACKET = "]";
    public static final String MODIFICATION_TIME = "modificationTime";
    public static final String APPLICATION_PARQUET = "application/vnd.ibm.bi.pq";
    private static final Pattern XSD_DATE_TIME_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[^.]+([.][0-9]{3}|)(Z|[+-][0-9]{2}:[0-9]{2})");
    private static final Pattern useSpecIdPattern = Pattern.compile("M[0-9]+\\.");
    private static DatatypeFactory datatypeFactory = null;
    private static Map<String, List<String>> mimeTypesAndExtsMap;
    private static HashSet<String> supportedFileExtensions;

    private MoserUtil() {
    }

    public static String stripInvalidFilenameCharacters(String filename) {
        if (filename != null) {
            return filename.replaceAll("[\\\\/:\"*?<>|\\s]", UNDERSCORE);
        }
        return null;
    }

    public static String stripInvalidFilenameCharactersIncludingDot(String fileName) {
        String localFileName = fileName;
        if (localFileName != null) {
            for (int i = 0; i < localFileName.length(); ++i) {
                if (!Character.isLetterOrDigit(localFileName.charAt(i))) continue;
                if (i <= 0) break;
                localFileName = localFileName.substring(i);
                break;
            }
            IntStream characters = localFileName.codePoints();
            PrimitiveIterator.OfInt it = characters.iterator();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                int c = it.nextInt();
                if (!Character.isLetterOrDigit(c) && c != 95) {
                    sb.append('_');
                    continue;
                }
                sb.appendCodePoint(c);
            }
            return sb.toString();
        }
        return null;
    }

    public static String stripCharactersForR7Uploads(String identifier) {
        String localFileName = identifier;
        if (localFileName != null) {
            for (int i = 0; i < localFileName.length(); ++i) {
                if (!Character.isLetter(localFileName.charAt(i))) continue;
                if (i <= 0) break;
                localFileName = localFileName.substring(i);
                break;
            }
            IntStream characters = localFileName.codePoints();
            PrimitiveIterator.OfInt it = characters.iterator();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                int c = it.nextInt();
                if (!Character.isLetterOrDigit(c) && c != 95) {
                    sb.append('_');
                    continue;
                }
                sb.appendCodePoint(c);
            }
            return sb.toString();
        }
        return null;
    }

    public static XMLGregorianCalendar getCurrentTimeGregorian() {
        return MoserUtil.getTimeGregorian(System.currentTimeMillis());
    }

    public static XMLGregorianCalendar getCurrentTimeGregorianUTC() {
        return MoserUtil.getTimeGregorianUTC(System.currentTimeMillis());
    }

    public static XMLGregorianCalendar getTimeGregorian(long ms) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(ms);
        return datatypeFactory.newXMLGregorianCalendar(date);
    }

    public static XMLGregorianCalendar getTimeGregorianUTC(long ms) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeZone(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(ms);
        XMLGregorianCalendar time = datatypeFactory.newXMLGregorianCalendar(date);
        time.setTimezone(0);
        return time;
    }

    public static XMLGregorianCalendar getTimeGregorian(String xsdDateTime) {
        if (xsdDateTime == null || xsdDateTime.isEmpty() || !XSD_DATE_TIME_PATTERN.matcher(xsdDateTime).matches()) {
            return null;
        }
        return datatypeFactory.newXMLGregorianCalendar(xsdDateTime);
    }

    public static String formatDate(XMLGregorianCalendar calendar, Locale locale) {
        return MoserUtil.formatDate(calendar, 3, locale);
    }

    private static String formatDate(XMLGregorianCalendar calendar, int style, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(style, locale);
        df.setTimeZone(calendar.getTimeZone(calendar.getTimezone()));
        return df.format(calendar.toGregorianCalendar().getTime());
    }

    public static String formatDateTime(XMLGregorianCalendar calendar, Locale locale) {
        return MoserUtil.formatDateTime(calendar, 3, locale);
    }

    private static String formatDateTime(XMLGregorianCalendar calendar, int style, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(style, style, locale);
        df.setTimeZone(calendar.getTimeZone(calendar.getTimezone()));
        return df.format(calendar.toGregorianCalendar().getTime());
    }

    public static long getLastModifiedFromCS(JSONArray ja) {
        if (ja == null || ja.isEmpty()) {
            return 0L;
        }
        Object o = ja.get(0);
        if (!(o instanceof JSONObject)) {
            return 0L;
        }
        return MoserUtil.getLastModifiedFromCS((JSONObject)o);
    }

    public static long getLastModifiedFromCS(JSONObject jo) {
        if (jo == null || jo.isEmpty()) {
            return 0L;
        }
        return MoserUtil.getTimeInMillis((String)jo.get((Object)"modificationTime"));
    }

    public static long getTimeInMillis(String xsdDateTime) {
        XMLGregorianCalendar cal = MoserUtil.getTimeGregorian(xsdDateTime);
        if (cal == null) {
            return 0L;
        }
        return cal.toGregorianCalendar().getTimeInMillis();
    }

    protected static Response getPassThroughResponse(Throwable e) {
        if (!(e instanceof MoserPassThroughXQEException)) {
            return null;
        }
        MoserPassThroughXQEException pe = (MoserPassThroughXQEException)((Object)e);
        return pe.getResponse(null);
    }

    public static Response getResponse(Response.Status status, Message message, Locale locale, Throwable e) {
        Response r = MoserUtil.getPassThroughResponse(e);
        if (r != null) {
            return r;
        }
        String msg = message.getLocalizedMessage(locale);
        JSONObject response = MoserUtil.buildExceptionResponse(msg, e, locale);
        return MoserUtil.getResponse(status, (Object)response);
    }

    public static Response getResponseXML(Response.Status status, Message message, Locale locale, Throwable e) {
        Response r = MoserUtil.getPassThroughResponse(e);
        if (r != null) {
            return r;
        }
        String msg = message.getLocalizedMessage(locale);
        Document response = MoserUtil.buildExceptionResponseXML(msg, e);
        return MoserUtil.getResponseXML(status, response);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param0 key, Locale locale, Throwable e) {
        Response r = MoserUtil.getPassThroughResponse(e);
        if (r != null) {
            return r;
        }
        String msg = MoserMessages.getMessage((IMessageKey.Param0)key, (Locale)locale);
        JSONObject response = MoserUtil.buildExceptionResponse(msg, e, locale);
        return MoserUtil.getResponse(status, (Object)response);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param1 key, Locale locale, String param1, Throwable e) {
        Response r = MoserUtil.getPassThroughResponse(e);
        if (r != null) {
            return r;
        }
        String msg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)locale, (String)param1);
        JSONObject response = MoserUtil.buildExceptionResponse(msg, e, locale);
        return Response.fromResponse((Response)MoserUtil.getResponse(status, (Object)response)).type("application/json").build();
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param2 key, Locale locale, String param1, String param2, Throwable e) {
        Response r = MoserUtil.getPassThroughResponse(e);
        if (r != null) {
            return r;
        }
        String msg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)locale, (String)param1, (String)param2);
        JSONObject response = MoserUtil.buildExceptionResponse(msg, e, locale);
        return MoserUtil.getResponse(status, (Object)response);
    }

    public static Response buildTasksResponse(String taskID) {
        JSONObject json = new JSONObject();
        json.put((Object)"taskID", (Object)taskID);
        json.put((Object)"href", (Object)("/tasks/" + taskID));
        return MoserUtil.getResponse(Response.Status.ACCEPTED, (Object)json);
    }

    public static Response getResponse(Response.Status status) {
        return MoserUtil.getResponse(status, null);
    }

    public static Response getResponse(Response.Status status, Object entity) {
        return ResponseUtils.getResponse((Response.Status)status, (Object)entity);
    }

    public static Response getResponse(Response.Status status, Object entity, MediaType type, String eTag, long lastModified) {
        return ResponseUtils.getResponse((Response.Status)status, (Object)entity, (MediaType)type, (String)eTag, (long)lastModified);
    }

    public static Response getResponse(int status, Object entity) {
        if (entity == null) {
            return Response.status((int)status).build();
        }
        return Response.status((int)status).entity(entity).build();
    }

    public static Response getResponseXML(Response.Status status, Object entity) {
        if (entity == null) {
            return Response.status((Response.Status)status).type("text/xml").build();
        }
        return Response.status((Response.Status)status).type("text/xml").entity(entity).build();
    }

    private static JSONObject buildExceptionResponse(String msg, Throwable e, Locale locale) {
        JSONObject response = new JSONObject();
        response.put((Object)"msg", (Object)msg);
        if (e != null) {
            response.put((Object)"exceptionMsg", (Object)MoserUtil.getLocalizedMessage(e, locale));
            Throwable t = e.getCause();
            if (t != null) {
                response.put((Object)"exceptionCauseMsg", (Object)MoserUtil.getLocalizedMessage(t, locale));
            }
        }
        return response;
    }

    private static String getLocalizedMessage(Throwable e, Locale locale) {
        if (e instanceof WAImportException) {
            return ((WAImportException)e).getLocalizedMessage(locale);
        }
        if (e instanceof CommonsRuntimeException) {
            return ((CommonsRuntimeException)e).getLocalizedMessage(locale);
        }
        return e.getLocalizedMessage();
    }

    private static Document buildExceptionResponseXML(String msg, Throwable e) {
        Document dom = MoserUtil.createXML();
        Element msgElm = dom.createElement("message");
        dom.getDocumentElement().appendChild(msgElm);
        Text text = dom.createTextNode(msg);
        msgElm.appendChild(text);
        if (e != null) {
            Element exceptionMsgElm = dom.createElement("exceptionMsg");
            dom.getDocumentElement().appendChild(exceptionMsgElm);
            Text exceptionText = dom.createTextNode(e.getLocalizedMessage());
            exceptionMsgElm.appendChild(exceptionText);
            Throwable t = e.getCause();
            if (t != null) {
                Element exceptionCauseMsgElm = dom.createElement("exceptionCauseMsg");
                dom.getDocumentElement().appendChild(exceptionCauseMsgElm);
                Text exceptionCauseMsg = dom.createTextNode(t.getLocalizedMessage());
                exceptionCauseMsgElm.appendChild(exceptionCauseMsg);
            }
        }
        return dom;
    }

    public static Document createXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MoserException((Throwable)e);
        }
        Document doc = builder.newDocument();
        Element element = doc.createElement("ResponseRoot");
        doc.appendChild(element);
        return doc;
    }

    public static boolean isStoreId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return false;
        }
        return STOREID_PATTERN.matcher(id).matches() || MY_FOLDERS.equals(id) || CMNEXT_STOREID_PATTERN.matcher(id).matches();
    }

    public static String getObjectType(String searchPath) {
        if (StringUtils.isEmpty((CharSequence)searchPath) || MoserUtil.isStoreId(searchPath)) {
            return null;
        }
        Matcher matcher = OBJECT_TYPE_PATTERN.matcher(searchPath);
        if (matcher.matches()) {
            String objectType = matcher.group(2);
            return objectType.substring(1, objectType.length() - 7);
        }
        return null;
    }

    public static String stripToStoreID(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return id;
        }
        String cleanId = id.replace("datasets.", BLANK);
        cleanId = cleanId.replace("datasets:", BLANK);
        cleanId = cleanId.replace(".basemodule", BLANK);
        if ((cleanId = cleanId.replace(".physicalmodule", BLANK)).startsWith("storeID(\"") && cleanId.endsWith("\")")) {
            cleanId = cleanId.substring(9, cleanId.length() - 2);
        }
        return cleanId;
    }

    public static String makeRelativePath(String root, String path) {
        String r = root.replaceAll("\\\\", "/");
        String p = path.replaceAll("\\\\", "/");
        int index = p.indexOf(r);
        if (index < 0) {
            return p;
        }
        return p.substring(index + r.length());
    }

    public static void checkNameForCM(Module module) {
        String label = module.getLabel();
        module.setLabel(MoserUtil.checkNameForCM(label));
    }

    public static String checkNameForCM(String label1) {
        String sanitizedLabel = label1;
        if ((sanitizedLabel = WHITESPACE.matcher(sanitizedLabel).replaceAll(" ")).contains("'") && sanitizedLabel.contains(DOUBLEQUOTE)) {
            throw new MoserException(MoserError.INVALID_CHARS_IN_NAME);
        }
        if ("~~".equals(sanitizedLabel) || "~".equals(sanitizedLabel)) {
            throw new MoserException(MoserError.INVALID_NAME, sanitizedLabel);
        }
        return sanitizedLabel;
    }

    /*
     * Exception decompiling
     */
    public static String encode(Object module, boolean zipped) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object decode(Class<?> c, String moduleContent) {
        if (moduleContent == null) {
            return null;
        }
        ICodec codec = new JSONCodec();
        Object module = MoserUtil.decode(c, moduleContent, codec);
        if (module == null) {
            codec = new XMLCodec();
            module = MoserUtil.decode(c, moduleContent, codec);
        }
        return module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object decode(Class<?> c, String moduleContent, ICodec codec) {
        try (InputStream is = MoserUtil.getCompressedInputStream(moduleContent);){
            Object module;
            Object object = module = is != null ? codec.decode(c, is) : codec.decode(c, moduleContent);
            if (module instanceof Module) {
                if (MigrationManager.manager().migrate((Module)module)) {
                    Object object2 = module;
                    return object2;
                }
                Object var6_9 = null;
                return var6_9;
            }
            Object object3 = module;
            return object3;
        }
        catch (Exception e) {
            LoggerAdapter.trace(MoserUtil.class, e.getLocalizedMessage(), e);
            return null;
        }
    }

    private static byte[] getDecodedBytes(String content) {
        return Base64.isBase64((String)content) ? Base64.decodeBase64((String)content) : null;
    }

    private static InputStream createCompressedInputStream(byte[] decodedBase64) {
        if (decodedBase64 == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(decodedBase64);
            return new GZIPInputStream(bis);
        }
        catch (IOException e) {
            LoggerAdapter.trace(MoserUtil.class, e.getLocalizedMessage(), e);
            ByteArrayInputStream bis = new ByteArrayInputStream(decodedBase64);
            ZipInputStream zis = new ZipInputStream(bis);
            try {
                ZipEntry ze = zis.getNextEntry();
                if (ze == null) {
                    zis.close();
                    return null;
                }
                return zis;
            }
            catch (IOException e2) {
                LoggerAdapter.trace(MoserUtil.class, e2.getLocalizedMessage(), e2);
                try {
                    zis.close();
                }
                catch (IOException e1) {
                    LoggerAdapter.trace(MoserUtil.class, e1.getLocalizedMessage(), e1);
                }
                return null;
            }
        }
    }

    private static InputStream getCompressedInputStream(String content) {
        byte[] decodedBase64 = MoserUtil.getDecodedBytes(content);
        return MoserUtil.createCompressedInputStream(decodedBase64);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unzipString(String xmlZipped) {
        try (InputStream is = MoserUtil.getCompressedInputStream(xmlZipped);){
            if (is == null) {
                String string2 = null;
                return string2;
            }
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LoggerAdapter.trace(MoserUtil.class, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File tmpDir = new File(MoserConfig.getInstance().getTempDirectory());
        FileUtils.forceMkdir((File)tmpDir);
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File tmpDir = new File(MoserConfig.getInstance().getTempDirectory());
        FileUtils.forceMkdir((File)tmpDir);
        return Files.createTempDirectory(tmpDir.toPath(), prefix, new FileAttribute[0]).toFile();
    }

    public static File createTempUploadDirectory(String prefix) throws IOException {
        File tmpDir = new File(MoserConfig.getInstance().getTempUploadDirectory());
        FileUtils.forceMkdir((File)tmpDir);
        return Files.createTempDirectory(tmpDir.toPath(), prefix, new FileAttribute[0]).toFile();
    }

    public static File createTempUploadDirectory(String prefix, String suffix) throws IOException {
        File tmpDir = new File(MoserConfig.getInstance().getTempUploadDirectory());
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    public static boolean isProperty(org.dom4j.Element obj) {
        Attribute attr = obj.attribute("isProperty");
        return attr != null && !"0".equals(attr.getValue());
    }

    public static BufferedReader getBufferedFileReader(File f) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
    }

    public static String repairQuerySubjectReference(String ref) {
        if (ref == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(ref.length());
        int start = 0;
        boolean found = false;
        Matcher m = useSpecIdPattern.matcher(ref);
        if (m.find()) {
            if (m.start() != 0) {
                return ref;
            }
            while (m.find()) {
                found = true;
                int end = m.end() - 1;
                sb.append(ref.substring(start, end));
                sb.append(UNDERSCORE);
                start = end + 1;
            }
        }
        if (!found) {
            return ref;
        }
        sb.append(ref.substring(start));
        return sb.toString();
    }

    public static String buildSchemaDefaultName(String database, String catalog, String schema) {
        String sch;
        StringBuilder defaultName = new StringBuilder();
        String cat = "null".equals(catalog) ? null : catalog;
        String string = sch = "null".equals(schema) ? null : schema;
        if (StringUtils.isNotEmpty((CharSequence)cat)) {
            defaultName.append(cat);
        }
        if (StringUtils.isNotEmpty((CharSequence)sch)) {
            if (defaultName.length() != 0) {
                defaultName.append("/");
            }
            defaultName.append(sch);
        }
        if (defaultName.length() == 0) {
            return database;
        }
        return defaultName.toString();
    }

    public static String convertXMLToJSON(String xml, Charset encoding) throws SAXException, IOException {
        try (InputStream is = IOUtils.toInputStream((String)xml, (Charset)encoding);){
            String string = XMLToJSONTransformer.transform((InputStream)is);
            return string;
        }
    }

    public static JSONObject convertXMLToJSONObject(String xml, Charset encoding) throws SAXException, IOException {
        String json = MoserUtil.convertXMLToJSON(xml, encoding);
        return JSONObject.parse((String)json);
    }

    public static JSONObject convertCmdBlockToJSONObject(String cmdblock) {
        String xml = cmdblock.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        try {
            return MoserUtil.convertXMLToJSONObject(xml, StandardCharsets.UTF_8);
        }
        catch (IOException | SAXException e) {
            LoggerAdapter.error(MoserUtil.class, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static List<File> listAllFiles(File source) {
        if (source == null || !source.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        if (source.isDirectory()) {
            File[] files = source.listFiles();
            if (files != null) {
                for (File f : files) {
                    result.addAll(MoserUtil.listAllFiles(f));
                }
            }
        } else {
            result.add(source);
        }
        return result;
    }

    public static String getCMType(UseSpecType uType) {
        if (uType == null) {
            return null;
        }
        switch (uType) {
            case FILE: {
                return "uploadedFile";
            }
            case DATASET: {
                return "dataSet2";
            }
        }
        return uType.value();
    }

    public static boolean isBaseModule(UseSpecType type) {
        return type != UseSpecType.MODULE;
    }

    public static int getPollingTime(int loopCount, int pollingAcceleration, int pollingInitialSpeed, int pollingMinTime, int pollingMaxTime) {
        int time = (int)(0.5 * (double)pollingAcceleration * (double)loopCount * (double)loopCount + (double)(pollingInitialSpeed * loopCount) + (double)pollingMinTime);
        if (time < pollingMaxTime && time > 0) {
            return time;
        }
        return pollingMaxTime;
    }

    public static JSONObject toJSON(Object obj) {
        JSONCodec codec = new JSONCodec();
        String encoded = codec.encode(obj);
        JSONObject json = null;
        try {
            json = JSONObject.parse((String)encoded);
        }
        catch (IOException e) {
            LoggerAdapter.trace(MoserUtil.class, e.getLocalizedMessage(), e);
        }
        return json;
    }

    public static Response getResponse(Response.Status status, Message message, Locale productLocale) {
        return MoserUtil.getResponse(status, message, productLocale, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param2 msgParm2, Locale productLocale, String id, String value) {
        return MoserUtil.getResponse(status, msgParm2, productLocale, id, value, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param1 msgParm1, Locale productLocale, String parm1) {
        return MoserUtil.getResponse(status, msgParm1, productLocale, parm1, null);
    }

    public static Response getResponse(Response.Status status, IMessageKey.Param0 msgParm0, Locale productLocale) {
        return MoserUtil.getResponse(status, msgParm0, productLocale, null);
    }

    public static <S, T> List<S> downcast(List<T> theList, Class<T> fromType, Class<S> toType) {
        if (!fromType.isAssignableFrom(toType)) {
            throw new ClassCastException();
        }
        return theList;
    }

    public static <T> List<T> upcast(List<? extends T> theList, Class<T> theType) {
        return theList;
    }

    public static void resolveModule(Module module) {
        ReferenceResolver.resolve((Module)module);
        MoserUtil.setItemParents(module);
    }

    public static String trimDoubleQuotes(String etag) {
        return etag.replaceAll(DOUBLEQUOTE, BLANK);
    }

    private static void setItemParents(Module module) {
        for (QuerySubject qs : module.getQuerySubject()) {
            for (ItemType item : qs.getItem()) {
                item.setParent((MoserObject)qs);
                MoserUtil.setParentItemChildren(item);
            }
        }
    }

    private static void setParentItemChildren(ItemType parent) {
        List itemList = null;
        if (parent.getQueryItem() != null) {
            parent.getQueryItem().setParent((MoserObject)parent);
            itemList = parent.getQueryItem().basicGetItem();
        } else if (parent.getNamedSet() != null) {
            parent.getNamedSet().setParent((MoserObject)parent);
            itemList = parent.getNamedSet().basicGetItem();
        } else if (parent.getFolder() != null) {
            parent.getFolder().setParent((MoserObject)parent);
            itemList = parent.getFolder().basicGetItem();
        }
        if (itemList != null) {
            for (ItemType item : itemList) {
                item.setParent((MoserObject)parent);
                MoserUtil.setParentItemChildren(item);
            }
        }
    }

    public static boolean isSupportedFileExtension(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isBlank((CharSequence)extension)) {
            return true;
        }
        return supportedFileExtensions.contains(extension);
    }

    public static boolean isSupportedMimeTypeAndFileExt(String fileName, String mimeType) {
        String extension = FilenameUtils.getExtension((String)fileName);
        List<String> extensionsForType = mimeTypesAndExtsMap.get(mimeType);
        if (extensionsForType == null) {
            return false;
        }
        if (extensionsForType.isEmpty()) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)extension)) {
            return true;
        }
        return extensionsForType.contains(extension);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LoggerAdapter.trace(DatatypeFactory.class, e.getLocalizedMessage(), e);
        }
        mimeTypesAndExtsMap = new HashMap<String, List<String>>();
        Set<String> mimeTypes = MoserConfig.getSupportedMimeTypes();
        for (String mimeType : mimeTypes) {
            mimeTypesAndExtsMap.put(mimeType, Arrays.asList(new String[0]));
        }
        mimeTypesAndExtsMap.put("application/vnd.ms-excel", Arrays.asList("xls", "xlm"));
        mimeTypesAndExtsMap.put("application/vnd.ms-excel+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", Arrays.asList("xlsx"));
        mimeTypesAndExtsMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("application/vnd.ms-excel.sheet.macroenabled.12", Arrays.asList("xlsm"));
        mimeTypesAndExtsMap.put("application/vnd.ms-excel.sheet.macroenabled.12+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("application/csv", Arrays.asList("csv"));
        mimeTypesAndExtsMap.put("application/csv+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("text/csv", Arrays.asList("csv"));
        mimeTypesAndExtsMap.put("text/csv+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("text/tab-separated-values", Arrays.asList("tab", "tsv", "txt"));
        mimeTypesAndExtsMap.put("text/tab-separated-values+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("text/plain", Arrays.asList("txt", "tab", "tsv", "ipynb", "csv", "xls", "xlm", "xlsx", "xlsm", "gz", "zip"));
        mimeTypesAndExtsMap.put("text/plain+gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("application/gzip", Arrays.asList("gz"));
        mimeTypesAndExtsMap.put("application/zip", Arrays.asList("zip"));
        mimeTypesAndExtsMap.put("application/zip+gzip", Arrays.asList("zip", "gz"));
        supportedFileExtensions = new HashSet();
        Collection<List<String>> fileExtensions = mimeTypesAndExtsMap.values();
        for (List<String> exts : fileExtensions) {
            supportedFileExtensions.addAll(exts);
        }
    }
}

