/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.common.generated.version.MoserVersion;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MoserVersionUtil {
    private MoserVersionUtil() {
    }

    public static MoserVersion getMoserVersion(Class<?>[] classes) {
        MoserVersion version = new MoserVersion();
        List components = version.getComponent();
        for (Class<?> c : classes) {
            components.add(MoserVersionUtil.getComponentVersion(c));
        }
        return version;
    }

    private static MoserVersion.Component getComponentVersion(Class<?> c) {
        String classSimpleName = c.getSimpleName();
        String classFileName = classSimpleName + ".class";
        String classFilePath = c.getResource(classFileName).toString();
        MoserVersion.Component component = new MoserVersion.Component();
        String manifestStr = "Unable to read manifest for class: " + c.getName();
        int bangSeparatorIndex = classFilePath.indexOf("!");
        if (bangSeparatorIndex == -1) {
            component.getVersion().add(manifestStr);
            return component;
        }
        String manifestFilePath = classFilePath.substring(0, bangSeparatorIndex + 1);
        manifestFilePath = manifestFilePath + "/META-INF/MANIFEST.MF";
        try {
            URL manifestFileURL = new URL(manifestFilePath);
            manifestStr = "Class: " + c.getName() + "\r\n";
            manifestStr = manifestStr + IOUtils.toString((InputStream)manifestFileURL.openStream());
        }
        catch (Exception e) {
            LoggerAdapter.info(MoserVersionUtil.class, e.getLocalizedMessage(), e);
        }
        component.getVersion().addAll(Arrays.asList(manifestStr.split("\r\n")));
        return component;
    }
}

