/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.core.cm.SearchService;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.soap.services.CamException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ParquetUtils {
    public static final String MODULE_ID = "ModuleId";
    public static final String ASSET_ID = "AssetId";
    public static final String SOURCE_TYPE = "sourceType";
    private static final String MODIFICATION_TIME = "modificationTime";
    private static final String STORE_ID_END = "')";
    private static final String STORE_ID = "storeID('";
    private static final String OLDVERSION = "oldversion";
    private static final String TASKID = "taskid";
    private static final String UPGRADE = "upgrade";
    public static final Pattern PATTERN = Pattern.compile("NAME");
    private static final String[] PARQUET_FIELDS = new String[]{"searchPath", "modificationTime", "dataDescriptor", "dataSize", "storeID", "permissions"};
    private static final List<String> PARQUET_FIELDS_LIST = Arrays.asList(PARQUET_FIELDS);
    private static final String[] PARQUET_IDS = new String[]{"storeID", "dataSize", "dataDescriptor", "permissions"};
    private static final String[] STORE_IDS = new String[]{"storeID"};
    private static final List<String> STORE_IDS_LIST = Arrays.asList(STORE_IDS);
    private static final List<String> PARQUET_IDS_LIST = Arrays.asList(PARQUET_IDS);
    private static final String CM_SEARCH_BASEMODULE = "NAME//reportVersion[last()]/baseModule";
    private static final String CM_SEARCH_OUTPUT = "NAME//reportVersion[last()]/output";
    private static final String CM_SEARCH_DATASET = "NAME//dataSet2";
    private static final String CM_SEARCH_UPLOADEDFILE = "NAME//uploadedFile";
    private static final String PARQUET_VERSION = "version";

    ParquetUtils() {
    }

    private static List<JSONObject> getListOfOutputStoreIds(ModuleStorageCM moduleStorageCM, String searchPath, String sourceType) throws CamException {
        String searchParameter = searchPath == null ? "" : searchPath;
        List<JSONObject> storeIds = null;
        if (sourceType != null) {
            switch (sourceType) {
                case "files": {
                    storeIds = ParquetUtils.getCMObjectViaSoapBridge(moduleStorageCM, PATTERN.matcher(CM_SEARCH_UPLOADEDFILE).replaceAll(searchParameter), STORE_IDS_LIST, sourceType);
                    break;
                }
                case "datasets": {
                    storeIds = ParquetUtils.getCMObjectViaSoapBridge(moduleStorageCM, PATTERN.matcher(CM_SEARCH_DATASET).replaceAll(searchParameter), STORE_IDS_LIST, sourceType);
                    break;
                }
            }
        } else {
            storeIds = ParquetUtils.getCMObjectViaSoapBridge(moduleStorageCM, PATTERN.matcher(CM_SEARCH_UPLOADEDFILE).replaceAll(searchParameter), STORE_IDS_LIST, "files");
            storeIds.addAll(ParquetUtils.getCMObjectViaSoapBridge(moduleStorageCM, PATTERN.matcher(CM_SEARCH_DATASET).replaceAll(searchParameter), STORE_IDS_LIST, "datasets"));
        }
        return storeIds;
    }

    private static List<JSONObject> getObjects(ModuleStorageCM moduleStorageCM, String cmSearch, List<String> propertyList, String storeID) throws CamException {
        return moduleStorageCM.getCMObjectViaSoapBridge(PATTERN.matcher(cmSearch).replaceAll(STORE_ID + storeID + STORE_ID_END), propertyList, null);
    }

    public static List<JSONObject> getCMObjectViaSoapBridge(ModuleStorageCM moduleStorageCM, String searchPath, List<String> properties, String sourceType) throws CamException {
        List<JSONObject> sourceList = moduleStorageCM.getCMObjectViaSoapBridge(searchPath, properties, null);
        if (sourceList != null && sourceType != null) {
            for (JSONObject current : sourceList) {
                current.put((Object)SOURCE_TYPE, (Object)sourceType);
            }
        }
        return sourceList;
    }

    public static JSONObject getParquetInfo(RequestEnvironment runtime, String id) {
        ModuleStorageCM moduleStorageCM = runtime.getModuleStorageCM();
        return ParquetUtils.getParquetInfo(moduleStorageCM.getObjectFromCM(id, PARQUET_FIELDS));
    }

    private static List<JSONObject> addTaskIdToOutput(String taskid, List<JSONObject> outputObjects) {
        ArrayList<JSONObject> retlist = new ArrayList<JSONObject>();
        for (JSONObject current : outputObjects) {
            JSONObject upgrade;
            Object task;
            JSONObject dataDescriptor = (JSONObject)current.get((Object)"dataDescriptor");
            if (!dataDescriptor.containsKey((Object)UPGRADE) || (task = (upgrade = (JSONObject)dataDescriptor.get((Object)UPGRADE)).get((Object)TASKID)) == null || !taskid.equals(task)) continue;
            retlist.add(current);
        }
        return retlist;
    }

    public static List<JSONObject> getListOfParquetFiles(RequestEnvironment runtime, String searchPath, String sourceType, String taskid) throws CamException {
        ModuleStorageCM moduleStorageCM = runtime.getModuleStorageCM();
        List<JSONObject> outputObjects = ParquetUtils.getListOfParquetFilesIds(moduleStorageCM, searchPath, PARQUET_FIELDS_LIST, sourceType);
        if (taskid != null && !taskid.isEmpty()) {
            return ParquetUtils.addTaskIdToOutput(taskid, outputObjects);
        }
        return outputObjects;
    }

    public static List<JSONObject> getListOfFilesToUpgrade(ModuleStorageCM moduleStorageCM, String searchPath, String sourceType) throws CamException {
        return ParquetUtils.getListOfParquetFilesIds(moduleStorageCM, searchPath, PARQUET_IDS_LIST, sourceType);
    }

    public static List<JSONObject> getListOfParquetFilesIds(ModuleStorageCM moduleStorageCM, String searchPath, List<String> fieldsList, String sourceType) throws CamException {
        List<JSONObject> storeIds = ParquetUtils.getListOfOutputStoreIds(moduleStorageCM, searchPath, sourceType);
        ArrayList<JSONObject> outputObjects = new ArrayList<JSONObject>();
        Iterator<JSONObject> iterator = storeIds.iterator();
        while (iterator.hasNext()) {
            JSONObject c;
            JSONObject current = c = iterator.next();
            String storeID = "";
            try {
                storeID = (String)current.get((Object)"id");
                List<JSONObject> objects = ParquetUtils.getObjects(moduleStorageCM, CM_SEARCH_OUTPUT, fieldsList, storeID);
                JSONObject output = objects.get(0);
                if (output != null) {
                    Object typeOfUpload;
                    objects = ParquetUtils.getObjects(moduleStorageCM, CM_SEARCH_BASEMODULE, STORE_IDS_LIST, storeID);
                    JSONObject jsonObject = objects.get(0);
                    if (jsonObject != null) {
                        output.put((Object)ASSET_ID, (Object)storeID);
                        output.put((Object)MODULE_ID, jsonObject.get((Object)"id"));
                    }
                    if ((typeOfUpload = current.get((Object)SOURCE_TYPE)) != null) {
                        output.put((Object)SOURCE_TYPE, typeOfUpload);
                    }
                }
                outputObjects.add(output);
            }
            catch (Exception e) {
                LoggerAdapter.info(ParquetUtils.class, "Object with " + storeID + " can not be retrived, cause : " + e.getLocalizedMessage());
            }
        }
        return outputObjects;
    }

    public static JSONObject createOutputContainerJSON(JSONObject output, String version, String taskid) {
        JSONObject datasetContainer = new JSONObject();
        datasetContainer.put((Object)"type", output.get((Object)"type"));
        datasetContainer.put((Object)"format", output.get((Object)"format"));
        datasetContainer.put((Object)"defaultName", output.get((Object)"defaultName"));
        JSONObject datasetDescriptor = (JSONObject)output.get((Object)"dataDescriptor");
        JSONObject upgrade = new JSONObject();
        upgrade.put((Object)TASKID, (Object)taskid);
        upgrade.put((Object)PARQUET_VERSION, datasetDescriptor.get((Object)PARQUET_VERSION));
        datasetDescriptor.put((Object)UPGRADE, (Object)upgrade);
        datasetDescriptor.remove((Object)PARQUET_VERSION);
        datasetDescriptor.put((Object)PARQUET_VERSION, (Object)version);
        datasetContainer.put((Object)"dataDescriptor", (Object)datasetDescriptor);
        return datasetContainer;
    }

    public static boolean containsVersion(String version) {
        for (ParquetVersionEnum c : ParquetVersionEnum.values()) {
            if (!c.name().equals(version)) continue;
            return true;
        }
        return false;
    }

    public static JSONObject getParquetInfo(JSONObject current) {
        Object dataSize;
        JSONObject result = new JSONObject();
        Object seacrhPath = current.get((Object)"searchPath");
        if (seacrhPath != null) {
            result.put((Object)"searchPath", seacrhPath);
        }
        result.put((Object)"storeID", current.get((Object)"id"));
        Object time = current.get((Object)MODIFICATION_TIME);
        if (time != null) {
            result.put((Object)MODIFICATION_TIME, time);
        }
        if ((dataSize = current.get((Object)"dataSize")) != null) {
            result.put((Object)"dataSize", dataSize);
        }
        result.put((Object)"permissions", (Object)ParquetUtils.getPermission(current));
        JSONObject dataDescriptor = (JSONObject)current.get((Object)"dataDescriptor");
        if (dataDescriptor != null) {
            Object upgrade;
            Object v = dataDescriptor.get((Object)PARQUET_VERSION);
            if (v != null) {
                Object version;
                if (v instanceof Long) {
                    version = (Long)v;
                    result.put((Object)PARQUET_VERSION, version);
                } else {
                    version = (String)v;
                    result.put((Object)PARQUET_VERSION, version);
                }
            }
            if ((upgrade = dataDescriptor.get((Object)UPGRADE)) != null) {
                JSONObject upgradeJson = (JSONObject)upgrade;
                result.put((Object)OLDVERSION, upgradeJson.get((Object)PARQUET_VERSION));
            }
        } else {
            result.put((Object)PARQUET_VERSION, (Object)"");
            result.put((Object)OLDVERSION, (Object)"");
        }
        return result;
    }

    public static JSONObject getParquetInfo(ModuleStorageCM moduleStorageCM, String storeId) {
        return ParquetUtils.getParquetInfo(moduleStorageCM.getObjectFromCM(storeId, PARQUET_FIELDS));
    }

    public static boolean isUpgradable(String version, JSONObject parquetInfo) {
        if (version == null || version.isEmpty()) {
            return true;
        }
        Object v = parquetInfo.get((Object)PARQUET_VERSION);
        boolean b = false;
        if (v != null) {
            if (v instanceof Long) {
                return true;
            }
            String existingVersion = (String)v;
            b = !version.equals(existingVersion);
        }
        return b;
    }

    public static boolean getPermission(JSONObject parquetInfo) {
        Object v = parquetInfo.get((Object)"permissions");
        if (v == null) {
            return false;
        }
        if (v instanceof JSONArray) {
            JSONArray permissions = (JSONArray)v;
            for (Object p : permissions) {
                String permission = (String)p;
                if (!permission.equals("write")) continue;
                return true;
            }
        } else if (v instanceof Boolean) {
            Boolean writePermition = (Boolean)v;
            return writePermition;
        }
        return false;
    }

    private static Map<String, String> getOutputObjectsList(RequestEnvironment runtime, String query) {
        SearchService ss = runtime.getSearchService();
        ss.setFields("id", MODIFICATION_TIME);
        ss.setFilter("type", "output");
        if (query != null && !query.isEmpty()) {
            ss.setQuery(query);
        }
        ss.httpGet();
        JSONArray outputs = ss.getResults();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(Collections.reverseOrder());
        if (outputs != null) {
            for (Object c : outputs) {
                JSONObject current = (JSONObject)c;
                sortedMap.put((String)current.get((Object)MODIFICATION_TIME), (String)current.get((Object)"id"));
            }
        }
        return sortedMap;
    }

    public static List<JSONObject> getParquetLastUsed(RequestEnvironment runtime, String search, Integer lastNumberUswd, String version) {
        ArrayList<JSONObject> info = new ArrayList<JSONObject>();
        Map<String, String> msp = ParquetUtils.getOutputObjectsList(runtime, search);
        int totalCount = lastNumberUswd;
        for (Map.Entry<String, String> data : msp.entrySet()) {
            JSONObject parquetInfo;
            if (totalCount-- <= 0) break;
            String id = data.getValue();
            if (!MoserUtil.isStoreId(id) || !ParquetUtils.isUpgradable(version, parquetInfo = ParquetUtils.getParquetInfo(runtime, id))) continue;
            info.add(parquetInfo);
        }
        return info;
    }
}

