/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

public class RequestCacheManager {
    private static final long THOUSAND = 1000L;
    private static ConcurrentHashMap<String, Date> requestCache = new ConcurrentHashMap();

    private RequestCacheManager() {
    }

    public static Response buildCacheResponse(Request request, String ... keyParts) {
        String key = RequestCacheManager.buildKey(keyParts);
        if (key.isEmpty()) {
            return null;
        }
        Date timestamp = requestCache.get(key);
        if (timestamp == null) {
            return null;
        }
        Response.ResponseBuilder builder = request.evaluatePreconditions(timestamp);
        if (builder != null) {
            return builder.build();
        }
        return null;
    }

    private static String buildKey(String ... keyParts) {
        StringBuilder key = new StringBuilder();
        if (keyParts != null) {
            for (String part : keyParts) {
                if (part == null || part.isEmpty()) continue;
                if (key.length() != 0) {
                    key.append('#');
                }
                key.append(part);
            }
        }
        return key.toString();
    }

    public static Response buildFromResponse(Object entity, RESTClientResponse resp) {
        Response.ResponseBuilder builder = Response.ok((Object)entity, (String)"application/json");
        String etag = resp.getResponseHeader("ETag");
        Date lastModified = new Date(0L);
        String lm = resp.getResponseHeader("Last-Modified");
        if (lm != null && !lm.isEmpty()) {
            try {
                lastModified = DateUtil.parseDate((String)lm);
            }
            catch (DateParseException e) {
                LoggerAdapter.errorExceptionStack(RequestCacheManager.class, e);
            }
        }
        CacheControl cc = new CacheControl();
        cc.setMustRevalidate(true);
        cc.setPrivate(true);
        builder = builder.lastModified(lastModified).cacheControl(cc);
        if (etag != null) {
            builder = builder.tag(etag);
        }
        return builder.build();
    }

    public static Response decorateResponse(Object responseObj, Date timestamp) {
        Response.ResponseBuilder builder;
        if (responseObj instanceof Response) {
            Response response = (Response)responseObj;
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
            builder = Response.fromResponse((Response)response);
        } else {
            builder = Response.ok((Object)responseObj, (String)"application/json");
        }
        if (timestamp != null) {
            CacheControl cc = new CacheControl();
            cc.setMustRevalidate(true);
            cc.setPrivate(true);
            builder = builder.lastModified(timestamp).cacheControl(cc);
        }
        return builder.build();
    }

    public static Date registerResponseTimestamp(String ... keyParts) {
        Date timestamp = null;
        String key = RequestCacheManager.buildKey(keyParts);
        if (!key.isEmpty()) {
            timestamp = RequestCacheManager.getTimestamp();
            requestCache.putIfAbsent(key, timestamp);
            timestamp = requestCache.get(key);
        }
        return timestamp;
    }

    private static Date getTimestamp() {
        long currentTimestamp = Math.round((double)System.currentTimeMillis() / 1000.0) * 1000L;
        return new Date(currentTimestamp);
    }

    public static void deleteEntry(String ... keyParts) {
        String keyPrefix = RequestCacheManager.buildKey(keyParts);
        if (keyPrefix.isEmpty()) {
            return;
        }
        Iterator iter = ((ConcurrentHashMap.KeySetView)requestCache.keySet()).iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(keyPrefix)) continue;
            iter.remove();
        }
    }
}

