/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class BaseMigrator
extends ModuleMigrator {
    private static final String LOW_VERSION = "1.0";
    private static final String HIGH_VERSION = "3.0";

    public BaseMigrator(ModuleMigrator successor) {
        super(successor, LOW_VERSION, HIGH_VERSION);
    }

    @Override
    protected boolean upversion(Module module) {
        this.cleanMetadataProperties(module);
        this.repairQuerySubjectReferences(module);
        this.repairMDTV(module);
        return true;
    }

    protected void repairMDTV(Module module) {
        List calculations;
        List filters;
        List mdtv = module.basicGetMetadataTreeView();
        if (mdtv == null || mdtv.isEmpty()) {
            return;
        }
        FolderType folder = (FolderType)mdtv.get(0);
        List items = folder.getFolderItem();
        if (items.isEmpty()) {
            return;
        }
        LinkedHashMap<String, Integer> refMap = new LinkedHashMap<String, Integer>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            FolderItemType item = (FolderItemType)items.get(i);
            String ref = item.getRef();
            if (ref == null) continue;
            refMap.put(ref, i);
        }
        ObjectFactory factory = new ObjectFactory();
        List querySubjects = module.basicGetQuerySubject();
        if (querySubjects != null) {
            for (QuerySubject qs : querySubjects) {
                String identifier = qs.getIdentifier();
                Integer index = (Integer)refMap.get(identifier);
                if (index != null) continue;
                FolderItemType fi = factory.createFolderItemType();
                fi.setRef(identifier);
                items.add(fi);
            }
        }
        if ((filters = module.basicGetFilter()) != null) {
            for (Filter filter : filters) {
                String identifier = filter.getIdentifier();
                Integer index = (Integer)refMap.get(identifier);
                if (index != null) continue;
                FolderItemType fi = factory.createFolderItemType();
                fi.setRef(identifier);
                items.add(fi);
            }
        }
        if ((calculations = module.basicGetCalculation()) != null) {
            for (Calculation calculation : calculations) {
                String identifier = calculation.getIdentifier();
                Integer index = (Integer)refMap.get(identifier);
                if (index != null) continue;
                FolderItemType fi = factory.createFolderItemType();
                fi.setRef(identifier);
                items.add(fi);
            }
        }
    }

    protected void repairQuerySubjectReferences(Module module) {
        if (module.basicGetUseSpec() == null) {
            return;
        }
        HashSet<String> moduleSources = new HashSet<String>();
        for (Module.UseSpec us : module.getUseSpec()) {
            if (!UseSpecType.MODULE.equals((Object)us.getType())) continue;
            moduleSources.add(us.getIdentifier());
        }
        if (moduleSources.isEmpty()) {
            return;
        }
        if (module.basicGetQuerySubject() == null) {
            return;
        }
        for (QuerySubject qs : module.getQuerySubject()) {
            for (int i = 0; i < qs.getRef().size(); ++i) {
                String ref;
                String refString = (String)qs.getRef().get(i);
                int idx = refString.indexOf(".");
                if (idx < 0 || !moduleSources.contains(ref = refString.substring(0, idx))) continue;
                qs.getRef().set(i, MoserUtil.repairQuerySubjectReference(refString));
            }
        }
    }

    protected void cleanMetadataProperties(Module module) {
        if (module.basicGetQuerySubject() != null) {
            for (QuerySubject qs : module.getQuerySubject()) {
                qs.getQueryItem().stream().forEach(qi -> {
                    qi.setIdForExpression(null);
                    qi.setHighlevelDatatype(null);
                    qi.setDatatypeCategory(null);
                });
            }
        }
        if (module.basicGetCalculation() == null) {
            return;
        }
        module.getCalculation().stream().forEach(cl -> {
            cl.setIdForExpression(null);
            cl.setHighlevelDatatype(null);
            cl.setDatatypeCategory(null);
        });
    }
}

