/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.core.utils.migration.BaseMigrator;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion10_1;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion3_3;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion3_6;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion5_0;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion5_0_1;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion7_1;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorVersion8_2;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator9_0;

public class MigrationManager {
    private ModuleMigrator migrator;
    private static final MigrationManager MANAGER = new MigrationManager();

    private MigrationManager() {
        this(new BaseMigrator(new MigratorVersion3_3(new MigratorVersion3_6(new MigratorVersion5_0(new MigratorVersion5_0_1(new MigratorVersion7_1(new MigratorVersion8_2(new ModuleMigrator9_0(new MigratorVersion10_1(null))))))))));
    }

    public MigrationManager(ModuleMigrator base) {
        this.migrator = base;
    }

    public static MigrationManager manager() {
        return MANAGER;
    }

    public Object versionCheck(Object object) {
        if (object instanceof Module) {
            Module module = (Module)object;
            if ("11.1".equals(module.getVersion())) {
                return module;
            }
            this.migrate(module);
        }
        return object;
    }

    public final boolean migrate(Module module) {
        boolean successful;
        if (module == null) {
            return false;
        }
        String ver = module.getVersion();
        if (ver != null && !ver.isEmpty()) {
            try {
                module.setOriginalVersion(Float.parseFloat(ver));
            }
            catch (NumberFormatException ex) {
                String[] verNumbers = ver.split("\\.");
                if (verNumbers.length > 2) {
                    float v = Float.parseFloat(verNumbers[0] + "." + verNumbers[1]);
                    module.setOriginalVersion(v);
                }
                throw ex;
            }
        }
        if (successful = this.migrator.migrate(module)) {
            module.setVersion("11.1");
        }
        return successful;
    }
}

