/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.FeatureObject;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import com.ibm.json.java.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class MigratorPropSetByUser
extends ModuleMigrator {
    private static JSONObject allRemaps = null;
    protected JSONObject remaps;

    public MigratorPropSetByUser(ModuleMigrator successor, String startingVersion, String targetVersion) {
        super(successor, startingVersion, targetVersion);
        this.remaps = this.getRemaps(targetVersion);
    }

    protected synchronized JSONObject getRemaps(String targetVersion) {
        if (allRemaps == null) {
            block29: {
                String path = MoserConfig.getInstance().getMoserConfigDirectory() + File.separator + "remaps_propertySetByUser.json";
                File file = new File(path);
                if (file.exists()) {
                    try (FileInputStream is = new FileInputStream(file);
                         BufferedInputStream bis = new BufferedInputStream(is);){
                        allRemaps = JSONObject.parse((InputStream)bis);
                        break block29;
                    }
                    catch (IOException e) {
                        LoggerAdapter.error((Object)this, "Failed to read and parse: " + file.getAbsolutePath(), e);
                        throw new MoserException((Throwable)e);
                    }
                }
                LoggerAdapter.error(this, "Failed to read configuration file: " + file.getAbsolutePath());
                throw new MoserException(MoserError.GENERAL_ERROR, "Failed to read configuration file: " + file.getAbsolutePath());
            }
            if (allRemaps == null) {
                allRemaps = new JSONObject();
            }
        }
        return (JSONObject)allRemaps.get((Object)targetVersion);
    }

    @Override
    protected boolean upversion(Module module) {
        if (this.remaps != null) {
            this.remapPropertySetByUser((MoserObject)module);
        }
        return true;
    }

    private void remapPropertySetByUser(MoserObject o) {
        for (FeatureObject feature : o.getFeatureList(null)) {
            String featureName = feature.getFeatureName();
            Object obj = o.basicGet(feature.getFeatureID());
            if (obj == null) continue;
            if ("property".equals(featureName)) {
                this.remapProperty((List)obj);
                continue;
            }
            if ("propertyOverride".equals(featureName)) {
                this.remapPropertyOverride((List)obj);
                continue;
            }
            if (feature.getIsList()) {
                for (Object otherObj : (List)obj) {
                    if (!(otherObj instanceof MoserObject)) continue;
                    this.remapPropertySetByUser((MoserObject)otherObj);
                }
                continue;
            }
            if (!(obj instanceof MoserObject)) continue;
            this.remapPropertySetByUser((MoserObject)obj);
        }
    }

    private void remapProperty(List<PropertyType> property) {
        for (PropertyType prop : property) {
            if (!this.remaps.containsKey((Object)prop.getName())) continue;
            prop.setName((String)this.remaps.get((Object)prop.getName()));
        }
    }

    private void remapPropertyOverride(List<String> propertyOverride) {
        for (int i = 0; i < propertyOverride.size(); ++i) {
            String override = propertyOverride.get(i).replace("property.", "");
            if (!this.remaps.containsKey((Object)override)) continue;
            propertyOverride.set(i, "property." + (String)this.remaps.get((Object)override));
        }
    }
}

