/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.FeatureObject;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.core.utils.migration.MigratorPropSetByUser;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import com.ibm.bi.platform.moser.core.utils.migration.Version;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MigratorVersion5_0
extends MigratorPropSetByUser {
    private static final String STARTING_VERSION = "5.0";
    private static final String TARGET_VERSION = "5.0";
    private static final Set<String> R9_FEATURES = new HashSet<String>();
    private static final Set<String> R9_PROPERTIES;

    public MigratorVersion5_0(ModuleMigrator successor) {
        super(successor, "5.0", "5.0");
    }

    @Override
    public boolean isApplicable(Module module) {
        Version v = new Version(module.getVersion());
        if (!v.equals(this.versionRange[0])) {
            return false;
        }
        return this.fromR8Origin((MoserObject)module);
    }

    private boolean fromR8Origin(MoserObject o) {
        for (FeatureObject feature : o.getFeatureList(null)) {
            String featureName = feature.getFeatureName();
            Object obj = o.basicGet(feature.getFeatureID());
            if (obj == null) continue;
            if (R9_FEATURES.contains(featureName)) {
                return false;
            }
            if ("property".equals(featureName)) {
                if (MigratorVersion5_0.propertyFromR8Origin((List)obj)) continue;
                return false;
            }
            if ("propertyOverride".equals(featureName)) {
                if (MigratorVersion5_0.propertyOverrideFromR8Origin((List)obj)) continue;
                return false;
            }
            if (feature.getIsList()) {
                for (Object otherObj : (List)obj) {
                    if (!(otherObj instanceof MoserObject) || this.fromR8Origin((MoserObject)otherObj)) continue;
                    return false;
                }
                continue;
            }
            if (!(obj instanceof MoserObject) || this.fromR8Origin((MoserObject)obj)) continue;
            return false;
        }
        return true;
    }

    private static boolean propertyFromR8Origin(List<PropertyType> property) {
        for (PropertyType prop : property) {
            if (!R9_PROPERTIES.contains(prop.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean propertyOverrideFromR8Origin(List<String> propertyOverride) {
        for (String p : propertyOverride) {
            if (!R9_FEATURES.contains(p) && !R9_PROPERTIES.contains(p.replace("property.", ""))) continue;
            return false;
        }
        return true;
    }

    static {
        R9_FEATURES.add("jdbc");
        R9_FEATURES.add("csvUrl");
        R9_FEATURES.add("jdbcUrl");
        R9_FEATURES.add("driverClassName");
        R9_FEATURES.add("connectionProperties");
        R9_PROPERTIES = new HashSet<String>();
        R9_PROPERTIES.add("propertySetByUser_168");
        R9_PROPERTIES.add("propertySetByUser_169");
        R9_PROPERTIES.add("propertySetByUser_170");
        R9_PROPERTIES.add("propertySetByUser_171");
        R9_PROPERTIES.add("propertySetByUser_172");
    }
}

