/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlQueryType;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MigratorVersion8_2
extends ModuleMigrator {
    private static final String LOW_VERSION = "7.1";
    private static final String HIGH_VERSION = "8.2";
    private static final String MUI_P_KEY = "build_table";
    private static final String MUI_STAGE = "stage";
    private static final String COPY = "Copy";
    private static final String VIEW = "View";

    public MigratorVersion8_2(ModuleMigrator successor) {
        super(successor, LOW_VERSION, HIGH_VERSION);
    }

    @Override
    protected boolean upversion(Module module) {
        List allQS = module.basicGetQuerySubject();
        if (allQS == null) {
            return true;
        }
        HashMap<String, Pair<QuerySubject, JSONObject>> qsMap = new HashMap<String, Pair<QuerySubject, JSONObject>>();
        ArrayList<QuerySubject> qsToUpgrade = new ArrayList<QuerySubject>();
        for (QuerySubject qs : allQS) {
            qsToUpgrade.add(qs);
            JSONObject jsonProp = this.getQuerySubjectProperty(qs);
            qsMap.put(qs.getIdentifier(), new Pair<QuerySubject, JSONObject>(qs, jsonProp));
        }
        ArrayList<QuerySubject> qsToDefer = new ArrayList<QuerySubject>();
        boolean bDoAgain = false;
        do {
            for (QuerySubject currentQS : qsToUpgrade) {
                this.migrate(currentQS, qsMap, qsToDefer);
            }
            boolean bl = bDoAgain = !qsToDefer.isEmpty() && qsToDefer.size() < qsToUpgrade.size();
            if (!bDoAgain) continue;
            qsToUpgrade.clear();
            qsToUpgrade.addAll(qsToDefer);
            qsToDefer.clear();
        } while (bDoAgain);
        return true;
    }

    private JSONObject getQuerySubjectProperty(QuerySubject currentQS) {
        if (currentQS.basicGetProperty() == null) {
            return null;
        }
        for (PropertyType pt : currentQS.getProperty()) {
            if (!MUI_P_KEY.equals(pt.getName())) continue;
            try {
                return JSONObject.parse((String)pt.getValue());
            }
            catch (IOException e) {
                LoggerAdapter.debug(this, e.getMessage());
                break;
            }
        }
        return null;
    }

    private void migrate(QuerySubject currentQS, Map<String, Pair<QuerySubject, JSONObject>> qsMap, List<QuerySubject> qsToDefer) {
        if (currentQS.getClassifier() == null) {
            boolean sqlIsSet;
            if (MigratorVersion8_2.isView(currentQS, qsMap)) {
                currentQS.setSqlQuery(null);
                currentQS.setQueryOperation(null);
                currentQS.setJoinOperation(null);
                currentQS.setClassifier(QsClassifierType.QUERY_SUBJECT);
                return;
            }
            if (MigratorVersion8_2.isCopy(currentQS, qsMap)) {
                QuerySubject original = MigratorVersion8_2.getCopyOriginal(currentQS, qsMap);
                if (original == null) {
                    LoggerAdapter.debug(this, "Could not find and migrate original for copy query subject " + currentQS.getIdentifier());
                    return;
                }
                if (original.getClassifier() == null) {
                    qsToDefer.add(currentQS);
                    return;
                }
                currentQS.setClassifier(original.getClassifier());
                try {
                    switch (currentQS.getClassifier()) {
                        case JOIN_QUERY_SUBJECT: {
                            currentQS.setSqlQuery(null);
                            currentQS.setQueryOperation(null);
                            currentQS.setJoinOperation((QuerySubject.JoinOperation)original.getJoinOperation().clone());
                            break;
                        }
                        case OPERATION_QUERY_SUBJECT: {
                            currentQS.setJoinOperation(null);
                            currentQS.setSqlQuery(null);
                            currentQS.setQueryOperation((QuerySubject.QueryOperation)original.getQueryOperation().clone());
                            break;
                        }
                        case SQL_QUERY_SUBJECT: {
                            currentQS.setJoinOperation(null);
                            currentQS.setQueryOperation(null);
                            currentQS.setSqlQuery((SqlQueryType)original.getSqlQuery().clone());
                            break;
                        }
                        default: {
                            currentQS.setSqlQuery(null);
                            currentQS.setQueryOperation(null);
                            currentQS.setJoinOperation(null);
                            break;
                        }
                    }
                }
                catch (CloneNotSupportedException e) {
                    LoggerAdapter.debug(this, e.getMessage());
                }
                return;
            }
            boolean joinIsSet = currentQS.getJoinOperation() != null;
            boolean queryIsSet = currentQS.getQueryOperation() != null;
            boolean bl = sqlIsSet = currentQS.getSqlQuery() != null;
            if (joinIsSet && !queryIsSet && !sqlIsSet) {
                currentQS.setClassifier(QsClassifierType.JOIN_QUERY_SUBJECT);
                return;
            }
            if (!joinIsSet && queryIsSet && !sqlIsSet) {
                currentQS.setClassifier(QsClassifierType.OPERATION_QUERY_SUBJECT);
                return;
            }
            if (!joinIsSet && !queryIsSet && sqlIsSet) {
                currentQS.setClassifier(QsClassifierType.SQL_QUERY_SUBJECT);
                return;
            }
            currentQS.setClassifier(QsClassifierType.QUERY_SUBJECT);
            return;
        }
        switch (currentQS.getClassifier()) {
            case JOIN_QUERY_SUBJECT: {
                currentQS.setSqlQuery(null);
                currentQS.setQueryOperation(null);
                break;
            }
            case OPERATION_QUERY_SUBJECT: {
                currentQS.setJoinOperation(null);
                currentQS.setSqlQuery(null);
                break;
            }
            case SQL_QUERY_SUBJECT: {
                currentQS.setJoinOperation(null);
                currentQS.setQueryOperation(null);
                break;
            }
        }
    }

    private static QuerySubject getCopyOriginal(QuerySubject currentQS, Map<String, Pair<QuerySubject, JSONObject>> qsMap) {
        JSONArray objRefs;
        Pair<QuerySubject, JSONObject> p = qsMap.get(currentQS.getIdentifier());
        if (p == null || p.getSecond() == null) {
            return null;
        }
        if (COPY.equals(p.getSecond().get((Object)MUI_STAGE)) && (objRefs = (JSONArray)p.getSecond().get((Object)"moserObjectRefs")) != null && objRefs.size() == 1 && (p = qsMap.get(objRefs.get(0))) != null) {
            return p.getFirst();
        }
        return null;
    }

    private static boolean isCopy(QuerySubject currentQS, Map<String, Pair<QuerySubject, JSONObject>> qsMap) {
        Pair<QuerySubject, JSONObject> p = qsMap.get(currentQS.getIdentifier());
        if (p == null || p.getSecond() == null) {
            return false;
        }
        return COPY.equals(p.getSecond().get((Object)MUI_STAGE));
    }

    private static boolean isView(QuerySubject currentQS, Map<String, Pair<QuerySubject, JSONObject>> qsMap) {
        Pair<QuerySubject, JSONObject> p = qsMap.get(currentQS.getIdentifier());
        if (p == null || p.getSecond() == null) {
            return false;
        }
        return VIEW.equals(p.getSecond().get((Object)MUI_STAGE));
    }
}

