/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.core.utils.migration.Version;

public abstract class ModuleMigrator {
    private ModuleMigrator successor = null;
    protected boolean success = false;
    protected final Version[] versionRange;

    public ModuleMigrator(ModuleMigrator successor, String lowVersion, String highVersion) {
        this.successor = successor;
        this.versionRange = new Version[2];
        this.versionRange[0] = new Version(lowVersion);
        this.versionRange[1] = new Version(highVersion);
    }

    public boolean migrate(Module module) {
        if (this.isApplicable(module)) {
            this.setSuccessful(this.upversion(module));
            if (this.isSuccessful()) {
                module.setVersion(this.version());
            }
        } else {
            this.setSuccessful(true);
        }
        if (this.version().equals("11.1") || this.successor == null) {
            return this.isSuccessful();
        }
        return this.successor.migrate(module);
    }

    protected boolean isApplicable(Module module) {
        Version v = new Version(module.getVersion());
        return v.compareTo(this.versionRange[0]) >= 0 && v.compareTo(this.versionRange[1]) < 0;
    }

    protected abstract boolean upversion(Module var1);

    public String version() {
        return this.versionRange[1].getVersion();
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }
}

