/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.core.utils.migration.ModuleMigrator;
import com.ibm.bi.platform.moser.core.utils.migration.Version;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleMigrator9_0
extends ModuleMigrator {
    private static final String LOW_VERSION = "8.2";
    private static final String HIGH_VERSION = "9.0";
    private static final String MUI_PREFIX = "_MUI_";
    private static final String PROPERTY_PREFIX = "property.";
    private static final List<String> ui_properties;
    private static final List<String> _ui_properties;
    private static final List<String> properties;
    private static Map<String, String> UI_PROPERTY_MAPPER;
    private static Map<String, String> UI_PROPERTY_OVERIDE_MAPPER;
    private static String PROPERTY_SET_BY_USER;
    private static String PROPERTY_OVERIDE_SET_BY_USER;
    private static String SECURITY_FILTER;
    private static String SECURITY_FILTER_NEW;

    public ModuleMigrator9_0(ModuleMigrator successor) {
        super(successor, LOW_VERSION, HIGH_VERSION);
    }

    @Override
    protected boolean isApplicable(Module module) {
        Version v = new Version(module.getVersion());
        return v.compareTo(this.versionRange[0]) >= 0 && v.compareTo(this.versionRange[1]) <= 0;
    }

    @Override
    protected boolean upversion(Module module) {
        this.traverseAndRenameUIProperties(module);
        return true;
    }

    private static void renameUIProperties(List<? extends ObjectType> list) {
        if (list != null) {
            for (ObjectType objectType : list) {
                ModuleMigrator9_0.renameUIProperties(objectType);
            }
        }
    }

    private static void renameUIProperties(ObjectType object) {
        String newName;
        String name;
        if (object.basicGetProperty() == null) {
            return;
        }
        for (PropertyType pt : object.getProperty()) {
            name = pt.getName();
            if (name == null) continue;
            newName = UI_PROPERTY_MAPPER.get(name);
            if (newName != null) {
                pt.setName(newName);
                continue;
            }
            if (name.startsWith(PROPERTY_SET_BY_USER)) {
                pt.setName(MUI_PREFIX + name);
                continue;
            }
            if (!name.startsWith(SECURITY_FILTER)) continue;
            pt.setName(SECURITY_FILTER_NEW);
        }
        List overides = object.basicGetPropertyOverride();
        if (overides == null) {
            return;
        }
        for (int i = 0; i < overides.size(); ++i) {
            name = (String)overides.get(i);
            newName = UI_PROPERTY_OVERIDE_MAPPER.get(name);
            if (newName != null) {
                overides.set(i, newName);
                continue;
            }
            if (!name.startsWith(PROPERTY_OVERIDE_SET_BY_USER)) continue;
            overides.set(i, name.replaceFirst(PROPERTY_PREFIX, "property._MUI_"));
        }
    }

    private void traverseAndRenameUIProperties(Module module) {
        ModuleMigrator9_0.renameUIProperties((ObjectType)module);
        ModuleMigrator9_0.renameUIProperties(module.basicGetCalculation());
        ModuleMigrator9_0.renameUIProperties(module.basicGetDrillGroup());
        ModuleMigrator9_0.renameUIProperties(module.basicGetFilter());
        if (module.basicGetQuerySubject() != null) {
            for (QuerySubject object : module.getQuerySubject()) {
                ModuleMigrator9_0.renameUIProperties((ObjectType)object);
                ModuleMigrator9_0.renameUIProperties(object.basicGetFilter());
                ModuleMigrator9_0.renameUIProperties(object.basicGetSecurityFilter());
                this.traverseAndRenameUIProperties(object.basicGetItem());
            }
        }
    }

    private void traverseAndRenameUIProperties(List<ItemType> items) {
        if (items == null) {
            return;
        }
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                ModuleMigrator9_0.renameUIProperties((ObjectType)item.getQueryItem());
                this.traverseAndRenameUIProperties(item.getQueryItem().basicGetItem());
                continue;
            }
            if (item.getCalculation() != null) {
                ModuleMigrator9_0.renameUIProperties((ObjectType)item.getCalculation());
                continue;
            }
            if (item.getFilter() != null) {
                ModuleMigrator9_0.renameUIProperties((ObjectType)item.getFilter());
                continue;
            }
            if (item.getFolder() == null) continue;
            ModuleMigrator9_0.renameUIProperties((ObjectType)item.getFolder());
            this.traverseAndRenameUIProperties(item.getFolder().basicGetItem());
        }
    }

    static {
        String s;
        ui_properties = Arrays.asList("ui_grid", "ui_expr", "ui_data_cache", "ui_members_display_limit", "ui_members_custom_limit", "ui_members_include_link", "ui_show_table_details");
        _ui_properties = Arrays.asList("_uiFilterSpec", "_uiCalculationSpec");
        properties = Arrays.asList("customCalculation", "calculationType", "simpleCalculation", "customBin", "customBinNR", "makeLabeledRange", "makeTextBuckets", "customGroup", "clean", "substringFuncStartParam", "substringFuncCountParam", "convertCaseFunc", "trimAllFunc", "nullif", "replaceNulls", "split", "splitOrigin", "propertySetByUser", "format", "autoBinV2", "rangeBin", "manualBin", "moduleLocationPath", "build_table", "normalizationLayoutOptions", "diagramNodePosition", "diagramLegendPosition", "diagramZoomAndPan", "diagramCardinality", "diagramDegreeOfSeparation", "diagramContextMode", "diagramZoomControlPosition");
        UI_PROPERTY_MAPPER = new HashMap<String, String>();
        UI_PROPERTY_OVERIDE_MAPPER = new HashMap<String, String>();
        PROPERTY_SET_BY_USER = "propertySetByUser_";
        PROPERTY_OVERIDE_SET_BY_USER = PROPERTY_PREFIX + PROPERTY_SET_BY_USER;
        SECURITY_FILTER = "_uiFilterSpec_";
        SECURITY_FILTER_NEW = "_MUI_FilterSpec";
        for (String name : ui_properties) {
            s = name.replace("ui_", MUI_PREFIX);
            UI_PROPERTY_MAPPER.put(name, s);
            UI_PROPERTY_OVERIDE_MAPPER.put(PROPERTY_PREFIX.concat(name), PROPERTY_PREFIX.concat(s));
        }
        for (String name : _ui_properties) {
            s = name.replace("_ui", MUI_PREFIX);
            UI_PROPERTY_MAPPER.put(name, s);
            UI_PROPERTY_OVERIDE_MAPPER.put(PROPERTY_PREFIX.concat(name), PROPERTY_PREFIX.concat(s));
        }
        for (String name : properties) {
            s = MUI_PREFIX.concat(name);
            UI_PROPERTY_MAPPER.put(name, s);
            UI_PROPERTY_OVERIDE_MAPPER.put(PROPERTY_PREFIX.concat(name), PROPERTY_PREFIX.concat(s));
        }
    }
}

