/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.utils.migration;

public class Version
implements Comparable<Version> {
    private final String originalVersion;
    private final int major;
    private final int minor;
    private final int build;

    public Version(String version) {
        this.originalVersion = version == null ? "1.0" : version;
        String[] majorMinorBuild = this.originalVersion.split("\\.");
        if (majorMinorBuild.length < 2) {
            throw new IllegalArgumentException("Unexpected version string: " + version);
        }
        this.major = Integer.parseInt(majorMinorBuild[0]);
        this.minor = Integer.parseInt(majorMinorBuild[1]);
        this.build = majorMinorBuild.length > 2 ? Integer.parseInt(majorMinorBuild[2]) : 0;
    }

    public String getVersion() {
        return this.originalVersion;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.build;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.build == other.build;
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.build < other.build) {
            return -1;
        }
        if (this.build > other.build) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(Integer.toString(this.major));
        result.append('.');
        result.append(Integer.toString(this.minor));
        result.append('.');
        result.append(Integer.toString(this.build));
        return result.toString();
    }
}

