/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.wkc.core.provider.jdbc.metadata;

import com.ibm.bi.platform.moser.common.exceptions.metadata.EmptyOrInaccessibleSchemaException;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.core.api.json.datasource.ModulesResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasData;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesBody;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesResponse;
import com.ibm.bi.platform.moser.core.cm.Connection;
import com.ibm.bi.platform.moser.core.cm.DBDescriptor;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.JDBCMetadataProvider;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JDBCWKCMetadataProvider
extends JDBCMetadataProvider {
    public SchemasResponse getSchemas(String databaseName, Connection connection, ProviderProperties props) throws Exception {
        String[] sPprops = WKCUtil.getUrlUserPassword(props);
        List<WKCUtil.WKCConnection> wkcConnections = WKCUtil.getAllConnections(databaseName, connection.getName(), sPprops[1], sPprops[2], sPprops[0], null, null);
        SchemasResponse resp = new SchemasResponse();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (WKCUtil.WKCConnection wkcConn : wkcConnections) {
            JDBCProviderProperties jdbcProps = wkcConn.getJDBCProp();
            try {
                Map<String, List<String>> catsAndSchemas = super.getCatalogsAndSchemas(jdbcProps, exceptions);
                for (Map.Entry<String, List<String>> entry : catsAndSchemas.entrySet()) {
                    String catalog = entry.getKey();
                    List<String> schemas = entry.getValue();
                    for (String schema : schemas) {
                        SchemasData item = new SchemasData();
                        item.setCatalog(catalog);
                        item.setSchema(schema);
                        String id = WKCUtil.buildFullName(wkcConn, catalog, schema);
                        item.setId(id);
                        item.setSchemaType(DBDescriptor.getSchemaType(jdbcProps.getUrl(), catalog, schema));
                        item.put("defaultName", id);
                        String idMoser = WKCUtil.buildIdentifier(databaseName, connection.getName(), catalog, schema, wkcConn);
                        item.put("moserSchemaId", idMoser);
                        item.put("specification", WKCUtil.generateSpecification(wkcConn));
                        resp.addData(item);
                    }
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        resp.setMeta("connectionString", connection.getConnectionString());
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public TablesResponse getTablesResponse(String cmDSName, String catalog, String schema, String table, TablesBody tablesBody, Map<String, String> vendor, Connection connection, ProviderProperties props) throws Exception {
        String[] catConn = new String[]{null, null};
        JDBCProviderProperties jdbcProp = WKCUtil.getJDBCProviderProperties(cmDSName, catalog, schema, table, MoserJDBCImporter.getInOrExcludedTablesFromTablesBody(tablesBody), vendor, connection, props, catConn);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<String, Object> feedBack = new HashMap<String, Object>();
        List<String> tables = super.getTables(jdbcProp, exceptions, feedBack);
        if (!exceptions.isEmpty() && tables.isEmpty()) {
            throw (Exception)exceptions.get(0);
        }
        TablesResponse resp = new TablesResponse(tables);
        resp.setMeta("connectionString", connection.getConnectionString());
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public ModulesResponse getPhysicalModuleResponse(String cmDSName, String catalog, String schema, String table, TablesBody tablesBody, Map<String, String> vendor, Connection connection, ProviderProperties props) throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<String, Object> feedBack = new HashMap<String, Object>();
        Module module = this.getPhysicalModule(cmDSName, catalog, schema, table, MoserJDBCImporter.getInOrExcludedTablesFromTablesBody(tablesBody), vendor, connection, props, exceptions, feedBack);
        if (module == null) {
            if (!exceptions.isEmpty()) {
                throw (Exception)exceptions.get(0);
            }
            throw new EmptyOrInaccessibleSchemaException(MoserUtil.buildSchemaDefaultName(cmDSName, catalog, schema));
        }
        ModulesResponse resp = new ModulesResponse(null, module, DBDescriptor.getNumOfTablesFromFeedback(feedBack));
        resp.setMeta("connectionString", connection.getConnectionString());
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public Module getPhysicalModule(String cmDSName, String catalog, String schema, String table, Pair<Set<String>, Set<String>> inOrExcludedTables, Map<String, String> vendor, Connection connection, ProviderProperties props, List<Exception> exceptions, Map<String, Object> feedBack) throws Exception {
        String[] catConn = new String[]{null, null, null};
        JDBCProviderProperties jdbcProp = WKCUtil.getJDBCProviderProperties(cmDSName, catalog, schema, table, inOrExcludedTables, vendor, connection, props, catConn);
        Module module = super.getPhysicalModule(jdbcProp, exceptions, feedBack);
        if (module == null) {
            return null;
        }
        module.setIdentifier("physicalmodule");
        module.setContainer(WKCUtil.getContainer(cmDSName, connection.getName(), catConn[0], catConn[1], catalog, schema, ":", true));
        List srcs = module.basicGetDataSource();
        if (srcs != null && !srcs.isEmpty()) {
            DataSource aSrc = (DataSource)srcs.get(0);
            aSrc.setName(WKCUtil.getContainer(cmDSName, connection.getName(), catConn[0], catConn[1], catalog, schema, ".", false));
            aSrc.setCmDataSource(null);
            aSrc.setDatabaseType("wkc");
            aSrc.setConnectionString(WKCUtil.buildWKCDatasourceConnectionString(cmDSName, connection.getName(), catConn));
        }
        return module;
    }
}

