/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.wkc.core.utils;

import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class DatabaseTypeProperty {
    protected JDBCProviderProperties jdbcProp;
    protected Set<URLParam> params;
    protected String xqeDBTypeCode;

    public DatabaseTypeProperty(String dbCode, JDBCProviderProperties jdbc, Set<URLParam> param) {
        this.xqeDBTypeCode = dbCode;
        this.jdbcProp = jdbc;
        this.params = param;
    }

    public String getXQEDBTypeCode() {
        return this.xqeDBTypeCode;
    }

    public String getURL(Map<URLParam, Object> values) {
        ArrayList<String> lst = new ArrayList<String>();
        for (Map.Entry<URLParam, Object> entry : values.entrySet()) {
            URLParam k = entry.getKey();
            Object v = entry.getValue();
            if (!this.params.contains((Object)k)) continue;
            lst.add(v.toString());
        }
        String[] a = lst.toArray(new String[0]);
        return String.format(this.jdbcProp.getUrl(), a);
    }

    public boolean hasReqiredParams(Map<URLParam, Object> values) {
        for (URLParam v : this.params) {
            if (values.containsKey((Object)v)) continue;
            return false;
        }
        return true;
    }

    public static enum URLParam {
        HOST("host"),
        PORT("port"),
        SERVICE_NAME("service_name"),
        ACCOUNT_NAME("account_name"),
        WAREHOUSE("warehouse"),
        DATABASE("database"),
        SERVER("server"),
        CREDENTIALS("credentials");

        private final String v;

        private URLParam(String val) {
            this.v = val;
        }

        public String getValue() {
            return this.v;
        }

        public static URLParam fromString(String in) {
            if (in != null) {
                for (URLParam current : URLParam.values()) {
                    if (!in.equals(current.v)) continue;
                    return current;
                }
            }
            return null;
        }
    }
}

