/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.wkc.core.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.utils.DatabaseTypeProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;

public class WKCDatabaseTypeToXQE {
    public static final String DBTYPE_DB2_CODE = "JD-D2";
    public static final String FILE_EXT_JSON = ".json";
    public static final String FILE_EXT_PEM = ".pem";
    protected static final String DB2_SSL = "sslConnection";
    protected static final String DB2_SSL_LOCATION = "sslCertLocation";
    protected static final String EQ = "=";
    protected static final String SEMICOLON = ";";
    protected String tmpFileExt = ".json";
    private static WKCDatabaseTypeToXQE instance = new WKCDatabaseTypeToXQE();
    private static final String INVALID_TEMP_FILE = "*this is an invalid file";
    private static final String PART_1 = "PRI";
    private static final String PART_2 = "VATE";
    private static final String PART_3 = " KE";
    private static final String PART_4 = "Y-----";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_KEY = "-----END PRIVATE KEY-----";
    protected LoadingCache<String, String> credentialsCache = null;
    protected File tempWKCDir = null;
    protected ConcurrentHashMap<String, DatabaseTypeProperty> supportedDatabaseTypes = new ConcurrentHashMap();

    public static WKCDatabaseTypeToXQE getInstance() {
        return instance;
    }

    /*
     * Exception decompiling
     */
    protected static JSONObject getWKCDatabaseTypes(WKCDatabaseTypeToXQE o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WKCDatabaseTypeToXQE() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTempFilePath(String credentials, String ext) {
        if (this.credentialsCache == null) {
            return null;
        }
        WKCDatabaseTypeToXQE wKCDatabaseTypeToXQE = this;
        synchronized (wKCDatabaseTypeToXQE) {
            this.tmpFileExt = ext;
            String f = (String)this.credentialsCache.getUnchecked((Object)credentials);
            if (INVALID_TEMP_FILE.equals(f)) {
                return null;
            }
            return f;
        }
    }

    protected void initWKCCache() {
        try {
            this.tempWKCDir = MoserUtil.createTempDirectory("wkc");
            this.tempWKCDir.deleteOnExit();
        }
        catch (Exception e) {
            LoggerAdapter.error((Object)this, "Failed to create WKC temp dir", e);
            return;
        }
        CacheLoader<String, String> loader = new CacheLoader<String, String>(){

            public String load(String key) {
                try {
                    File tmpFile = File.createTempFile("wkc", WKCDatabaseTypeToXQE.getInstance().tmpFileExt, WKCDatabaseTypeToXQE.this.tempWKCDir);
                    tmpFile.deleteOnExit();
                    try (FileWriterWithEncoding fw = new FileWriterWithEncoding(tmpFile.getAbsoluteFile(), "UTF-8");
                         BufferedWriter writer = new BufferedWriter((Writer)fw);){
                        writer.write(key);
                    }
                    return tmpFile.getCanonicalPath();
                }
                catch (Exception e1) {
                    LoggerAdapter.error((Object)this, "Failed to create WKC temp file", e1);
                    return WKCDatabaseTypeToXQE.INVALID_TEMP_FILE;
                }
            }
        };
        RemovalListener<String, String> listener = new RemovalListener<String, String>(){

            public void onRemoval(RemovalNotification<String, String> n) {
                String filePath;
                if (n.wasEvicted() && !WKCDatabaseTypeToXQE.INVALID_TEMP_FILE.equals(filePath = (String)n.getValue())) {
                    File fileToDelete = FileUtils.getFile((String[])new String[]{filePath});
                    FileUtils.deleteQuietly((File)fileToDelete);
                }
            }
        };
        this.credentialsCache = CacheBuilder.newBuilder().maximumSize(MoserConfig.getWKCCredentialsLimit()).removalListener((RemovalListener)listener).build((CacheLoader)loader);
    }

    protected void loadWKCDatabaseTypes(JSONObject config) {
        if (config == null) {
            return;
        }
        JSONArray types = (JSONArray)config.get((Object)"WKCDatabaseTypes");
        if (types == null) {
            return;
        }
        for (Object type : types) {
            JSONObject tp = (JSONObject)type;
            TreeSet<DatabaseTypeProperty.URLParam> param = new TreeSet<DatabaseTypeProperty.URLParam>();
            JSONArray required = (JSONArray)tp.get((Object)"requiredParam");
            if (required == null) continue;
            for (Object element : required) {
                DatabaseTypeProperty.URLParam p = DatabaseTypeProperty.URLParam.fromString((String)element);
                if (p == null) continue;
                param.add(p);
            }
            if (param.isEmpty()) continue;
            String vender = (String)tp.get((Object)"vendor");
            String xqeCD = (String)tp.get((Object)"xqeDBCode");
            String drv = (String)tp.get((Object)"driverClass");
            String url = (String)tp.get((Object)"urlPattern");
            if (vender == null || vender.isEmpty() || xqeCD == null || xqeCD.isEmpty() || drv == null || drv.isEmpty() || url == null || url.isEmpty()) continue;
            JDBCProviderProperties jdbcProp = new JDBCProviderProperties();
            jdbcProp.setDriverClass(drv);
            jdbcProp.setUrl(url);
            DatabaseTypeProperty prop = new DatabaseTypeProperty(xqeCD, jdbcProp, param);
            this.supportedDatabaseTypes.put(vender, prop);
        }
    }

    public DatabaseTypeProperty getDataTypeProperty(String dsName) {
        return this.supportedDatabaseTypes.get(dsName);
    }

    public String getXQEDatabaseCode(String dbType) {
        DatabaseTypeProperty p = this.supportedDatabaseTypes.get(dbType);
        if (p != null) {
            return p.getXQEDBTypeCode();
        }
        return dbType;
    }

    public static void addExtraProperties(String dsType, JSONObject connProp, Properties properties, JDBCProviderProperties jdbcProps) {
        switch (dsType) {
            case "JD-D2": {
                WKCDatabaseTypeToXQE.addDB2Properties(connProp, properties, jdbcProps);
                break;
            }
        }
    }

    protected static void addDB2Properties(JSONObject connProp, Properties properties, JDBCProviderProperties jdbcProps) {
        String f;
        String sslCert;
        String ssl = (String)connProp.get((Object)"ssl");
        if ("true".equals(ssl)) {
            properties.setProperty(DB2_SSL, ssl);
            jdbcProps.setProperty(DB2_SSL, ssl);
        }
        if ((sslCert = (String)connProp.get((Object)"ssl_certificate")) != null && !sslCert.isEmpty() && (f = WKCDatabaseTypeToXQE.getInstance().getTempFilePath(sslCert, FILE_EXT_PEM)) != null) {
            properties.setProperty(DB2_SSL_LOCATION, f);
            jdbcProps.setProperty(DB2_SSL_LOCATION, f);
        }
    }

    public static String addExtraPropertiesToConnectionString(String connString, String dbTypeCode, JDBCProviderProperties jdbcProps) {
        switch (dbTypeCode) {
            case "JD-D2": {
                return WKCDatabaseTypeToXQE.addDB2PropertiesToConnectionString(connString, jdbcProps);
            }
        }
        return connString;
    }

    protected static String addDB2PropertiesToConnectionString(String connString, JDBCProviderProperties jdbcProps) {
        String ssl = jdbcProps.getProperty(DB2_SSL);
        String sslCert = jdbcProps.getProperty(DB2_SSL_LOCATION);
        if (ssl == null && sslCert == null) {
            return connString;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(connString);
        if (ssl != null) {
            sb.append(DB2_SSL);
            sb.append(EQ);
            sb.append(ssl);
            sb.append(SEMICOLON);
        }
        if (sslCert != null) {
            sb.append(DB2_SSL_LOCATION);
            sb.append(EQ);
            sb.append(sslCert);
            sb.append(SEMICOLON);
        }
        return sb.toString();
    }

    static {
        JSONObject config = WKCDatabaseTypeToXQE.getWKCDatabaseTypes(instance);
        instance.loadWKCDatabaseTypes(config);
        instance.initWKCCache();
    }
}

