/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.wkc.core.utils;

import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.ma.LogonFailureException;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.platform.wkc.core.rest.service.WatsonKnowledgeCenterService;
import com.ibm.bi.platform.wkc.core.utils.DatabaseTypeProperty;
import com.ibm.bi.platform.wkc.core.utils.WKCDatabaseTypeToXQE;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;

public class WKCTokenManager {
    private static WKCTokenManager instance = new WKCTokenManager();
    protected ConcurrentHashMap<Pair<String, String>, WKCTokenInfo> cachedTokens = new ConcurrentHashMap();

    public static WKCTokenManager getInstance() {
        return instance;
    }

    private WKCTokenManager() {
    }

    public WKCTokenInfo getToken(String url, String user, String pw, String cmDSName, String cmConnName, Long expireInterval, WatsonKnowledgeCenterService theWKCService) throws Exception {
        String tk;
        String cd;
        JSONObject json;
        RESTClientResponse resp;
        long expire;
        long d;
        String basic = user + ":" + pw;
        String encodedString = Base64.encodeBase64String((byte[])basic.getBytes(StandardCharsets.UTF_8));
        Pair<String, String> key = new Pair<String, String>(encodedString, url);
        WKCTokenInfo token = this.cachedTokens.get(key);
        long theExpire = expireInterval != null ? expireInterval : MoserConfig.getWKCTokenExpireInterval();
        if (token != null && (d = System.currentTimeMillis() - token.lastTM) < (expire = Math.min(theExpire, token.expireInterval))) {
            return token;
        }
        WatsonKnowledgeCenterService service = theWKCService;
        if (service == null) {
            service = new WatsonKnowledgeCenterService();
        }
        if ((resp = service.logon(url, user, pw)).getResponseCode() == Response.Status.OK.getStatusCode() && (json = resp.getJSONObjectResponse()) != null && "success".equals(cd = (String)json.get((Object)"_messageCode_")) && (tk = (String)json.get((Object)"accessToken")) != null && !tk.isEmpty()) {
            token = new WKCTokenInfo();
            token.lastTM = System.currentTimeMillis();
            token.bearerToken = tk;
            token.expireInterval = theExpire;
            if (this.initializeDSTypes(service, url, token)) {
                this.cachedTokens.put(key, token);
                return token;
            }
        }
        throw new LogonFailureException(cmConnName, cmDSName, 1);
    }

    protected boolean initializeDSTypes(WatsonKnowledgeCenterService wkcService, String url, WKCTokenInfo token) {
        JSONObject json;
        RESTClientResponse resp = wkcService.getDataSourceTypes(url, token.bearerToken);
        if (resp.getResponseCode() == Response.Status.OK.getStatusCode() && (json = resp.getJSONObjectResponse()) != null) {
            this.buildDSTypes(json, token);
            return true;
        }
        return false;
    }

    protected void buildDSTypes(JSONObject json, WKCTokenInfo token) {
        if (json == null) {
            return;
        }
        JSONArray allDSs = (JSONArray)json.get((Object)"resources");
        if (allDSs == null) {
            return;
        }
        for (Object allDS : allDSs) {
            JSONObject aDS = (JSONObject)allDS;
            JSONObject meta = (JSONObject)aDS.get((Object)"metadata");
            JSONObject entity = (JSONObject)aDS.get((Object)"entity");
            if (meta == null || entity == null) continue;
            String assetID = (String)meta.get((Object)"asset_id");
            String assetTP = (String)meta.get((Object)"asset_type");
            String dsName = (String)entity.get((Object)"name");
            String dsType = (String)entity.get((Object)"type");
            String dsSatus = (String)entity.get((Object)"status");
            DatabaseTypeProperty dbTpProp = WKCDatabaseTypeToXQE.getInstance().getDataTypeProperty(dsName);
            if (assetID == null || assetID.isEmpty() || !"datasource_type".equals(assetTP) || !"database".equals(dsType) || !"active".equals(dsSatus) || dbTpProp == null) continue;
            token.wkcDSTypeIdToXQEJDBCProperty.put(assetID, dbTpProp);
        }
    }

    public static final class WKCTokenInfo {
        protected long lastTM;
        protected long expireInterval;
        protected String bearerToken;
        protected Map<String, DatabaseTypeProperty> wkcDSTypeIdToXQEJDBCProperty = new HashMap<String, DatabaseTypeProperty>();

        public Map<String, DatabaseTypeProperty> getWKCDSTypeToJDBC() {
            return this.wkcDSTypeIdToXQEJDBCProperty;
        }
    }
}

